/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Astroid
extends DecoratedCurve {
    public Astroid() {
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-1.25, 1.25, -1.25, 1.25);
    }

    private static double Cube(double t) {
        return t * t * t;
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    @Override
    public double xValue(double t) {
        return Astroid.Cube(Astroid.cos(t));
    }

    @Override
    public double yValue(double t) {
        return Astroid.Cube(Astroid.sin(t));
    }

    @Override
    protected void drawNeededStuff(Graphics2D g, View view, Transform limits, double t) {
        Color saveColor = g.getColor();
        this.setWantedColor(Color.RED);
        this.setStrokeSize(3);
        double xa = Astroid.Cube(Astroid.cos(t));
        double ya = Astroid.Cube(Astroid.sin(t));
        double tx = -3.0 * Astroid.cos(t) * Astroid.cos(t) * Astroid.sin(t);
        double ty = 3.0 * Astroid.sin(t) * Astroid.sin(t) * Astroid.cos(t);
        double m = tx / ty;
        g.setColor(Color.red);
        g.draw(new Line2D.Double(0.0, this.yValue(t) - this.xValue(t) * ty / tx, this.xValue(t) - this.yValue(t) * tx / ty, 0.0));
        g.draw(new Line2D.Double(xa + 0.02, ya + 0.02, xa - 0.02, ya - 0.02));
        g.draw(new Line2D.Double(xa - 0.02, ya + 0.02, xa + 0.02, ya - 0.02));
        g.setColor(Color.green);
        view.setStrokeSizeMultiplier(1);
        g.draw(new Line2D.Double(-10.0, -10.0, 10.0, 10.0));
        g.draw(new Line2D.Double(-10.0, 10.0, 10.0, -10.0));
        g.draw(new Line2D.Double(1.0 / (m - 1.0) * (xa * m + ya), -1.0 / (m - 1.0) * (xa * m + ya), 1.0 / (m + 1.0) * (ya + m * xa), 1.0 / (m + 1.0) * (ya + m * xa)));
        view.setStrokeSizeMultiplier(3);
        g.setColor(saveColor);
    }
}

