/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder3D;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.ode.secondorder3D.ChargedParticles;

public class CurrentInStraightWire
extends ChargedParticles {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.ode.secondorder3D.CurrentInStraightWire.WireDirX", 1.0, 1.0, 0.0);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.ode.secondorder3D.CurrentInStraightWire.WireDirY", 0.0, 0.0, 1.0);
    private RealParamAnimateable cc = new RealParamAnimateable("vmm.ode.secondorder3D.CurrentInStraightWire.WireDirZ", 0.0);
    private RealParamAnimateable dd = new RealParamAnimateable("vmm.ode.secondorder3D.CurrentInStraightWire.Current", 1.0);

    public CurrentInStraightWire() {
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.addParameter(this.dd);
        this.initialDataDefault = new double[]{1.0, 1.0, 0.0, 0.0, 0.3, 0.0, 0.05, 45.0};
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
    }

    @Override
    protected void magneticField(double x, double y, double z, Vector3D answer) {
        double a = this.aa.getValue();
        double b = this.bb.getValue();
        double c = this.cc.getValue();
        double d = this.dd.getValue();
        double denom = Math.sqrt(a * a + b * b + c * c);
        Vector3D wire = denom == 0.0 ? new Vector3D(1.0, 0.0, 0.0) : new Vector3D(a / denom, b / denom, c / denom);
        double wireDotPosition = wire.x * x + wire.y * y + wire.z * z;
        Vector3D normProj = new Vector3D(x - wire.x * wireDotPosition, y - wire.y * wireDotPosition, z - wire.z * wireDotPosition);
        double r = normProj.x * normProj.x + normProj.y * normProj.y + normProj.z * normProj.z;
        Vector3D force = wire.cross(normProj);
        answer.x = force.x * (d / r);
        answer.y = force.y * (d / r);
        answer.z = force.z * (d / r);
    }
}

