/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import vmm.core.Display;
import vmm.core.Transform;
import vmm.core.View;

public class OrbitPoints2D {
    public static final int LINES = 0;
    public static final int DOTS = 1;
    private ArrayList<Point2D> points = new ArrayList();
    private Color color = null;
    private int style = 0;
    private double dotDiameter = 2.5;

    public int getPointCount() {
        return this.points.size();
    }

    public Point2D getPoint(int i) {
        return this.points.get(i);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        if (this.style != style && (style == 1 || style == 0)) {
            this.style = style;
        }
    }

    public double getDotDiameter() {
        return this.dotDiameter;
    }

    public void setDotDiameter(double dotDiameter) {
        this.dotDiameter = dotDiameter < 1.0 ? 1.0 : dotDiameter;
    }

    public void clear() {
        this.points.clear();
    }

    public void addPoint(Point2D pt) {
        this.points.add(pt);
    }

    public void addPoints(Point2D[] pts) {
        if (pts != null & pts.length > 0) {
            for (int i = 0; i < pts.length; ++i) {
                this.points.add(pts[i]);
            }
        }
    }

    public boolean addNow(View view, Point2D pt) {
        this.points.add(pt);
        if (view != null && pt != null && (this.style == 1 || this.points.size() > 1 && this.points.get(this.points.size() - 2) != null)) {
            if (view.beginDrawToOffscreenImage()) {
                if (this.color != null) {
                    view.setColor(this.color);
                }
                this.drawPoint(view, this.points.size() - 1);
                view.endDrawToOffscreenImage();
                Display disp = view.getDisplay();
                if (disp != null) {
                    disp.repaint();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean addNow(View view, Point2D[] pts) {
        if (view != null && pts != null && pts.length > 0) {
            this.addPoints(pts);
            if (view.beginDrawToOffscreenImage()) {
                if (this.color != null) {
                    view.getTransform().getGraphics().setColor(this.color);
                }
                for (int i = this.points.size() - pts.length; i < this.points.size(); ++i) {
                    this.drawPoint(view, i);
                }
                view.endDrawToOffscreenImage();
                Display disp = view.getDisplay();
                if (disp != null) {
                    disp.repaint();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void drawPoint(View view, int index) {
        Point2D p1 = this.points.get(index);
        if (p1 == null) {
            return;
        }
        switch (this.style) {
            case 0: {
                Point2D p0;
                Point2D point2D = p0 = index == 0 ? p1 : this.points.get(index - 1);
                if (p0 == null) {
                    return;
                }
                view.drawLine(p0, p1);
                break;
            }
            case 1: {
                view.drawDot(p1, this.dotDiameter);
            }
        }
    }

    public void draw(Graphics2D g, View view, Transform transform) {
        Color saveColor = g.getColor();
        if (this.color != null) {
            g.setColor(this.color);
        }
        if (this.style == 0) {
            Point2D[] pts = new Point2D[this.points.size()];
            this.points.toArray(pts);
            view.drawCurve(pts);
        } else {
            for (Point2D p : this.points) {
                view.drawDot(p, this.dotDiameter);
            }
        }
        if (this.color != null) {
            g.setColor(saveColor);
        }
    }
}

