/*
 * Decompiled with CFR 0.152.
 */
package vmm.functions;

import vmm.core.Complex;
import vmm.functions.ComplexFunction;
import vmm.functions.EvalStack;
import vmm.functions.ProgFunction;
import vmm.functions.Type;

public class ComplexFunction2
extends ComplexFunction {
    ComplexFunction2(String name, ProgFunction func) {
        super(name, func);
        assert (func.getArgType() == Type.COMPLEX && func.getType() == Type.COMPLEX && func.getArgCount() == 2);
    }

    public synchronized Complex value(Complex z, Complex w) {
        return this.value(z, w, EvalStack.perThread());
    }

    public synchronized Complex value(double z_re, double z_im, double w_re, double w_im) {
        return this.value(z_re, z_im, w_re, w_im, EvalStack.perThread());
    }

    public Complex value(Complex z, Complex w, EvalStack stack) {
        Complex answer = new Complex();
        this.value(z, w, stack, answer);
        return answer;
    }

    public Complex value(double z_re, double z_im, double w_re, double w_im, EvalStack stack) {
        Complex answer = new Complex();
        this.value(z_re, z_im, w_re, w_im, stack, answer);
        return answer;
    }

    public void value(Complex z, Complex w, EvalStack stack, Complex answer) {
        if (answer == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        stack.push(z);
        stack.push(w);
        this.func.apply(stack);
        stack.popComplex(answer);
    }

    public void value(double z_re, double z_im, double w_re, double w_im, EvalStack stack, Complex answer) {
        if (answer == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        stack.push(z_re, z_im);
        stack.push(w_re, w_im);
        this.func.apply(stack);
        stack.popComplex(answer);
    }
}

