/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import vmm.core.Complex;
import vmm.fractals.RepeatedSegmentFractal;

public class KochEscher
extends RepeatedSegmentFractal {
    public KochEscher() {
        this.setDefaultWindow(-2.2, 1.2, -0.4, 2.1);
        this.fractality.reset(0.25, 0.0, 0.3333333333333333);
        this.fractality.setMaximumValueForInput(0.3333333333333333);
        this.fractality.setMinimumValueForInput(0.0);
        this.recursionLevel.reset(9);
        this.colorRepeatFactor = 20;
    }

    @Override
    protected Complex[] computeNextLevel(Complex[] kochCurve, int computedLevel) {
        Complex[] newKochCurve;
        double sqrt3 = Math.sqrt(3.0);
        if (computedLevel == 0) {
            newKochCurve = new Complex[]{new Complex(0.5, sqrt3 / 2.0), new Complex(0.0, 0.0), new Complex(1.0, 0.0), new Complex(0.5, sqrt3 / 2.0), new Complex(0.0, sqrt3), new Complex(1.0, sqrt3), new Complex(0.5, sqrt3 / 2.0), new Complex(-0.5, sqrt3 / 2.0), new Complex(-1.0, sqrt3), new Complex(0.0, sqrt3), new Complex(-0.5, sqrt3 / 2.0), new Complex(-1.0, 0.0), new Complex(0.0, 0.0), new Complex(-0.5, sqrt3 / 2.0), new Complex(-1.5, sqrt3 / 2.0), new Complex(-1.0, sqrt3), new Complex(-2.0, sqrt3), new Complex(-1.5, sqrt3 / 2.0), new Complex(-1.0, 0.0), new Complex(-2.0, 0.0), new Complex(-1.5, sqrt3 / 2.0)};
        } else {
            newKochCurve = new Complex[3 * kochCurve.length - 2];
            double phi = -Math.PI * this.fractality.getValue();
            Complex dir = new Complex((-0.5 + Math.cos(phi)) / 3.0, Math.sin(phi) / 3.0);
            int ct = 0;
            for (int i = 0; i < kochCurve.length - 1; ++i) {
                Complex p1 = kochCurve[i];
                Complex p2 = kochCurve[i + 1];
                Complex midpoint = p1.plus(p2).times(0.5);
                Complex theDirection = p1.minus(p2).times(dir);
                newKochCurve[ct++] = new Complex(p1);
                newKochCurve[ct++] = midpoint.plus(theDirection);
                newKochCurve[ct++] = midpoint.minus(theDirection);
            }
            newKochCurve[ct] = kochCurve[kochCurve.length - 1];
        }
        return newKochCurve;
    }
}

