/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.fractals.RepeatedSegmentFractal;

public class Hilbert
extends RepeatedSegmentFractal {
    @VMMSave
    private int segmentChoice = 2;
    private ActionRadioGroup segmentChoiceSelect;

    public Hilbert() {
        this.fractality.reset(0.5, 0.25, 0.5);
        this.recursionLevel.reset(8);
        this.setDefaultWindow(0.0, 1.0, -0.1, 1.1);
        this.colorRepeatFactor = 4;
        this.fastDrawRecursionLevel = 5;
        this.segmentChoiceSelect = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                Hilbert.this.setSegmentChoice(selectedIndex + 1);
            }
        };
        this.segmentChoiceSelect.addItem("1");
        this.segmentChoiceSelect.addItem("2");
        this.segmentChoiceSelect.addItem("3");
        this.segmentChoiceSelect.addItem("4");
        this.segmentChoiceSelect.setSelectedIndex(this.segmentChoice - 1);
    }

    public int getSegmentChoice() {
        return this.segmentChoice;
    }

    public void setSegmentChoice(int segmentChoice) {
        if (this.segmentChoice != segmentChoice && segmentChoice >= 1 && segmentChoice <= 4) {
            this.segmentChoice = segmentChoice;
            this.segmentChoiceSelect.setSelectedIndex(segmentChoice - 1);
            this.forceRedraw();
        }
    }

    @Override
    public ActionList getActionsForView(View view) {
        ActionList actions = super.getActionsForView(view);
        ActionList submenu = new ActionList(I18n.tr("vmm.fractals.Hilbert.segmentchoice"));
        submenu.add(this.segmentChoiceSelect);
        actions.add(null);
        actions.add(submenu);
        return actions;
    }

    @Override
    protected Complex[] computeNextLevel(Complex[] hilbertCurve, int computedLevel) {
        Complex[] newHilbertCurve;
        double a = Math.min(0.5, Math.max(this.fractality.getValue(), 0.0));
        double r = 0.5 - a;
        double s = Math.sqrt(a - 0.25);
        Complex c = new Complex(r, s);
        Complex ca = new Complex(r + 2.0 * a, s);
        if (computedLevel == 0) {
            newHilbertCurve = this.computeHilbertDecoration();
        } else {
            newHilbertCurve = new Complex[4 * hilbertCurve.length];
            int hl = hilbertCurve.length;
            for (int i = 0; i < hl; ++i) {
                Complex p1 = hilbertCurve[i];
                newHilbertCurve[i] = p1.conj().times(c);
                newHilbertCurve[i + hl] = p1.times(a).plus(c);
                newHilbertCurve[i + 2 * hl] = newHilbertCurve[i + hl].plus(a);
                newHilbertCurve[i + 3 * hl] = p1.conj().times(c.conj()).plus(ca);
            }
        }
        return newHilbertCurve;
    }

    private Complex[] computeHilbertDecoration() {
        Complex[] hilbertDecoration = this.segmentChoice == 1 ? new Complex[]{new Complex(0.02, 0.02), new Complex(0.25, 0.25), new Complex(0.25, 0.75), new Complex(0.75, 0.75), new Complex(0.75, 0.25), new Complex(0.98, 0.02)} : (this.segmentChoice == 2 ? new Complex[]{new Complex(0.25, 0.25), new Complex(0.25, 0.75), new Complex(0.75, 0.75), new Complex(0.75, 0.25)} : (this.segmentChoice == 3 ? new Complex[]{new Complex(0.02, 0.02), new Complex(0.98, 0.02)} : new Complex[]{new Complex(0.02, 0.02), new Complex(0.1, 0.05), new Complex(0.25, 0.5), new Complex(0.5, 0.15), new Complex(0.75, 0.25), new Complex(0.98, 0.02)}));
        return hilbertDecoration;
    }
}

