/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import vmm.core.Complex;
import vmm.fractals.RepeatedSegmentFractal;

public class Dragon
extends RepeatedSegmentFractal {
    public Dragon() {
        this.fractality.reset(0.5, 0.0, 0.5);
        this.fractality.setMaximumValueForInput(0.5);
        this.fractality.setMinimumValueForInput(0.0);
        this.recursionLevel.reset(14);
        this.recursionLevel.setMaximumValueForInput(20);
        this.recursionLevel.setMinimumValueForInput(1);
        this.setDefaultWindow(-1.0, 2.0, -2.0, 1.0);
        this.colorRepeatFactor = 2;
        this.fastDrawRecursionLevel = 10;
    }

    @Override
    protected Complex[] computeNextLevel(Complex[] dragonCurve, int computedLevel) {
        Complex[] newDragonCurve;
        if (computedLevel == 0) {
            newDragonCurve = new Complex[]{new Complex(-1.0, 0.0), new Complex(0.0, -1.0), new Complex(1.0, 0.0)};
        } else {
            newDragonCurve = new Complex[2 * dragonCurve.length - 1];
            double aa = Math.min(0.5, Math.max(this.fractality.getValue(), 0.0));
            Complex aaI = new Complex(0.0, aa);
            int ct = 0;
            for (int i = 0; i < dragonCurve.length - 1; ++i) {
                Complex p1 = dragonCurve[i];
                Complex p2 = dragonCurve[i + 1];
                Complex midpoint = p1.plus(p2).times(0.5);
                Complex theDirection = p2.minus(p1);
                newDragonCurve[ct++] = p1;
                newDragonCurve[ct++] = midpoint.plus(aaI.times(theDirection));
                aaI.im = -aaI.im;
            }
            newDragonCurve[ct] = dragonCurve[dragonCurve.length - 1];
        }
        return newDragonCurve;
    }
}

