/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core3D.Vector3D;

public class Transform3D
extends Transform {
    @VMMSave
    private Vector3D viewPoint;
    @VMMSave
    private double clipDistance;
    @VMMSave
    private Vector3D imagePlaneYDirection = new Vector3D(0.0, 0.0, 1.0);
    @VMMSave
    private boolean orthographicProjection = false;
    private Vector3D viewDirection;
    private double focalLength;
    private Vector3D imagePlaneXDirection;
    private Vector3D tempVector = new Vector3D();
    private Vector3D saveViewDirection;
    private Vector3D saveImagePlaneXDirection;
    private Vector3D saveImagePlaneYDirection;
    private Vector3D saveViewPoint;
    private double objectDisplacementNormalToScreen;

    public Transform3D() {
        this(null, -5.0, 5.0, -5.0, 5.0);
    }

    public Transform3D(Vector3D viewPoint) {
        this(viewPoint, -5.0, 5.0, -5.0, 5.0);
    }

    public Transform3D(Vector3D viewPoint, double nominalGraphicScale) {
        super(nominalGraphicScale);
        this.setViewPoint(viewPoint);
    }

    public Transform3D(Vector3D viewPoint, double xmin, double xmax, double ymin, double ymax) {
        super(xmin, xmax, ymin, ymax);
        this.setViewPoint(viewPoint);
    }

    public Transform3D(Transform tr) {
        super(tr);
        if (tr instanceof Transform3D) {
            Transform3D tr3 = (Transform3D)tr;
            this.viewPoint = new Vector3D(tr3.viewPoint);
            this.viewDirection = new Vector3D(tr3.viewDirection);
            this.imagePlaneXDirection = new Vector3D(tr3.imagePlaneXDirection);
            this.imagePlaneYDirection = new Vector3D(tr3.imagePlaneYDirection);
            this.orthographicProjection = tr3.orthographicProjection;
            this.clipDistance = tr3.clipDistance;
            this.focalLength = tr3.focalLength;
        }
    }

    public boolean getOrthographicProjection() {
        return this.orthographicProjection;
    }

    public void setOrthographicProjection(boolean orthographicProjection) {
        if (this.orthographicProjection == orthographicProjection) {
            return;
        }
        this.orthographicProjection = orthographicProjection;
        this.fireTransformChangeEvent();
    }

    public void setViewPoint(Vector3D viewPoint) {
        this.viewPoint = viewPoint == null ? (viewPoint = new Vector3D(20.0, 0.0, 0.0)) : new Vector3D(viewPoint);
        this.viewDirection = new Vector3D(this.viewPoint);
        this.viewDirection.normalize();
        this.viewDirection.negate();
        this.focalLength = viewPoint.norm();
        this.clipDistance = 0.25 * this.focalLength;
        this.saveViewPoint = new Vector3D(viewPoint);
        this.saveViewDirection = new Vector3D(this.viewDirection);
        this.setImagePlaneYDirection(this.imagePlaneYDirection);
    }

    public Vector3D getViewPoint() {
        return new Vector3D(this.viewPoint);
    }

    public double getClipDistance() {
        return this.clipDistance;
    }

    public void setClipDistance(double clipDistance) {
        if (this.clipDistance == clipDistance) {
            return;
        }
        this.clipDistance = clipDistance;
        this.fireTransformChangeEvent();
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public double getObjectDisplacementNormalToScreen() {
        return this.objectDisplacementNormalToScreen;
    }

    public void setObjectDisplacementNormalToScreen(double objectDisplacementNormalToScreen) {
        if (objectDisplacementNormalToScreen < -0.75 * this.focalLength) {
            objectDisplacementNormalToScreen = -0.75 * this.focalLength;
        } else if (objectDisplacementNormalToScreen > 0.75 * this.focalLength) {
            objectDisplacementNormalToScreen = 0.75 * this.focalLength;
        }
        if (this.objectDisplacementNormalToScreen == objectDisplacementNormalToScreen) {
            return;
        }
        this.objectDisplacementNormalToScreen = objectDisplacementNormalToScreen;
        System.out.println("ObjectDisplacementNormalToScreen = " + objectDisplacementNormalToScreen);
        this.fireTransformChangeEvent();
    }

    public Vector3D getImagePlaneXDirection() {
        return new Vector3D(this.imagePlaneXDirection);
    }

    public Vector3D getImagePlaneYDirection() {
        return new Vector3D(this.imagePlaneYDirection);
    }

    public Vector3D getViewDirection() {
        return new Vector3D(this.viewDirection);
    }

    public void setImagePlaneYDirection(Vector3D viewUp) {
        this.viewDirection = new Vector3D(this.saveViewDirection);
        this.viewPoint = new Vector3D(this.saveViewPoint);
        double projection = this.viewDirection.dot(viewUp);
        this.imagePlaneYDirection = new Vector3D(viewUp.x - projection * this.viewDirection.x, viewUp.y - projection * this.viewDirection.y, viewUp.z - projection * this.viewDirection.z);
        if (this.imagePlaneYDirection.norm() < 1.0E-5) {
            this.imagePlaneYDirection = new Vector3D(-this.viewDirection.z * this.viewDirection.x, -this.viewDirection.z * this.viewDirection.y, 1.0 - this.viewDirection.z * this.viewDirection.z);
        }
        if (this.imagePlaneYDirection.norm() < 1.0E-5) {
            this.imagePlaneYDirection = new Vector3D(-this.viewDirection.y * this.viewDirection.x, 1.0 - this.viewDirection.y * this.viewDirection.y, -this.viewDirection.y * this.viewDirection.z);
        }
        this.imagePlaneYDirection.normalize();
        this.imagePlaneXDirection = this.viewDirection.cross(this.imagePlaneYDirection);
        this.saveImagePlaneXDirection = new Vector3D(this.imagePlaneXDirection);
        this.saveImagePlaneYDirection = new Vector3D(this.imagePlaneYDirection);
        this.fireTransformChangeEvent();
    }

    public void applyTransvection(Vector3D e1, Vector3D e2) {
        Vector3D e = new Vector3D(e1.x + e2.x, e1.y + e2.y, e1.z + e2.z);
        e.normalize();
        Vector3D temp = new Vector3D();
        this.reflectInAxis(e, this.saveViewDirection, temp);
        this.reflectInAxis(e1, temp, this.saveViewDirection);
        this.reflectInAxis(e, this.saveImagePlaneXDirection, temp);
        this.reflectInAxis(e1, temp, this.saveImagePlaneXDirection);
        this.reflectInAxis(e, this.saveImagePlaneYDirection, temp);
        this.reflectInAxis(e1, temp, this.saveImagePlaneYDirection);
        double vn = this.saveViewPoint.norm();
        this.saveViewPoint.x = -vn * this.saveViewDirection.x;
        this.saveViewPoint.y = -vn * this.saveViewDirection.y;
        this.saveViewPoint.z = -vn * this.saveViewDirection.z;
        this.selectNoEye();
        this.fireTransformChangeEvent();
    }

    private void doTransvection(Vector3D e1, Vector3D e2) {
        Vector3D e = new Vector3D(e1.x + e2.x, e1.y + e2.y, e1.z + e2.z);
        e.normalize();
        Vector3D temp = new Vector3D();
        this.reflectInAxis(e, this.viewDirection, temp);
        this.reflectInAxis(e1, temp, this.viewDirection);
        this.reflectInAxis(e, this.imagePlaneXDirection, temp);
        this.reflectInAxis(e1, temp, this.imagePlaneXDirection);
        this.reflectInAxis(e, this.imagePlaneYDirection, temp);
        this.reflectInAxis(e1, temp, this.imagePlaneYDirection);
        double vn = this.viewPoint.norm();
        this.viewPoint.x = -vn * this.viewDirection.x;
        this.viewPoint.y = -vn * this.viewDirection.y;
        this.viewPoint.z = -vn * this.viewDirection.z;
    }

    private void reflectInAxis(Vector3D axis, Vector3D source, Vector3D destination) {
        double s = 2.0 * (axis.x * source.x + axis.y * source.y + axis.z * source.z);
        destination.x = s * axis.x - source.x;
        destination.y = s * axis.y - source.y;
        destination.z = s * axis.z - source.z;
    }

    void selectLeftEye(double separationFactor) {
        this.viewDirection = new Vector3D(this.saveViewDirection);
        this.imagePlaneXDirection = new Vector3D(this.saveImagePlaneXDirection);
        this.imagePlaneYDirection = new Vector3D(this.saveImagePlaneYDirection);
        this.viewPoint = new Vector3D(this.saveViewPoint);
        Vector3D angularEyeSeparation = this.imagePlaneXDirection.times(separationFactor);
        Vector3D leftEyeRay = this.viewDirection.plus(angularEyeSeparation);
        leftEyeRay.normalize();
        this.doTransvection(this.viewDirection, leftEyeRay);
    }

    void selectRightEye(double separationFactor) {
        this.viewDirection = new Vector3D(this.saveViewDirection);
        this.imagePlaneXDirection = new Vector3D(this.saveImagePlaneXDirection);
        this.imagePlaneYDirection = new Vector3D(this.saveImagePlaneYDirection);
        this.viewPoint = new Vector3D(this.saveViewPoint);
        Vector3D angularEyeSeparation = this.imagePlaneXDirection.times(separationFactor);
        Vector3D leftEyeRay = this.viewDirection.minus(angularEyeSeparation);
        leftEyeRay.normalize();
        this.doTransvection(this.viewDirection, leftEyeRay);
    }

    void selectNoEye() {
        this.viewDirection = new Vector3D(this.saveViewDirection);
        this.imagePlaneXDirection = new Vector3D(this.saveImagePlaneXDirection);
        this.imagePlaneYDirection = new Vector3D(this.saveImagePlaneYDirection);
        this.viewPoint = new Vector3D(this.saveViewPoint);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !Transform3D.class.equals(obj.getClass())) {
            return false;
        }
        Transform3D tr = (Transform3D)obj;
        return this.hasSameProjection(tr) && this.hasSameViewTransform(tr);
    }

    public boolean hasSameProjection(Transform3D tr) {
        if (tr == null) {
            return false;
        }
        return this.orthographicProjection == tr.orthographicProjection && this.clipDistance == tr.clipDistance && this.viewPoint.equals(tr.viewPoint) && this.imagePlaneYDirection.equals(tr.imagePlaneYDirection);
    }

    @Override
    public Object clone() {
        Transform3D tr = (Transform3D)super.clone();
        tr.viewPoint = new Vector3D(this.viewPoint);
        tr.viewDirection = new Vector3D(this.viewDirection);
        tr.imagePlaneXDirection = new Vector3D(this.imagePlaneXDirection);
        tr.imagePlaneYDirection = new Vector3D(this.imagePlaneYDirection);
        return tr;
    }

    void useGraphics(Graphics2D g, Graphics2D untransformedGraphics) {
        this.g = g;
        this.untransformedGraphics = untransformedGraphics;
    }

    public void objectToViewCoords(Vector3D objectPoint, Vector3D viewCoords) {
        double x1 = objectPoint.x;
        double y1 = objectPoint.y;
        double z1 = objectPoint.z;
        if (this.objectDisplacementNormalToScreen != 0.0) {
            x1 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.x;
            y1 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.y;
            z1 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.z;
        }
        if (this.orthographicProjection) {
            viewCoords.x = x1 * this.imagePlaneXDirection.x + y1 * this.imagePlaneXDirection.y + z1 * this.imagePlaneXDirection.z;
            viewCoords.y = x1 * this.imagePlaneYDirection.x + y1 * this.imagePlaneYDirection.y + z1 * this.imagePlaneYDirection.z;
        } else {
            double x = x1 - this.viewPoint.x;
            double y = y1 - this.viewPoint.y;
            double z = z1 - this.viewPoint.z;
            double dP = x * this.viewDirection.x + y * this.viewDirection.y + z * this.viewDirection.z;
            x = this.focalLength / dP * x;
            y = this.focalLength / dP * y;
            z = this.focalLength / dP * z;
            viewCoords.x = (x += this.viewPoint.x) * this.imagePlaneXDirection.x + (y += this.viewPoint.y) * this.imagePlaneXDirection.y + (z += this.viewPoint.z) * this.imagePlaneXDirection.z;
            viewCoords.y = x * this.imagePlaneYDirection.x + y * this.imagePlaneYDirection.y + z * this.imagePlaneYDirection.z;
        }
        viewCoords.z = -(x1 * this.viewDirection.x + y1 * this.viewDirection.y + z1 * this.viewDirection.z);
    }

    public Vector3D objectToViewCoords(Vector3D objectPoint) {
        Vector3D viewCoords = new Vector3D();
        this.objectToViewCoords(objectPoint, viewCoords);
        return viewCoords;
    }

    public void objectToXYWindowCoords(Vector3D objectPoint, Point2D p) {
        this.objectToViewCoords(objectPoint, this.tempVector);
        p.setLocation(this.tempVector.x, this.tempVector.y);
    }

    public Point2D objectToXYWindowCoords(Vector3D objectPoint) {
        Point2D.Double p = new Point2D.Double();
        this.objectToXYWindowCoords(objectPoint, p);
        return p;
    }

    public void objectToDrawingCoords(Vector3D objectPoint, Point2D drawingCoords) {
        this.objectToXYWindowCoords(objectPoint, drawingCoords);
        this.windowToDrawingCoords(drawingCoords);
    }

    public Point2D objectToDrawingCoords(Vector3D objectPoint) {
        Point2D.Double p = new Point2D.Double();
        this.objectToXYWindowCoords(objectPoint, p);
        this.windowToDrawingCoords(p);
        return p;
    }

    public double objectToViewZ(Vector3D objectPoint) {
        double x1 = objectPoint.x;
        double y1 = objectPoint.y;
        double z1 = objectPoint.z;
        if (this.objectDisplacementNormalToScreen != 0.0) {
            x1 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.x;
            y1 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.y;
            z1 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.z;
        }
        return -(x1 * this.viewDirection.x + y1 * this.viewDirection.y + z1 * this.viewDirection.z);
    }
}

