/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.util.ArrayList;
import java.util.Collection;
import vmm.functions.EvalStack;

public class TaskManager {
    private final ThreadPool threadPool;
    private boolean shutDown;
    private ArrayList<Job> activeJobs;
    private int nextJobForTask;

    public TaskManager() {
        this(0);
    }

    public TaskManager(int threadPoolSize) {
        if (threadPoolSize <= 0) {
            threadPoolSize = Runtime.getRuntime().availableProcessors();
        }
        this.activeJobs = new ArrayList();
        this.threadPool = new ThreadPool(this, threadPoolSize);
    }

    public synchronized void shutDown() {
        this.shutDown = true;
        for (Job job : this.activeJobs) {
            job.cancel();
        }
        this.notifyAll();
    }

    public int getThreadPoolSize() {
        return this.threadPool.getSize();
    }

    public void executeAndWait(Collection<? extends Runnable> tasks) {
        if (this.shutDown) {
            throw new IllegalStateException("Can't execute tasks after shutdown.");
        }
        if (tasks == null) {
            throw new NullPointerException("The collection of tasks can't be null.");
        }
        if (this.getThreadPoolSize() == 1) {
            for (Runnable runnable : tasks) {
                if (runnable == null) continue;
                runnable.run();
            }
        } else {
            Job job = this.executeAsync(tasks);
            job.await(0);
        }
    }

    public synchronized Job executeAsync(Collection<? extends Runnable> tasks) {
        if (this.shutDown) {
            throw new IllegalStateException("Can't execute tasks after shutdown.");
        }
        if (tasks == null) {
            throw new NullPointerException("The collection of tasks can't be null.");
        }
        Job job = new Job(this, tasks);
        job.close();
        this.activeJobs.add(job);
        this.notifyAll();
        return job;
    }

    public synchronized Job createJob() {
        if (this.shutDown) {
            throw new IllegalStateException("Can't execute tasks after shutdown.");
        }
        Job job = new Job(this, null);
        this.activeJobs.add(job);
        return job;
    }

    public synchronized boolean busy() {
        return this.activeJobs.size() > 0;
    }

    private synchronized void finish(Job job) {
        if (!this.shutDown) {
            int jobnum = this.activeJobs.indexOf(job);
            if (jobnum == -1) {
                return;
            }
            this.activeJobs.remove(jobnum);
            if (jobnum < this.nextJobForTask) {
                --this.nextJobForTask;
            }
        }
        this.notifyAll();
    }

    private synchronized Object[] nextTask() {
        Runnable task = null;
        Job job = null;
        while (task == null && !this.shutDown) {
            if (this.activeJobs.size() > 0) {
                if (this.nextJobForTask >= this.activeJobs.size()) {
                    this.nextJobForTask = 0;
                }
                int jobnum = this.nextJobForTask;
                do {
                    job = this.activeJobs.get(jobnum);
                    task = job.nextTask();
                    if (++jobnum < this.activeJobs.size()) continue;
                    jobnum = 0;
                } while (task == null && jobnum != this.nextJobForTask);
            }
            if (task != null) continue;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.shutDown) {
            return null;
        }
        ++this.nextJobForTask;
        return new Object[]{task, job};
    }

    static /* synthetic */ Object[] access$300(TaskManager x0) {
        return x0.nextTask();
    }

    private static class ThreadPool {
        final Worker[] pool;
        final TaskManager owner;
        boolean shutDown;

        ThreadPool(TaskManager owner, int poolSize) {
            this.owner = owner;
            this.pool = new Worker[poolSize];
            int priority = Thread.currentThread().getPriority();
            for (int i = 0; i < poolSize; ++i) {
                this.pool[i] = new Worker();
                this.pool[i].setDaemon(true);
                try {
                    this.pool[i].setPriority(priority - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pool[i].start();
            }
        }

        int getSize() {
            return this.pool.length;
        }

        class Worker
        extends Thread {
            Worker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block11: {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        if ((taskinfo = TaskManager.access$300(ThreadPool.this.owner)) == null) {
                            break block11;
                        }
                        task = (Runnable)taskinfo[0];
                        job = (Job)taskinfo[1];
                        ok = true;
                        try {
                            task.run();
                        }
                        catch (Throwable e) {
                            ok = false;
                        }
                        finally {
                            if (ok) {
                                Job.access$400(job, task);
                                continue;
                            }
                            Job.access$500(job, task);
                            continue;
                        }
                        break;
                    }
                    ** GOTO lbl-1000
                    finally {
                        EvalStack.perThreadRelease(this);
                    }
                }
            }
        }
    }

    public static class Job {
        private final TaskManager owner;
        private final ArrayList<Runnable> tasks;
        private volatile boolean closed;
        private volatile boolean finished;
        private volatile boolean canceled;
        private int nextTask;
        private volatile int finishedTaskCount;
        private volatile int failedTaskCount;
        private final ArrayList<Runnable> waitingFinishedTasks;
        private final ArrayList<Runnable> waitingFailedTasks;

        private Job(TaskManager owner, Collection<? extends Runnable> tasks) {
            this.owner = owner;
            this.tasks = tasks == null ? new ArrayList() : new ArrayList<Runnable>(tasks);
            for (int i = this.tasks.size() - 1; i >= 0; --i) {
                if (this.tasks.get(i) != null) continue;
                this.tasks.remove(i);
            }
            this.waitingFinishedTasks = new ArrayList();
            this.waitingFailedTasks = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish(Runnable task) {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.finished) {
                    return;
                }
                ++this.finishedTaskCount;
                this.waitingFinishedTasks.add(task);
                if (this.closed && this.finishedTaskCount + this.failedTaskCount == this.tasks.size()) {
                    this.finished = true;
                    this.owner.finish(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Runnable task) {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.finished) {
                    return;
                }
                ++this.failedTaskCount;
                this.waitingFailedTasks.add(task);
                if (this.closed && this.finishedTaskCount + this.failedTaskCount == this.tasks.size()) {
                    this.finished = true;
                    this.owner.finish(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable nextTask() {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.finished || this.nextTask >= this.tasks.size()) {
                    return null;
                }
                return this.tasks.get(this.nextTask++);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Runnable task) {
            if (task == null) {
                return;
            }
            if (this.closed) {
                throw new IllegalStateException("Can't add a new task to a job after the job has been closed.");
            }
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                this.tasks.add(task);
                this.owner.notifyAll();
            }
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.finishedTaskCount + this.failedTaskCount == this.tasks.size()) {
                this.finished = true;
                this.owner.finish(this);
            }
        }

        public double fractionDone() {
            if (this.tasks.size() == 0) {
                return 1.0;
            }
            return (double)(this.finishedTaskCount + this.failedTaskCount) / (double)this.tasks.size();
        }

        public int finishedTaskCount() {
            return this.finishedTaskCount;
        }

        public int failedTaskCount() {
            return this.failedTaskCount;
        }

        public int totalTaskCount() {
            return this.tasks.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                this.finished = true;
                this.canceled = true;
                this.closed = true;
                this.owner.finish(this);
                this.owner.notifyAll();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runnable[] finishedTasks() {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.waitingFinishedTasks.size() == 0) {
                    return new Runnable[0];
                }
                Runnable[] tasks = new Runnable[this.waitingFinishedTasks.size()];
                this.waitingFinishedTasks.toArray(tasks);
                this.waitingFinishedTasks.clear();
                return tasks;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runnable[] failedTasks() {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.waitingFailedTasks.size() == 0) {
                    return new Runnable[0];
                }
                Runnable[] tasks = new Runnable[this.waitingFailedTasks.size()];
                this.waitingFailedTasks.toArray(tasks);
                this.waitingFailedTasks.clear();
                return tasks;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(int timeoutMilliseconds) {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.finished) {
                    return true;
                }
                try {
                    if (timeoutMilliseconds <= 0) {
                        this.owner.wait();
                    } else {
                        this.owner.wait(timeoutMilliseconds);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.finished;
            }
        }

        static /* synthetic */ void access$400(Job x0, Runnable x1) {
            x0.finish(x1);
        }

        static /* synthetic */ void access$500(Job x0, Runnable x1) {
            x0.fail(x1);
        }
    }
}

