/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

public class Prefs {
    private static Prefs prefs;
    protected static final String DEFAULT_PREFIX = "/org/virtualmathmuseum/vmm/";
    private HashMap<String, String> map;
    private Preferences preferencesRoot;

    public static synchronized boolean save() {
        if (prefs == null) {
            return true;
        }
        return prefs.doSave();
    }

    public static synchronized boolean save(String key) {
        if (prefs == null) {
            return true;
        }
        return prefs.doSave(key);
    }

    public static synchronized void put(String key, String value) {
        if (prefs == null) {
            prefs = new Prefs();
        }
        prefs.doPut(key, value);
    }

    public static synchronized boolean putAndSave(String key, String value) {
        prefs.doPut(key, value);
        return prefs.doSave(key);
    }

    public static synchronized String get(String key) {
        if (prefs == null) {
            prefs = new Prefs();
        }
        return prefs.doGet(key);
    }

    public static void putInt(String key, int value) {
        Prefs.put(key, "" + value);
    }

    public static void putDouble(String key, double value) {
        if (Double.isNaN(value)) {
            Prefs.put(key, "NaN");
        } else if (value == Double.POSITIVE_INFINITY) {
            Prefs.put(key, "+INF");
        } else if (value == Double.NEGATIVE_INFINITY) {
            Prefs.put(key, "-INF");
        } else {
            Prefs.put(key, "" + value);
        }
    }

    public static void putBoolean(String key, boolean value) {
        Prefs.put(key, value ? "true" : "false");
    }

    public static String get(String key, String deflt) {
        String val = Prefs.get(key);
        return val == null ? deflt : val;
    }

    public static int getInt(String key, int deflt) {
        String val = Prefs.get(key);
        if (val == null) {
            return deflt;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return deflt;
        }
    }

    public static double getDouble(String key, double deflt) {
        String val = Prefs.get(key);
        if (val == null) {
            return deflt;
        }
        if (val.equals("NaN")) {
            return Double.NaN;
        }
        if (val.equals("+INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (val.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            return deflt;
        }
    }

    public static boolean getBoolean(String key, boolean deflt) {
        String val = Prefs.get(key);
        if (val == null) {
            return deflt;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        return deflt;
    }

    public static void setPrefs(Prefs prefs) {
        Prefs.prefs = prefs;
    }

    public static Prefs getPrefs() {
        if (prefs == null) {
            prefs = new Prefs();
        }
        return prefs;
    }

    protected Prefs() {
    }

    protected String doGet(String key) {
        String value;
        if (key == null || key.length() == 0) {
            return null;
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if (this.map.containsKey(key = DEFAULT_PREFIX + key)) {
            return this.map.get(key);
        }
        try {
            if (this.preferencesRoot == null) {
                this.preferencesRoot = Preferences.userRoot();
            }
            value = this.preferencesRoot.get(key, null);
        }
        catch (Exception e) {
            value = null;
        }
        this.map.put(key, value);
        return value;
    }

    protected void doPut(String key, String value) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("key string must be non-null and non-empty.");
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(DEFAULT_PREFIX + key, value);
    }

    protected boolean doSave() {
        if (this.map == null || this.map.size() == 0) {
            return true;
        }
        try {
            if (this.preferencesRoot == null) {
                this.preferencesRoot = Preferences.userRoot();
            }
            for (Map.Entry<String, String> item : this.map.entrySet()) {
                String key = item.getKey();
                String value = item.getValue();
                String oldValue = this.preferencesRoot.get(key, null);
                if (value == null && oldValue != null) {
                    this.preferencesRoot.remove(key);
                    continue;
                }
                if (value == null || value.equals(oldValue)) continue;
                this.preferencesRoot.put(key, value);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean doSave(String key) {
        if (this.map == null || this.map.size() == 0) {
            return true;
        }
        key = DEFAULT_PREFIX + key;
        if (!this.map.containsKey(key)) {
            return true;
        }
        String value = this.map.get(key);
        try {
            if (this.preferencesRoot == null) {
                this.preferencesRoot = Preferences.userRoot();
            }
            String oldValue = this.preferencesRoot.get(key, null);
            if (value == null && oldValue != null) {
                this.preferencesRoot.remove(key);
            } else if (value != null && !value.equals(oldValue)) {
                this.preferencesRoot.put(key, value);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

