/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.ParameterInput;
import vmm.core.SettingsDialog;

public class ParameterDialog
extends SettingsDialog {
    private Parameter[] parameters;
    private ParameterInput[] inputBoxes;

    public static boolean showDialog(Component parentComponent, String title, Parameter[] params) {
        ParameterDialog dialog = new ParameterDialog(parentComponent, title, params);
        dialog.setVisible(true);
        return !dialog.canceled;
    }

    public ParameterDialog(Component parentComponent, String title, Parameter[] params) {
        super(parentComponent, title, true, true);
        this.parameters = params;
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        topPanel.setLayout(new GridLayout(1, 0, 5, 5));
        topPanel.add(new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterName"), 0));
        topPanel.add(new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterValue"), 0));
        JPanel inputPanel = new JPanel();
        inputPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.inputBoxes = new ParameterInput[params.length];
        inputPanel.setLayout(new GridLayout(0, 2, 5, 5));
        for (int i = 0; i < params.length; ++i) {
            JLabel label = new JLabel(params[i].getTitle() + " = ", 4);
            final String tip = params[i].getHint();
            if (tip == null) {
                inputPanel.add(label);
            } else {
                JPanel labelPanel = new JPanel();
                inputPanel.add(labelPanel);
                labelPanel.setLayout(new BorderLayout());
                labelPanel.add((Component)label, "Center");
                JButton showHint = new JButton("?");
                showHint.setPreferredSize(new Dimension(40, showHint.getPreferredSize().height));
                labelPanel.add((Component)showHint, "West");
                final String dialogtitle = params[i].getTitle();
                showHint.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JOptionPane.showMessageDialog(ParameterDialog.this, new JLabel(tip), dialogtitle, 1);
                    }
                });
            }
            this.inputBoxes[i] = params[i].createParameterInput(0);
            inputPanel.add(this.inputBoxes[i]);
            this.inputBoxes[i].setMargin(new Insets(3, 3, 3, 3));
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(6, 6));
        p.add((Component)topPanel, "North");
        p.add((Component)inputPanel, "Center");
        this.addInputPanel(p);
    }

    @Override
    protected boolean doOK() {
        int i;
        for (i = 0; i < this.parameters.length; ++i) {
            String error = this.inputBoxes[i].checkContents();
            if (error == null) continue;
            JOptionPane.showMessageDialog(this, error, I18n.tr("vmm.core.ParameterDialog.errorTitle"), 0);
            return false;
        }
        for (i = 0; i < this.parameters.length; ++i) {
            this.inputBoxes[i].setValueFromContents();
        }
        return true;
    }

    @Override
    protected void doDefaults() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.inputBoxes[i].defaultVal();
        }
    }
}

