/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.geom.Point2D;

public class LinearAlgebra {
    public static Point2D minus2D(Point2D P2, Point2D P1) {
        Point2D.Double D = new Point2D.Double();
        ((Point2D)D).setLocation(P2.getX() - P1.getX(), P2.getY() - P1.getY());
        return D;
    }

    public static void assignMinus2D(Point2D P2, Point2D P1) {
        P2.setLocation(P2.getX() - P1.getX(), P2.getY() - P1.getY());
    }

    public static Point2D convexCombination(double t, Point2D P1, Point2D P2) {
        Point2D.Double D = new Point2D.Double();
        ((Point2D)D).setLocation((1.0 - t) * P1.getX() + t * P2.getX(), (1.0 - t) * P1.getY() + t * P2.getY());
        return D;
    }

    public static Point2D linearCombination(double t1, double t2, Point2D P1, Point2D P2) {
        Point2D.Double D = new Point2D.Double();
        ((Point2D)D).setLocation(t1 * P1.getX() + t2 * P2.getX(), t1 * P1.getY() + t2 * P2.getY());
        return D;
    }

    public static Point2D normalTo(Point2D P) {
        Point2D.Double N = new Point2D.Double();
        ((Point2D)N).setLocation(P.getY(), -P.getX());
        return N;
    }

    public static Point2D normalTo(Point2D P2, Point2D P1) {
        Point2D.Double N = new Point2D.Double();
        ((Point2D)N).setLocation(P2.getY() - P1.getY(), -P2.getX() + P1.getX());
        return N;
    }

    public static double dotProduct(Point2D P, Point2D Q) {
        return P.getX() * Q.getX() + P.getY() * Q.getY();
    }

    public double determinant(Point2D P, Point2D Q) {
        return P.getX() * Q.getY() - P.getY() * Q.getX();
    }

    public static Point2D intersectTwoLines(Point2D P1, Point2D P2, Point2D Q1, Point2D Q2) {
        LinearAlgebra.assignMinus2D(P2, P1);
        Point2D A = P2;
        LinearAlgebra.assignMinus2D(Q2, Q1);
        Point2D N = Q2;
        double nn = LinearAlgebra.dotProduct(A, N);
        double s = (N.getX() * (Q1.getX() - P1.getX()) + N.getY() * (Q1.getY() - P1.getY())) / nn;
        return LinearAlgebra.convexCombination(s, P1, P2);
    }

    public static Point2D intersectTwoLines(double P1x, double P1y, double P2x, double P2y, double Q1x, double Q1y, double Q2x, double Q2y) {
        Point2D.Double A = new Point2D.Double(P2x - P1x, P2y - P1y);
        Point2D.Double N = new Point2D.Double(-Q2y + Q1y, Q2x - Q1x);
        double nn = LinearAlgebra.dotProduct(A, N);
        double s = (((Point2D)N).getX() * (Q1x - P1x) + ((Point2D)N).getY() * (Q1y - P1y)) / nn;
        ((Point2D)A).setLocation(P1x + s * (P2x - P1x), P1y + s * (P2y - P1y));
        return A;
    }
}

