/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;

public abstract class Decoration {
    private ArrayList<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    @VMMSave
    private int layer = 1;
    protected boolean decorationNeedsRedraw = true;

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        if (this.layer != layer) {
            this.layer = layer;
            this.fireDecorationChangeEvent();
        }
    }

    public void forceRedraw() {
        this.decorationNeedsRedraw = true;
        this.fireDecorationChangeEvent();
    }

    public void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
    }

    public void doDraw(Graphics2D g, View view, Transform transform) {
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener != null && this.changeListeners != null) {
            this.changeListeners.remove(listener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireDecorationChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }

    public void addExtraXML(Document containingDocument, Element decorationElement) {
    }

    public void readExtraXML(Element decoratinInfo) throws IOException {
    }
}

