/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import pl.edu.icm.jlargearrays.LargeArrayTest;
import pl.edu.icm.jlargearrays.ObjectLargeArray;

public class ObjectLargeArrayTest
extends LargeArrayTest {
    public ObjectLargeArrayTest(boolean useOffHeapMemory) {
        super(useOffHeapMemory);
    }

    @Test
    public void testEmptyObjectLargeArray() {
        ObjectLargeArray a = new ObjectLargeArray(0L);
        Assert.assertEquals((long)0L, (long)a.length());
        ArrayIndexOutOfBoundsException e = null;
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        a = new ObjectLargeArray(0L, 100, 1, true);
        Assert.assertEquals((long)0L, (long)a.length());
        Assert.assertTrue((boolean)a.isConstant());
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
    }

    @Test
    public void testObjectLargeArrayEqualsHashCode() {
        ObjectLargeArray a = new ObjectLargeArray(10L);
        ObjectLargeArray b = new ObjectLargeArray(10L);
        a.set(0L, 1);
        b.set(0L, 1);
        Assert.assertTrue((boolean)a.equals(a));
        Assert.assertTrue((a.hashCode() == a.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == a.hashCode(1.0f) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a.equals(b));
        Assert.assertTrue((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == b.hashCode(1.0f) ? 1 : 0) != 0);
        a.set(0L, 2);
        Assert.assertFalse((boolean)a.equals(b));
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        a.set(0L, 3);
        Assert.assertFalse((boolean)a.equals(b));
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testObjectLargeArrayApproximateHashCode() {
        ObjectLargeArray a = new ObjectLargeArray(10L);
        ObjectLargeArray b = new ObjectLargeArray(10L);
        a.set(0L, new Double(0.0));
        b.set(0L, new Double(1.0));
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
        a = new ObjectLargeArray(10L, 1024, new Double(0.0), true);
        b = new ObjectLargeArray(10L, 1024, new Double(1.0), true);
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
    }

    @Test
    public void testSerialization() {
        ByteArrayOutputStream bout;
        Throwable throwable;
        ObjectInputStream in2;
        Throwable throwable2;
        ObjectOutputStream o2;
        Throwable throwable3;
        long size = 32L;
        ObjectLargeArray a = new ObjectLargeArray(size);
        ObjectLargeArray b = null;
        try {
            throwable3 = null;
            try (ByteArrayOutputStream bout2 = new ByteArrayOutputStream();){
                o2 = new ObjectOutputStream(bout2);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout2.toByteArray()));
                    throwable = null;
                    try {
                        b = (ObjectLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable in2) {
                    throwable2 = in2;
                    throw in2;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable in2) {
                                throwable2.addSuppressed(in2);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable o2) {
                throwable3 = o2;
                throw o2;
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
        for (long i = 0L; i < size; ++i) {
            a.set(i, new Float(i));
        }
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (ObjectLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable in3) {
                    throwable2 = in3;
                    throw in3;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable in3) {
                                throwable2.addSuppressed(in3);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable o3) {
                throwable3 = o3;
                throw o3;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable o3) {
                            throwable3.addSuppressed(o3);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
        a = new ObjectLargeArray(size, 1024, new Float(12345.0f), true);
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (ObjectLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable10) {
                    throwable2 = throwable10;
                    throw throwable10;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable throwable11) {
                                throwable2.addSuppressed(throwable11);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable12) {
                throwable3 = throwable12;
                throw throwable12;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable throwable13) {
                            throwable3.addSuppressed(throwable13);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
    }

    @Test
    public void testObjectLargeArrayConstant() {
        ObjectLargeArray a = new ObjectLargeArray(10L, 1024, new Float(12345.0f), true);
        Assert.assertTrue((boolean)a.isConstant());
        Assert.assertEquals((Object)Float.valueOf(12345.0f), (Object)a.get(0L));
        Assert.assertEquals((Object)Float.valueOf(12345.0f), (Object)a.get(a.length() - 1L));
        a.set(0L, new Float(12346.0f));
        Assert.assertEquals((Object)Float.valueOf(12346.0f), (Object)a.get(0L));
        Assert.assertFalse((boolean)a.isConstant());
        a = new ObjectLargeArray(10L, 1024, null, false);
        Assert.assertFalse((boolean)a.isConstant());
        Assert.assertEquals(null, (Object)a.get(0L));
        a = new ObjectLargeArray(10L, 1024, null, true);
        Assert.assertTrue((boolean)a.isConstant());
        Assert.assertEquals(null, (Object)a.get(0L));
    }

    @Test
    public void testObjectLargeArrayGetSet() {
        ObjectLargeArray a = new ObjectLargeArray(10L, 84);
        long idx = 5L;
        Double val1 = 2.0;
        Double val2 = Double.MAX_VALUE;
        a.set(idx, val1);
        Assert.assertEquals((Object)val1, (Object)a.get(idx));
        a.set(idx, val2);
        Assert.assertEquals((Object)val2, (Object)a.get(idx));
        Assert.assertEquals(val2.getClass(), (Object)a.getElementClass());
    }

    @Test
    public void testObjectLargeArrayGetSetNative() {
        ObjectLargeArray a = new ObjectLargeArray(10L, 84);
        if (a.isLarge()) {
            long idx = 5L;
            Double val1 = 2.0;
            Double val2 = Double.MAX_VALUE;
            a.setToNative(idx, val1);
            Assert.assertEquals((Object)val1, (Object)a.getFromNative(idx));
            a.setToNative(idx, val2);
            Assert.assertEquals((Object)val2, (Object)a.getFromNative(idx));
            Assert.assertEquals(val2.getClass(), (Object)a.getElementClass());
        }
    }
}

