/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontDetector;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.fonts.autodetect.FontInfoFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontInfoConfigurator {
    private final Configuration cfg;
    private final FontManager fontManager;
    private final FontResolver fontResolver;
    private final FontEventListener listener;
    private final boolean strict;

    public FontInfoConfigurator(Configuration cfg, FontManager fontManager, FontResolver fontResolver, FontEventListener listener, boolean strict) {
        this.cfg = cfg;
        this.fontManager = fontManager;
        this.fontResolver = fontResolver;
        this.listener = listener;
        this.strict = strict;
    }

    public void configure(List<EmbedFontInfo> fontInfoList) throws FOPException {
        Configuration fontsCfg = this.cfg.getChild("fonts", false);
        if (fontsCfg != null) {
            boolean autodetectFonts;
            long start = 0L;
            FontAdder fontAdder = new FontAdder(this.fontManager, this.fontResolver, this.listener);
            boolean bl = autodetectFonts = fontsCfg.getChild("auto-detect", false) != null;
            if (autodetectFonts) {
                FontDetector fontDetector = new FontDetector(this.fontManager, fontAdder, this.strict, this.listener);
                fontDetector.detect(fontInfoList);
            }
            this.addDirectories(fontsCfg, fontAdder, fontInfoList);
            this.addFonts(fontsCfg, this.fontManager.getFontCache(), fontInfoList);
            this.fontManager.updateReferencedFonts(fontInfoList);
            Configuration referencedFontsCfg = fontsCfg.getChild("referenced-fonts", false);
            if (referencedFontsCfg != null) {
                FontTriplet.Matcher matcher = FontManagerConfigurator.createFontsMatcher(referencedFontsCfg, this.strict);
                this.fontManager.updateReferencedFonts(fontInfoList, matcher);
            }
            this.fontManager.saveCache();
        }
    }

    private void addDirectories(Configuration fontsCfg, FontAdder fontAdder, List<EmbedFontInfo> fontInfoList) throws FOPException {
        Configuration[] directories = fontsCfg.getChildren("directory");
        for (int i = 0; i < directories.length; ++i) {
            boolean recursive = directories[i].getAttributeAsBoolean("recursive", false);
            String directory = null;
            try {
                directory = directories[i].getValue();
            }
            catch (ConfigurationException e) {
                continue;
            }
            if (directory == null) continue;
            FontFileFinder fontFileFinder = new FontFileFinder(recursive ? -1 : 1, this.listener);
            try {
                List<URL> fontURLList = fontFileFinder.find(directory);
                fontAdder.add(fontURLList, fontInfoList);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected void addFonts(Configuration fontsCfg, FontCache fontCache, List<EmbedFontInfo> fontInfoList) throws FOPException {
        Configuration[] font = fontsCfg.getChildren("font");
        for (int i = 0; i < font.length; ++i) {
            EmbedFontInfo embedFontInfo = this.getFontInfo(font[i], fontCache);
            if (embedFontInfo == null) continue;
            fontInfoList.add(embedFontInfo);
        }
    }

    private static void closeSource(Source src) {
        if (src instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)src;
            IOUtils.closeQuietly(streamSource.getInputStream());
            IOUtils.closeQuietly(streamSource.getReader());
        }
    }

    protected EmbedFontInfo getFontInfo(Configuration fontCfg, FontCache fontCache) throws FOPException {
        Configuration[] tripletCfg;
        String metricsUrl = fontCfg.getAttribute("metrics-url", null);
        String embedUrl = fontCfg.getAttribute("embed-url", null);
        String subFont = fontCfg.getAttribute("sub-font", null);
        if (metricsUrl == null && embedUrl == null) {
            return null;
        }
        if (this.strict) {
            Source source;
            if (embedUrl != null) {
                source = this.fontResolver.resolve(embedUrl);
                FontInfoConfigurator.closeSource(source);
                if (source == null) {
                    return null;
                }
            }
            if (metricsUrl != null) {
                source = this.fontResolver.resolve(metricsUrl);
                FontInfoConfigurator.closeSource(source);
                if (source == null) {
                    return null;
                }
            }
        }
        if ((tripletCfg = fontCfg.getChildren("font-triplet")).length == 0) {
            File fontFile = FontCache.getFileFromUrls(new String[]{embedUrl, metricsUrl});
            URL fontURL = null;
            try {
                fontURL = fontFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (fontFile != null) {
                FontInfoFinder finder = new FontInfoFinder();
                finder.setEventListener(this.listener);
                EmbedFontInfo[] infos = finder.find(fontURL, this.fontResolver, fontCache);
                return infos[0];
            }
            return null;
        }
        ArrayList<FontTriplet> tripletList = new ArrayList<FontTriplet>();
        for (int j = 0; j < tripletCfg.length; ++j) {
            FontTriplet fontTriplet = this.getFontTriplet(tripletCfg[j]);
            tripletList.add(fontTriplet);
        }
        boolean useKerning = fontCfg.getAttributeAsBoolean("kerning", true);
        boolean useAdvanced = fontCfg.getAttributeAsBoolean("advanced", true);
        EncodingMode encodingMode = EncodingMode.getValue(fontCfg.getAttribute("encoding-mode", EncodingMode.AUTO.getName()));
        EmbeddingMode embeddingMode = EmbeddingMode.getValue(fontCfg.getAttribute("embedding-mode", EmbeddingMode.AUTO.toString()));
        EmbedFontInfo embedFontInfo = new EmbedFontInfo(metricsUrl, useKerning, useAdvanced, tripletList, embedUrl, subFont);
        embedFontInfo.setEncodingMode(encodingMode);
        embedFontInfo.setEmbeddingMode(embeddingMode);
        boolean skipCachedFont = false;
        if (fontCache != null) {
            if (!fontCache.containsFont(embedFontInfo)) {
                fontCache.addFont(embedFontInfo);
            } else {
                skipCachedFont = true;
            }
        }
        return embedFontInfo;
    }

    private FontTriplet getFontTriplet(Configuration tripletCfg) throws FOPException {
        try {
            String name = tripletCfg.getAttribute("name");
            if (name == null) {
                return null;
            }
            String weightStr = tripletCfg.getAttribute("weight");
            if (weightStr == null) {
                return null;
            }
            int weight = FontUtil.parseCSS2FontWeight(FontUtil.stripWhiteSpace(weightStr));
            String style = tripletCfg.getAttribute("style");
            if (style == null) {
                return null;
            }
            style = FontUtil.stripWhiteSpace(style);
            return FontInfo.createFontKey(name, style, weight);
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }
}

