/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import java.util.Arrays;

public class FloatVariableAxis
implements FloatIAxis {
    private static final long serialVersionUID = 1L;
    protected float min;
    protected int bins;
    protected float[] edges;

    public FloatVariableAxis(float[] edges) {
        if (edges.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < edges.length - 1; ++i) {
            if (!(edges[i + 1] <= edges[i])) continue;
            throw new IllegalArgumentException("edges must be sorted ascending and must not contain multiple identical values");
        }
        this.min = edges[0];
        this.bins = edges.length - 1;
        this.edges = (float[])edges.clone();
    }

    @Override
    public float binCentre(int index) {
        return (this.binLowerEdge(index) + this.binUpperEdge(index)) / 2.0f;
    }

    @Override
    public float binLowerEdge(int index) {
        if (index == -2) {
            return Float.NEGATIVE_INFINITY;
        }
        if (index == -1) {
            return this.upperEdge();
        }
        return this.edges[index];
    }

    @Override
    public int bins() {
        return this.bins;
    }

    @Override
    public float binUpperEdge(int index) {
        if (index == -2) {
            return this.lowerEdge();
        }
        if (index == -1) {
            return Float.POSITIVE_INFINITY;
        }
        return this.edges[index + 1];
    }

    @Override
    public float binWidth(int index) {
        return this.binUpperEdge(index) - this.binLowerEdge(index);
    }

    @Override
    public int coordToIndex(float coord) {
        if (coord < this.min) {
            return -2;
        }
        int index = Arrays.binarySearch(this.edges, coord);
        if (index < 0) {
            index = -index - 1 - 1;
        }
        if (index >= this.bins) {
            return -1;
        }
        return index;
    }

    @Override
    public float lowerEdge() {
        return this.min;
    }

    protected static String toString(float[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = array.length - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(array[i]);
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public float upperEdge() {
        return this.edges[this.edges.length - 1];
    }
}

