/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;

public class FloatFixedAxis
implements FloatIAxis {
    private static final long serialVersionUID = 1L;
    private int bins;
    private float min;
    private float binWidth;
    private int xunder;
    private int xover;

    public FloatFixedAxis(int bins, float min, float max) {
        if (bins < 1) {
            throw new IllegalArgumentException("bins=" + bins);
        }
        if (max <= min) {
            throw new IllegalArgumentException("max <= min");
        }
        this.bins = bins;
        this.min = min;
        this.binWidth = (max - min) / (float)bins;
    }

    @Override
    public float binCentre(int index) {
        return this.min + this.binWidth * (float)index + this.binWidth / 2.0f;
    }

    @Override
    public float binLowerEdge(int index) {
        if (index == -2) {
            return Float.NEGATIVE_INFINITY;
        }
        if (index == -1) {
            return this.upperEdge();
        }
        return this.min + this.binWidth * (float)index;
    }

    @Override
    public int bins() {
        return this.bins;
    }

    @Override
    public float binUpperEdge(int index) {
        if (index == -2) {
            return this.min;
        }
        if (index == -1) {
            return Float.POSITIVE_INFINITY;
        }
        return this.min + this.binWidth * (float)(index + 1);
    }

    @Override
    public float binWidth(int index) {
        return this.binWidth;
    }

    @Override
    public int coordToIndex(float coord) {
        if (coord < this.min) {
            return -2;
        }
        int index = (int)Math.floor((coord - this.min) / this.binWidth);
        if (index >= this.bins) {
            return -1;
        }
        return index;
    }

    @Override
    public float lowerEdge() {
        return this.min;
    }

    @Override
    public float upperEdge() {
        return this.min + this.binWidth * (float)this.bins;
    }

    int xgetBin(float coord) {
        if (coord < this.min) {
            return this.xunder;
        }
        int index = (int)Math.floor((coord - this.min) / this.binWidth);
        if (index > this.bins) {
            return this.xover;
        }
        return index + 1;
    }

    int xmap(int index) {
        if (index >= this.bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return this.xunder;
        }
        if (index == -1) {
            return this.xover;
        }
        throw new IllegalArgumentException("bin=" + index);
    }
}

