/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseColumnLongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix1D;

class SelectedDenseColumnLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseColumnLongMatrix2D(long[] elements, int[] rowOffsets, int[] columnOffsets, int offset) {
        this(rowOffsets.length, columnOffsets.length, elements, 0, 0, 1, 1, rowOffsets, columnOffsets, offset);
    }

    protected SelectedDenseColumnLongMatrix2D(int rows, int columns, long[] elements, int rowZero, int columnZero, int rowStride, int columnStride, int[] rowOffsets, int[] columnOffsets, int offset) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public long[] elements() {
        return this.elements;
    }

    @Override
    public long getQuick(int row, int column) {
        return this.elements[this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]];
    }

    @Override
    public long index(int row, int column) {
        return this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new DenseColumnLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix1D like1D(int size) {
        return new DenseLongMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, long value) {
        this.elements[this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]] = value;
    }

    @Override
    public LongMatrix1D vectorize() {
        DenseLongMatrix1D v = new DenseLongMatrix1D((int)this.size());
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.setQuick(idx++, this.getQuick(c, r));
            }
        }
        return v;
    }

    @Override
    public LongMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.rowZero;
        int viewStride = this.rowStride;
        int[] viewOffsets = this.rowOffsets;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        return new SelectedDenseLongMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    public LongMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.columnZero;
        int viewStride = this.columnStride;
        int[] viewOffsets = this.columnOffsets;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        return new SelectedDenseLongMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    @Override
    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    @Override
    protected boolean haveSharedCellsRaw(LongMatrix2D other) {
        if (other instanceof SelectedDenseColumnLongMatrix2D) {
            SelectedDenseColumnLongMatrix2D otherMatrix = (SelectedDenseColumnLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnLongMatrix2D) {
            DenseColumnLongMatrix2D otherMatrix = (DenseColumnLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected LongMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    @Override
    protected void setUp(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] tmp = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = tmp;
        this.isNoView = false;
        return this;
    }

    @Override
    protected LongMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnLongMatrix2D(this.elements, rowOffsets, columnOffsets, this.offset);
    }
}

