/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;

class DelegateIntMatrix2D
extends IntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected IntMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateIntMatrix2D(IntMatrix3D newContent, int axis, int index) {
        switch (axis) {
            case 0: {
                if (index < 0 || index >= newContent.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.rows(), newContent.columns());
                break;
            }
            case 1: {
                if (index < 0 || index >= newContent.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.slices(), newContent.columns());
                break;
            }
            case 2: {
                if (index < 0 || index >= newContent.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.slices(), newContent.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = axis;
        this.index = index;
        this.content = newContent;
    }

    @Override
    public synchronized int getQuick(int row, int column) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, row, column);
            }
            case 1: {
                return this.content.getQuick(row, this.index, column);
            }
            case 2: {
                return this.content.getQuick(row, column, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IntMatrix2D like(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    @Override
    public synchronized void setQuick(int row, int column, int value) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, row, column, value);
                break;
            }
            case 1: {
                this.content.setQuick(row, this.index, column, value);
                break;
            }
            case 2: {
                this.content.setQuick(row, column, this.index, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public IntMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        return new WrapperIntMatrix2D(this).viewColumn(column);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    protected IntMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }

    @Override
    public IntMatrix1D like1D(int size) {
        throw new InternalError();
    }

    @Override
    protected IntMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    @Override
    public IntMatrix1D vectorize() {
        DenseIntMatrix1D v = new DenseIntMatrix1D(this.rows * this.columns);
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                ((IntMatrix1D)v).setQuick(idx++, this.getQuick(r, c));
            }
        }
        return v;
    }
}

