/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected float[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalFloatMatrix2D(float[][] values, int dindex) {
        this(values.length, values.length == 0 ? 0 : values[0].length, dindex);
        this.assign(values);
    }

    public DiagonalFloatMatrix2D(int rows, int columns, int dindex) {
        int diff;
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (dindex < -rows + 1 || dindex > columns - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = dindex;
        this.dlength = dindex == 0 ? Math.min(rows, columns) : (dindex > 0 ? (rows >= columns ? columns - dindex : (dindex <= (diff = columns - rows) ? rows : rows - (dindex - diff))) : (rows >= columns ? (-dindex <= (diff = rows - columns) ? columns : columns + dindex + diff) : rows + dindex));
        this.elements = new float[this.dlength];
    }

    @Override
    public FloatMatrix2D assign(FloatFunction function) {
        if (function instanceof FloatMult) {
            float alpha = ((FloatMult)function).multiplicator;
            if (alpha == 1.0f) {
                return this;
            }
            if (alpha == 0.0f) {
                return this.assign(0.0f);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            int j = this.dlength;
            while (--j >= 0) {
                int n = j;
                this.elements[n] = this.elements[n] * alpha;
            }
        } else {
            int j = this.dlength;
            while (--j >= 0) {
                this.elements[j] = function.apply(this.elements[j]);
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(float value) {
        int i = this.dlength;
        while (--i >= 0) {
            this.elements[i] = value;
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final float[] values) {
        if (values.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + this.dlength);
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            int k = this.dlength / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DiagonalFloatMatrix2D.this.elements[r] = values[r];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = this.dlength;
            while (--r >= 0) {
                this.elements[r] = values[r];
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(float[][] values) {
        int c;
        int r;
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            r = 0;
            c = this.dindex;
        } else {
            r = -this.dindex;
            c = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (values[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + values[r].length + "columns()=" + this.columns());
            }
            this.elements[i] = values[r++][c++];
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof DiagonalFloatMatrix2D) {
            DiagonalFloatMatrix2D other = (DiagonalFloatMatrix2D)source;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("source is DiagonalFloatMatrix2D with different diagonal stored.");
            }
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D y, final FloatFloatFunction function) {
        this.checkShape(y);
        if (y instanceof DiagonalFloatMatrix2D) {
            float alpha;
            DiagonalFloatMatrix2D other = (DiagonalFloatMatrix2D)y;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("y is DiagonalFloatMatrix2D with different diagonal stored.");
            }
            if (function instanceof FloatPlusMultSecond && (alpha = ((FloatPlusMultSecond)function).multiplicator) == 0.0f) {
                return this;
            }
            final float[] otherElements = other.elements;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.dlength);
                Future[] futures = new Future[nthreads];
                int k = this.dlength / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (function instanceof FloatPlusMultSecond) {
                                float alpha = ((FloatPlusMultSecond)function).multiplicator;
                                if (alpha == 1.0f) {
                                    for (int j = firstRow; j < lastRow; ++j) {
                                        int n = j;
                                        DiagonalFloatMatrix2D.this.elements[n] = DiagonalFloatMatrix2D.this.elements[n] + otherElements[j];
                                    }
                                } else {
                                    for (int j = firstRow; j < lastRow; ++j) {
                                        DiagonalFloatMatrix2D.this.elements[j] = DiagonalFloatMatrix2D.this.elements[j] + alpha * otherElements[j];
                                    }
                                }
                            } else if (function == FloatFunctions.mult) {
                                for (int j = firstRow; j < lastRow; ++j) {
                                    DiagonalFloatMatrix2D.this.elements[j] = DiagonalFloatMatrix2D.this.elements[j] * otherElements[j];
                                }
                            } else if (function == FloatFunctions.div) {
                                for (int j = firstRow; j < lastRow; ++j) {
                                    DiagonalFloatMatrix2D.this.elements[j] = DiagonalFloatMatrix2D.this.elements[j] / otherElements[j];
                                }
                            } else {
                                for (int j = firstRow; j < lastRow; ++j) {
                                    DiagonalFloatMatrix2D.this.elements[j] = function.apply(DiagonalFloatMatrix2D.this.elements[j], otherElements[j]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else if (function instanceof FloatPlusMultSecond) {
                float alpha2 = ((FloatPlusMultSecond)function).multiplicator;
                if (alpha2 == 1.0f) {
                    int j = this.dlength;
                    while (--j >= 0) {
                        int n = j;
                        this.elements[n] = this.elements[n] + otherElements[j];
                    }
                } else {
                    int j = this.dlength;
                    while (--j >= 0) {
                        this.elements[j] = this.elements[j] + alpha2 * otherElements[j];
                    }
                }
            } else if (function == FloatFunctions.mult) {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = this.elements[j] * otherElements[j];
                }
            } else if (function == FloatFunctions.div) {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = this.elements[j] / otherElements[j];
                }
            } else {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = function.apply(this.elements[j], otherElements[j]);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.dlength / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            if (DiagonalFloatMatrix2D.this.elements[r] == 0.0f) continue;
                            ++cardinality;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int r = 0; r < this.dlength; ++r) {
                if (this.elements[r] == 0.0f) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public boolean equals(float value) {
        float epsilon = FloatProperty.DEFAULT.tolerance();
        for (int r = 0; r < this.dlength; ++r) {
            float x = this.elements[r];
            float diff = Math.abs(value - x);
            if (diff != diff && (value != value && x != x || value == x)) {
                diff = 0.0f;
            }
            if (diff <= epsilon) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DiagonalFloatMatrix2D) {
            DiagonalFloatMatrix2D other = (DiagonalFloatMatrix2D)obj;
            float epsilon = FloatProperty.DEFAULT.tolerance();
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            int rows = this.rows();
            int columns = this.columns();
            if (columns != other.columns() || rows != other.rows()) {
                return false;
            }
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                return false;
            }
            float[] otherElements = other.elements;
            for (int r = 0; r < this.dlength; ++r) {
                float value = otherElements[r];
                float x = this.elements[r];
                float diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0f;
                }
                if (diff <= epsilon) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public FloatMatrix2D forEachNonZero(IntIntFloatFunction function) {
        int j = this.dlength;
        while (--j >= 0) {
            float value = this.elements[j];
            if (value == 0.0f) continue;
            this.elements[j] = function.apply(j, j, value);
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    @Override
    public float[] getMaxLocation() {
        int columnLocation;
        int rowLocation;
        int location = 0;
        float maxValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.dlength / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int location = firstRow;
                        float maxValue = DiagonalFloatMatrix2D.this.elements[location];
                        for (int r = firstRow + 1; r < lastRow; ++r) {
                            float elem = DiagonalFloatMatrix2D.this.elements[r];
                            if (!(maxValue < elem)) continue;
                            maxValue = elem;
                            location = r;
                        }
                        return new float[]{maxValue, location, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (float[])futures[j].get();
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (!(maxValue < results[j][0])) continue;
                    maxValue = results[j][0];
                    location = (int)results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[0];
            for (int r = 1; r < this.dlength; ++r) {
                float elem = this.elements[r];
                if (!(maxValue < elem)) continue;
                maxValue = elem;
                location = r;
            }
        }
        if (this.dindex > 0) {
            rowLocation = location;
            columnLocation = location + this.dindex;
        } else if (this.dindex < 0) {
            rowLocation = location - this.dindex;
            columnLocation = location;
        } else {
            rowLocation = location;
            columnLocation = location;
        }
        return new float[]{maxValue, rowLocation, columnLocation};
    }

    @Override
    public float[] getMinLocation() {
        int columnLocation;
        int rowLocation;
        int location = 0;
        float minValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.dlength / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int location = firstRow;
                        float minValue = DiagonalFloatMatrix2D.this.elements[location];
                        for (int r = firstRow + 1; r < lastRow; ++r) {
                            float elem = DiagonalFloatMatrix2D.this.elements[r];
                            if (!(minValue > elem)) continue;
                            minValue = elem;
                            location = r;
                        }
                        return new float[]{minValue, location, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (float[])futures[j].get();
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (!(minValue > results[j][0])) continue;
                    minValue = results[j][0];
                    location = (int)results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[0];
            for (int r = 1; r < this.dlength; ++r) {
                float elem = this.elements[r];
                if (!(minValue > elem)) continue;
                minValue = elem;
                location = r;
            }
        }
        if (this.dindex > 0) {
            rowLocation = location;
            columnLocation = location + this.dindex;
        } else if (this.dindex < 0) {
            rowLocation = location - this.dindex;
            columnLocation = location;
        } else {
            rowLocation = location;
            columnLocation = location;
        }
        return new float[]{minValue, rowLocation, columnLocation};
    }

    @Override
    public float getQuick(int row, int column) {
        if (this.dindex >= 0) {
            if (column < this.dindex) {
                return 0.0f;
            }
            if (row < this.dlength && row + this.dindex == column) {
                return this.elements[row];
            }
            return 0.0f;
        }
        if (row < -this.dindex) {
            return 0.0f;
        }
        if (column < this.dlength && row + this.dindex == column) {
            return this.elements[column];
        }
        return 0.0f;
    }

    @Override
    public FloatMatrix2D like(int rows, int columns) {
        return new SparseFloatMatrix2D(rows, columns);
    }

    @Override
    public FloatMatrix1D like1D(int size) {
        return new SparseFloatMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, float value) {
        if (this.dindex >= 0) {
            if (column >= this.dindex && row < this.dlength && row + this.dindex == column) {
                this.elements[row] = value;
            }
        } else if (row >= -this.dindex && column < this.dlength && row + this.dindex == column) {
            this.elements[column] = value;
        }
    }

    @Override
    public FloatMatrix1D zMult(FloatMatrix1D y, FloatMatrix1D z, float alpha, float beta, boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseFloatMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseFloatMatrix1D && z instanceof DenseFloatMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!ignore && beta != 1.0f) {
            z.assign(FloatFunctions.mult(beta));
        }
        DenseFloatMatrix1D zz = (DenseFloatMatrix1D)z;
        float[] elementsZ = zz.elements;
        int strideZ = zz.stride();
        int zeroZ = (int)z.index(0);
        DenseFloatMatrix1D yy = (DenseFloatMatrix1D)y;
        float[] elementsY = yy.elements;
        int strideY = yy.stride();
        int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        if (!transposeA) {
            if (this.dindex >= 0) {
                int i = this.dlength;
                while (--i >= 0) {
                    int n = zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[this.dindex + zeroY + strideY * i];
                }
            } else {
                int i = this.dlength;
                while (--i >= 0) {
                    int n = -this.dindex + zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[zeroY + strideY * i];
                }
            }
        } else if (this.dindex >= 0) {
            int i = this.dlength;
            while (--i >= 0) {
                int n = this.dindex + zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[zeroY + strideY * i];
            }
        } else {
            int i = this.dlength;
            while (--i >= 0) {
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[-this.dindex + zeroY + strideY * i];
            }
        }
        return z;
    }

    @Override
    protected FloatMatrix2D getContent() {
        return this;
    }
}

