/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.CGLSFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatIdentity;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatCGLS
extends AbstractFloatIterativeSolver {
    private static final DenseFloatAlgebra alg = DenseFloatAlgebra.DEFAULT;
    public static final float sqrteps = (float)Math.sqrt(Math.pow(2.0, -52.0));

    public FloatCGLS() {
        this.iter = new CGLSFloatIterationMonitor();
        ((CGLSFloatIterationMonitor)this.iter).setRelativeTolerance(-1.0f);
    }

    @Override
    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        float gamma;
        float oldgamma = 0.0f;
        if ((double)((CGLSFloatIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((CGLSFloatIterationMonitor)this.iter).setRelativeTolerance(sqrteps * alg.norm2(A.zMult(b, null, 1.0f, 0.0f, true)));
        }
        FloatMatrix1D s = A.zMult(x, null);
        s.assign(b, FloatFunctions.plusMultFirst(-1.0f));
        FloatMatrix1D r = A.zMult(s, null, 1.0f, 0.0f, true);
        float rnrm = alg.norm2(r);
        if (!(this.M instanceof FloatIdentity)) {
            r = this.M.transApply(r, null);
            gamma = alg.norm2(r);
            gamma *= gamma;
        } else {
            gamma = rnrm;
            gamma *= gamma;
        }
        FloatMatrix1D p = r.copy();
        this.iter.setFirst();
        while (!this.iter.converged(rnrm, x)) {
            FloatMatrix1D q;
            if (!this.iter.isFirst()) {
                float beta = gamma / oldgamma;
                p.assign(r, FloatFunctions.plusMultFirst(beta));
            }
            if (!(this.M instanceof FloatIdentity)) {
                r = this.M.apply(p, null);
                q = A.zMult(r, null);
            } else {
                q = A.zMult(p, null);
            }
            float nq = alg.norm2(q);
            nq *= nq;
            float alpha = gamma / nq;
            if (!(this.M instanceof FloatIdentity)) {
                x.assign(r, FloatFunctions.plusMultSecond(alpha));
            } else {
                x.assign(p, FloatFunctions.plusMultSecond(alpha));
            }
            s.assign(q, FloatFunctions.plusMultSecond(-alpha));
            r = A.zMult(s, null, 1.0f, 0.0f, true);
            rnrm = alg.norm2(r);
            if (!(this.M instanceof FloatIdentity)) {
                r = this.M.transApply(r, null);
                oldgamma = gamma;
                gamma = alg.norm2(r);
                gamma *= gamma;
            } else {
                oldgamma = gamma;
                gamma = rnrm;
                gamma *= gamma;
            }
            this.iter.next();
        }
        return x;
    }
}

