/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatBiCGstab
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D p;
    private FloatMatrix1D s;
    private FloatMatrix1D phat;
    private FloatMatrix1D shat;
    private FloatMatrix1D t;
    private FloatMatrix1D v;
    private FloatMatrix1D temp;
    private FloatMatrix1D r;
    private FloatMatrix1D rtilde;

    public FloatBiCGstab(FloatMatrix1D template) {
        this.p = template.copy();
        this.s = template.copy();
        this.phat = template.copy();
        this.shat = template.copy();
        this.t = template.copy();
        this.v = template.copy();
        this.temp = template.copy();
        this.r = template.copy();
        this.rtilde = template.copy();
    }

    @Override
    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(A, b, x);
        float rho_1 = 1.0f;
        float rho_2 = 1.0f;
        float alpha = 1.0f;
        float beta = 1.0f;
        float omega = 1.0f;
        A.zMult(x, this.r.assign(b), -1.0f, 1.0f, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            rho_1 = this.rtilde.zDotProduct(this.r);
            if (rho_1 == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (omega == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "omega", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.assign(this.r);
            } else {
                beta = rho_1 / rho_2 * (alpha / omega);
                this.temp.assign(this.v, FloatFunctions.multSecond(-omega)).assign(this.p, FloatFunctions.plus);
                this.p.assign(this.r).assign(this.temp, FloatFunctions.plusMultSecond(beta));
            }
            this.M.apply(this.p, this.phat);
            A.zMult(this.phat, this.v);
            alpha = rho_1 / this.rtilde.zDotProduct(this.v);
            this.s.assign(this.r).assign(this.v, FloatFunctions.plusMultSecond(-alpha));
            if (this.iter.converged(this.s, x)) {
                return x.assign(this.phat, FloatFunctions.plusMultSecond(alpha));
            }
            this.M.apply(this.s, this.shat);
            A.zMult(this.shat, this.t);
            omega = this.t.zDotProduct(this.s) / this.t.zDotProduct(this.t);
            x.assign(this.phat, FloatFunctions.plusMultSecond(alpha));
            x.assign(this.shat, FloatFunctions.plusMultSecond(omega));
            this.r.assign(this.s).assign(this.t, FloatFunctions.plusMultSecond(-omega));
            rho_2 = rho_1;
            this.iter.next();
        }
        return x;
    }
}

