/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.FloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.FloatIterationReporter;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.NoFloatIterationReporter;

public abstract class AbstractFloatIterationMonitor
implements FloatIterationMonitor {
    protected int iter;
    protected Norm normType = Norm.Two;
    protected FloatIterationReporter reporter = new NoFloatIterationReporter();
    protected float residual;

    @Override
    public void setFirst() {
        this.iter = 0;
    }

    @Override
    public boolean isFirst() {
        return this.iter == 0;
    }

    @Override
    public void next() {
        ++this.iter;
    }

    @Override
    public int iterations() {
        return this.iter;
    }

    @Override
    public boolean converged(FloatMatrix1D r, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        return this.converged(DenseFloatAlgebra.DEFAULT.norm(r, this.normType), x);
    }

    @Override
    public boolean converged(float r, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.reporter.monitor(r, x, this.iter);
        this.residual = r;
        return this.convergedI(r, x);
    }

    @Override
    public boolean converged(float r) throws IterativeSolverFloatNotConvergedException {
        this.reporter.monitor(r, this.iter);
        this.residual = r;
        return this.convergedI(r);
    }

    protected abstract boolean convergedI(float var1, FloatMatrix1D var2) throws IterativeSolverFloatNotConvergedException;

    protected abstract boolean convergedI(float var1) throws IterativeSolverFloatNotConvergedException;

    @Override
    public boolean converged(FloatMatrix1D r) throws IterativeSolverFloatNotConvergedException {
        return this.converged(DenseFloatAlgebra.DEFAULT.norm(r, this.normType));
    }

    @Override
    public Norm getNormType() {
        return this.normType;
    }

    @Override
    public void setNormType(Norm normType) {
        this.normType = normType;
    }

    @Override
    public FloatIterationReporter getIterationReporter() {
        return this.reporter;
    }

    @Override
    public void setIterationReporter(FloatIterationReporter monitor) {
        this.reporter = monitor;
    }

    @Override
    public float residual() {
        return this.residual;
    }
}

