/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFComplexMatrix3D
extends FComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    private FloatFFT_3D fft3;
    protected float[] elements;

    public DenseFComplexMatrix3D(float[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length / 2));
        this.assign(values);
    }

    public DenseFComplexMatrix3D(FloatMatrix3D realPart) {
        this(realPart.slices(), realPart.rows(), realPart.columns());
        this.assignReal(realPart);
    }

    public DenseFComplexMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns, 0, 0, 0, rows * 2 * columns, 2 * columns, 2);
        this.elements = new float[slices * rows * 2 * columns];
    }

    public DenseFComplexMatrix3D(int slices, int rows, int columns, float[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride, boolean isNoView) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = isNoView;
    }

    @Override
    public float[] aggregate(final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFunction f) {
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0, 0);
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = zero + firstSlice * DenseFComplexMatrix3D.this.sliceStride;
                        float[] a = f.apply(new float[]{DenseFComplexMatrix3D.this.elements[idx], DenseFComplexMatrix3D.this.elements[idx + 1]});
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride + c * DenseFComplexMatrix3D.this.columnStride;
                                    a = aggr.apply(a, f.apply(new float[]{DenseFComplexMatrix3D.this.elements[idx], DenseFComplexMatrix3D.this.elements[idx + 1]}));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new float[]{this.elements[zero], this.elements[zero + 1]});
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        a = aggr.apply(a, f.apply(new float[]{this.elements[idx], this.elements[idx + 1]}));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    @Override
    public float[] aggregate(FComplexMatrix3D other, final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFComplexFunction f) {
        this.checkShape(other);
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final float[] elemsOther = (float[])other.elements();
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = zero + firstSlice * DenseFComplexMatrix3D.this.sliceStride;
                        int idxOther = zeroOther + firstSlice * sliceStrideOther;
                        float[] a = f.apply(new float[]{DenseFComplexMatrix3D.this.elements[idx], DenseFComplexMatrix3D.this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]});
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride + c * DenseFComplexMatrix3D.this.columnStride;
                                    idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                                    a = aggr.apply(a, f.apply(new float[]{DenseFComplexMatrix3D.this.elements[idx], DenseFComplexMatrix3D.this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new float[]{this.elements[zero], this.elements[zero + 1]}, new float[]{elemsOther[zeroOther], elemsOther[zeroOther + 1]});
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                        a = aggr.apply(a, f.apply(new float[]{this.elements[idx], this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    @Override
    public FComplexMatrix3D assign(final FComplexFComplexFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        if (function instanceof FComplexMult) {
                            float[] multiplicator = ((FComplexMult)function).multiplicator;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        elem[0] = DenseFComplexMatrix3D.this.elements[idx];
                                        elem[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                        DenseFComplexMatrix3D.this.elements[idx] = elem[0] * multiplicator[0] - elem[1] * multiplicator[1];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = elem[1] * multiplicator[0] + elem[0] * multiplicator[1];
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        } else {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        elem[0] = DenseFComplexMatrix3D.this.elements[idx];
                                        elem[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                        elem = function.apply(elem);
                                        DenseFComplexMatrix3D.this.elements[idx] = elem[0];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = elem[1];
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            if (function instanceof FComplexMult) {
                float[] multiplicator = ((FComplexMult)function).multiplicator;
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        for (int c = 0; c < this.columns; ++c) {
                            elem[0] = this.elements[idx];
                            elem[1] = this.elements[idx + 1];
                            this.elements[idx] = elem[0] * multiplicator[0] - elem[1] * multiplicator[1];
                            this.elements[idx + 1] = elem[1] * multiplicator[0] + elem[0] * multiplicator[1];
                            idx += this.columnStride;
                        }
                    }
                }
            } else {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        for (int c = 0; c < this.columns; ++c) {
                            elem[0] = this.elements[idx];
                            elem[1] = this.elements[idx + 1];
                            elem = function.apply(elem);
                            this.elements[idx] = elem[0];
                            this.elements[idx + 1] = elem[1];
                            idx += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final FComplexProcedure cond, final FComplexFComplexFunction f) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    elem[0] = DenseFComplexMatrix3D.this.elements[idx];
                                    elem[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                    if (cond.apply(elem)) {
                                        elem = f.apply(elem);
                                        DenseFComplexMatrix3D.this.elements[idx] = elem[0];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = elem[1];
                                    }
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        elem[0] = this.elements[idx];
                        elem[1] = this.elements[idx + 1];
                        if (cond.apply(elem)) {
                            elem = f.apply(elem);
                            this.elements[idx] = elem[0];
                            this.elements[idx + 1] = elem[1];
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final FComplexProcedure cond, final float[] value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    elem[0] = DenseFComplexMatrix3D.this.elements[idx];
                                    elem[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                    if (cond.apply(elem)) {
                                        DenseFComplexMatrix3D.this.elements[idx] = value[0];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = value[1];
                                    }
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        elem[0] = this.elements[idx];
                        elem[1] = this.elements[idx + 1];
                        if (cond.apply(elem)) {
                            this.elements[idx] = value[0];
                            this.elements[idx + 1] = value[1];
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final FComplexRealFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        if (function == FComplexFunctions.abs) {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        float d;
                                        elem[0] = DenseFComplexMatrix3D.this.elements[idx];
                                        elem[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                        float absX = Math.abs(DenseFComplexMatrix3D.this.elements[idx]);
                                        float absY = Math.abs(DenseFComplexMatrix3D.this.elements[idx + 1]);
                                        if (absX == 0.0f && absY == 0.0f) {
                                            DenseFComplexMatrix3D.this.elements[idx] = 0.0f;
                                        } else if (absX >= absY) {
                                            d = elem[1] / elem[0];
                                            DenseFComplexMatrix3D.this.elements[idx] = absX * (float)Math.sqrt(1.0f + d * d);
                                        } else {
                                            d = elem[0] / elem[1];
                                            DenseFComplexMatrix3D.this.elements[idx] = absY * (float)Math.sqrt(1.0f + d * d);
                                        }
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = 0.0f;
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        } else {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        elem[0] = DenseFComplexMatrix3D.this.elements[idx];
                                        elem[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                        elem[0] = function.apply(elem);
                                        DenseFComplexMatrix3D.this.elements[idx] = elem[0];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = 0.0f;
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        elem[0] = this.elements[idx];
                        elem[1] = this.elements[idx + 1];
                        elem[0] = function.apply(elem);
                        this.elements[idx] = elem[0];
                        this.elements[idx + 1] = 0.0f;
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(FComplexMatrix3D source) {
        if (!(source instanceof DenseFComplexMatrix3D)) {
            super.assign(source);
            return this;
        }
        DenseFComplexMatrix3D other = (DenseFComplexMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            FComplexMatrix3D c = other.copy();
            if (!(c instanceof DenseFComplexMatrix3D)) {
                super.assign(source);
                return this;
            }
            other = (DenseFComplexMatrix3D)c;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride;
        final int rowStrideOther = other.rowStride;
        final int columnStrideOther = other.columnStride;
        final float[] elemsOther = other.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    DenseFComplexMatrix3D.this.elements[idx] = elemsOther[idxOther];
                                    DenseFComplexMatrix3D.this.elements[idx + 1] = elemsOther[idxOther + 1];
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = elemsOther[idxOther];
                        this.elements[idx + 1] = elemsOther[idxOther + 1];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(FComplexMatrix3D y, final FComplexFComplexFComplexFunction function) {
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int colStrideOther = y.columnStride();
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final float[] elemsOther = (float[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] tmp1 = new float[2];
                        float[] tmp2 = new float[2];
                        if (function == FComplexFunctions.mult) {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        tmp1[0] = DenseFComplexMatrix3D.this.elements[idx];
                                        tmp1[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                        tmp2[0] = elemsOther[idxOther];
                                        tmp2[1] = elemsOther[idxOther + 1];
                                        DenseFComplexMatrix3D.this.elements[idx] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                        idxOther += colStrideOther;
                                    }
                                }
                            }
                        } else if (function == FComplexFunctions.multConjFirst) {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        tmp1[0] = DenseFComplexMatrix3D.this.elements[idx];
                                        tmp1[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                        tmp2[0] = elemsOther[idxOther];
                                        tmp2[1] = elemsOther[idxOther + 1];
                                        DenseFComplexMatrix3D.this.elements[idx] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                        idxOther += colStrideOther;
                                    }
                                }
                            }
                        } else if (function == FComplexFunctions.multConjSecond) {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        tmp1[0] = DenseFComplexMatrix3D.this.elements[idx];
                                        tmp1[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                        tmp2[0] = elemsOther[idxOther];
                                        tmp2[1] = elemsOther[idxOther + 1];
                                        DenseFComplexMatrix3D.this.elements[idx] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                        idxOther += colStrideOther;
                                    }
                                }
                            }
                        } else {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        tmp1[0] = DenseFComplexMatrix3D.this.elements[idx];
                                        tmp1[1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                        tmp2[0] = elemsOther[idxOther];
                                        tmp2[1] = elemsOther[idxOther + 1];
                                        tmp1 = function.apply(tmp1, tmp2);
                                        DenseFComplexMatrix3D.this.elements[idx] = tmp1[0];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = tmp1[1];
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                        idxOther += colStrideOther;
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp1 = new float[2];
            float[] tmp2 = new float[2];
            if (function == FComplexFunctions.mult) {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                        for (int c = 0; c < this.columns; ++c) {
                            tmp1[0] = this.elements[idx];
                            tmp1[1] = this.elements[idx + 1];
                            tmp2[0] = elemsOther[idxOther];
                            tmp2[1] = elemsOther[idxOther + 1];
                            this.elements[idx] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                            this.elements[idx + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                            idx += this.columnStride;
                            idxOther += colStrideOther;
                        }
                    }
                }
            } else if (function == FComplexFunctions.multConjFirst) {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                        for (int c = 0; c < this.columns; ++c) {
                            tmp1[0] = this.elements[idx];
                            tmp1[1] = this.elements[idx + 1];
                            tmp2[0] = elemsOther[idxOther];
                            tmp2[1] = elemsOther[idxOther + 1];
                            this.elements[idx] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                            this.elements[idx + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                            idx += this.columnStride;
                            idxOther += colStrideOther;
                        }
                    }
                }
            } else if (function == FComplexFunctions.multConjSecond) {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                        for (int c = 0; c < this.columns; ++c) {
                            tmp1[0] = this.elements[idx];
                            tmp1[1] = this.elements[idx + 1];
                            tmp2[0] = elemsOther[idxOther];
                            tmp2[1] = elemsOther[idxOther + 1];
                            this.elements[idx] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                            this.elements[idx + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                            idx += this.columnStride;
                            idxOther += colStrideOther;
                        }
                    }
                }
            } else {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                        for (int c = 0; c < this.columns; ++c) {
                            tmp1[0] = this.elements[idx];
                            tmp1[1] = this.elements[idx + 1];
                            tmp2[0] = elemsOther[idxOther];
                            tmp2[1] = elemsOther[idxOther + 1];
                            tmp1 = function.apply(tmp1, tmp2);
                            this.elements[idx] = tmp1[0];
                            this.elements[idx + 1] = tmp1[1];
                            idx += this.columnStride;
                            idxOther += colStrideOther;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final float re, final float im) {
        if (!this.isNoView) {
            return super.assign(re, im);
        }
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    DenseFComplexMatrix3D.this.elements[idx] = re;
                                    DenseFComplexMatrix3D.this.elements[idx + 1] = im;
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = re;
                        this.elements[idx + 1] = im;
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final float[] values) {
        if (values.length != this.slices * this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*2*columns()=" + this.slices() * this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstSlice * 2 * DenseFComplexMatrix3D.this.rows * DenseFComplexMatrix3D.this.columns;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        DenseFComplexMatrix3D.this.elements[idx] = values[idxOther++];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = values[idxOther++];
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        for (int c = 0; c < this.columns; ++c) {
                            this.elements[idx] = values[idxOther++];
                            this.elements[idx + 1] = values[idxOther++];
                            idx += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final float[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        final int length = 2 * this.columns;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstSlice * DenseFComplexMatrix3D.this.sliceStride;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                float[][] currentSlice = values[s];
                                if (currentSlice.length != DenseFComplexMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseFComplexMatrix3D.this.rows());
                                }
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    float[] currentRow = currentSlice[r];
                                    if (currentRow.length != length) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2 * columns()=" + length);
                                    }
                                    System.arraycopy(currentRow, 0, DenseFComplexMatrix3D.this.elements, i, length);
                                    i += length;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                for (int s = 0; s < this.slices; ++s) {
                    float[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    for (int r = 0; r < this.rows; ++r) {
                        float[] currentRow = currentSlice[r];
                        if (currentRow.length != length) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2 * columns()=" + length);
                        }
                        System.arraycopy(currentRow, 0, this.elements, i, length);
                        i += length;
                    }
                }
            }
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                float[][] currentSlice = values[s];
                                if (currentSlice.length != DenseFComplexMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseFComplexMatrix3D.this.rows());
                                }
                                for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                    float[] currentRow = currentSlice[r];
                                    if (currentRow.length != length) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + length);
                                    }
                                    for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                        DenseFComplexMatrix3D.this.elements[idx] = currentRow[2 * c];
                                        DenseFComplexMatrix3D.this.elements[idx + 1] = currentRow[2 * c + 1];
                                        idx += DenseFComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int s = 0; s < this.slices; ++s) {
                    float[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        float[] currentRow = currentSlice[r];
                        if (currentRow.length != length) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + length);
                        }
                        for (int c = 0; c < this.columns; ++c) {
                            this.elements[idx] = currentRow[2 * c];
                            this.elements[idx + 1] = currentRow[2 * c + 1];
                            idx += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assignImaginary(FloatMatrix3D other) {
        this.checkShape(other);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final float[] elemsOther = (float[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    DenseFComplexMatrix3D.this.elements[idx + 1] = elemsOther[idxOther];
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                    idxOther += colStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx + 1] = elemsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += colStrideOther;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assignReal(FloatMatrix3D other) {
        this.checkShape(other);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final float[] elemsOther = (float[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    DenseFComplexMatrix3D.this.elements[idx] = elemsOther[idxOther];
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                    idxOther += colStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = elemsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += colStrideOther;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    if ((double)DenseFComplexMatrix3D.this.elements[idx] != 0.0 || (double)DenseFComplexMatrix3D.this.elements[idx + 1] != 0.0) {
                                        ++cardinality;
                                    }
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        if ((double)this.elements[idx] != 0.0 || (double)this.elements[idx + 1] != 0.0) {
                            ++cardinality;
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return cardinality;
    }

    public void fft2Slices() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            ((DenseFComplexMatrix2D)DenseFComplexMatrix3D.this.viewSlice(s)).fft2();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                ((DenseFComplexMatrix2D)this.viewSlice(s)).fft2();
            }
        }
    }

    public void fft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.complexForward(this.elements);
        } else {
            FComplexMatrix3D copy = this.copy();
            this.fft3.complexForward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public FloatMatrix3D getImaginaryPart() {
        DenseFloatMatrix3D Im = new DenseFloatMatrix3D(this.slices, this.rows, this.columns);
        final float[] elemsOther = Im.elements();
        final int sliceStrideOther = Im.sliceStride();
        final int rowStrideOther = Im.rowStride();
        final int columnStrideOther = Im.columnStride();
        final int zeroOther = (int)Im.index(0, 0, 0);
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    elemsOther[idxOther] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        elemsOther[idxOther] = this.elements[idx + 1];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                    }
                }
            }
        }
        return Im;
    }

    @Override
    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, ArrayList<float[]> valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                for (int c = 0; c < this.columns; ++c) {
                    float[] elem = new float[]{this.elements[idx], this.elements[idx + 1]};
                    if (elem[0] != 0.0f || elem[1] != 0.0f) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(elem);
                    }
                    idx += this.columnStride;
                }
            }
        }
    }

    @Override
    public float[] getQuick(int slice, int row, int column) {
        int idx = this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        return new float[]{this.elements[idx], this.elements[idx + 1]};
    }

    @Override
    public FloatMatrix3D getRealPart() {
        DenseFloatMatrix3D R = new DenseFloatMatrix3D(this.slices, this.rows, this.columns);
        final float[] elemsOther = R.elements();
        final int sliceStrideOther = R.sliceStride();
        final int rowStrideOther = R.rowStride();
        final int columnStrideOther = R.columnStride();
        final int zeroOther = (int)R.index(0, 0, 0);
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    elemsOther[idxOther] = DenseFComplexMatrix3D.this.elements[idx];
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        elemsOther[idxOther] = this.elements[idx];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                    }
                }
            }
        }
        return R;
    }

    public void ifft2Slices(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            ((DenseFComplexMatrix2D)DenseFComplexMatrix3D.this.viewSlice(s)).ifft2(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                ((DenseFComplexMatrix2D)this.viewSlice(s)).ifft2(scale);
            }
        }
    }

    public void ifft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.complexInverse(this.elements, scale);
        } else {
            FComplexMatrix3D copy = this.copy();
            this.fft3.complexInverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public FComplexMatrix3D like(int slices, int rows, int columns) {
        return new DenseFComplexMatrix3D(slices, rows, columns);
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        return new DenseFComplexMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int slice, int row, int column, float re, float im) {
        int idx = this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = re;
        this.elements[idx + 1] = im;
    }

    @Override
    public void setQuick(int slice, int row, int column, float[] value) {
        int idx = this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = value[0];
        this.elements[idx + 1] = value[1];
    }

    @Override
    public float[][][] toArray() {
        final int zero = (int)this.index(0, 0, 0);
        final float[][][] values = new float[this.slices][this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            float[][] currentSlice = values[s];
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                float[] currentRow = currentSlice[r];
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    currentRow[2 * c] = DenseFComplexMatrix3D.this.elements[idx];
                                    currentRow[2 * c + 1] = DenseFComplexMatrix3D.this.elements[idx + 1];
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                float[][] currentSlice = values[s];
                for (int r = 0; r < this.rows; ++r) {
                    float[] currentRow = currentSlice[r];
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        currentRow[2 * c] = this.elements[idx];
                        currentRow[2 * c + 1] = this.elements[idx + 1];
                        idx += this.columnStride;
                    }
                }
            }
        }
        return values;
    }

    @Override
    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D v = new DenseFComplexMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        for (int s = 0; s < this.slices; ++s) {
            FComplexMatrix2D slice = this.viewSlice(s);
            v.viewPart(s * length, length).assign(slice.vectorize());
        }
        return v;
    }

    @Override
    public float[] zSum() {
        float[] sum = new float[2];
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] sum = new float[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseFComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseFComplexMatrix3D.this.sliceStride + r * DenseFComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseFComplexMatrix3D.this.columns; ++c) {
                                    sum[0] = sum[0] + DenseFComplexMatrix3D.this.elements[idx];
                                    sum[1] = sum[1] + DenseFComplexMatrix3D.this.elements[idx + 1];
                                    idx += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return sum;
                    }
                });
            }
            try {
                for (int j = 0; j < nthreads; ++j) {
                    float[] tmp = (float[])futures[j].get();
                    sum[0] = sum[0] + tmp[0];
                    sum[1] = sum[1] + tmp[1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        sum[0] = sum[0] + this.elements[idx];
                        sum[1] = sum[1] + this.elements[idx + 1];
                        idx += this.columnStride;
                    }
                }
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix3D other) {
        if (other instanceof SelectedDenseFComplexMatrix3D) {
            SelectedDenseFComplexMatrix3D otherMatrix = (SelectedDenseFComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseFComplexMatrix3D) {
            DenseFComplexMatrix3D otherMatrix = (DenseFComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    protected FComplexMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseFComplexMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride, false);
    }

    @Override
    protected FComplexMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseFComplexMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

