/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.Transpose;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SelectedDenseColumnDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netlib.blas.BLAS;

public class DenseColumnDoubleMatrix2D
extends DoubleMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private DoubleFFT_2D fft2;
    private DoubleDCT_2D dct2;
    private DoubleDST_2D dst2;
    private DoubleDHT_2D dht2;
    protected double[] elements;

    public DenseColumnDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseColumnDoubleMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 1, rows);
        this.elements = new double[rows * columns];
    }

    public DenseColumnDoubleMatrix2D(int rows, int columns, double[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public DenseColumnDoubleMatrix2D(MatrixVectorReader reader) throws IOException {
        block7: {
            int i;
            double[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block6: {
                info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = reader.readMatrixSize(info);
                this.setUp(size.numRows(), size.numColumns());
                this.elements = new double[this.rows * this.columns];
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new double[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                for (i = 0; i < numEntries; ++i) {
                    this.setQuick(rowIndexes[i], columnIndexes[i], values[i]);
                }
                if (!info.isSymmetric()) break block6;
                for (i = 0; i < numEntries; ++i) {
                    if (rowIndexes[i] == columnIndexes[i]) continue;
                    this.setQuick(columnIndexes[i], rowIndexes[i], values[i]);
                }
                break block7;
            }
            if (!info.isSkewSymmetric()) break block7;
            for (i = 0; i < numEntries; ++i) {
                if (rowIndexes[i] == columnIndexes[i]) continue;
                this.setQuick(columnIndexes[i], rowIndexes[i], -values[i]);
            }
        }
    }

    @Override
    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int zero = (int)this.index(0, 0);
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DenseColumnDoubleMatrix2D.this.elements[zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnDoubleMatrix2D.this.columnStride;
                            int r = DenseColumnDoubleMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnDoubleMatrix2D.this.elements[r * DenseColumnDoubleMatrix2D.this.rowStride + cidx]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, final DoubleProcedure cond) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int zero = (int)this.index(0, 0);
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double elem = DenseColumnDoubleMatrix2D.this.elements[zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride];
                        double a = 0.0;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnDoubleMatrix2D.this.columnStride;
                            int r = DenseColumnDoubleMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                elem = DenseColumnDoubleMatrix2D.this.elements[r * DenseColumnDoubleMatrix2D.this.rowStride + cidx];
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            double elem = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (cond.apply(elem)) {
                a = f.apply(elem);
            }
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    elem = this.elements[r * this.rowStride + cidx];
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DenseColumnDoubleMatrix2D.this.elements[zero + rowElements[firstIdx - 1] * DenseColumnDoubleMatrix2D.this.rowStride + columnElements[firstIdx - 1] * DenseColumnDoubleMatrix2D.this.columnStride]);
                        int i = firstIdx - 1;
                        while (--i >= lastIdx) {
                            a = aggr.apply(a, f.apply(DenseColumnDoubleMatrix2D.this.elements[zero + rowElements[i] * DenseColumnDoubleMatrix2D.this.rowStride + columnElements[i] * DenseColumnDoubleMatrix2D.this.columnStride]));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[size - 1] * this.rowStride + columnElements[size - 1] * this.columnStride]);
            int i = size - 1;
            while (--i >= 0) {
                a = aggr.apply(a, f.apply(this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride]));
            }
        }
        return a;
    }

    @Override
    public double aggregate(DoubleMatrix2D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        if (!(other instanceof DenseColumnDoubleMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final double[] otherElements = (double[])other.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DenseColumnDoubleMatrix2D.this.elements[zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride], otherElements[zeroOther + (DenseColumnDoubleMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnDoubleMatrix2D.this.columnStride;
                            int cidxOther = zeroOther + c * columnStrideOther;
                            int r = DenseColumnDoubleMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnDoubleMatrix2D.this.elements[r * DenseColumnDoubleMatrix2D.this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], otherElements[zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther]);
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int cidxOther = zeroOther + c * columnStrideOther;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public DoubleMatrix2D assign(final DoubleFunction function) {
        if (function instanceof DoubleMult) {
            double multiplicator = ((DoubleMult)function).multiplicator;
            if (multiplicator == 1.0) {
                return this;
            }
            if (multiplicator == 0.0) {
                return this.assign(0.0);
            }
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        if (function instanceof DoubleMult) {
                            double multiplicator = ((DoubleMult)function).multiplicator;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnDoubleMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnDoubleMatrix2D.this.elements[n] = DenseColumnDoubleMatrix2D.this.elements[n] * multiplicator;
                                    i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                        } else {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnDoubleMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnDoubleMatrix2D.this.elements[i] = function.apply(DenseColumnDoubleMatrix2D.this.elements[i]);
                                    i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (function instanceof DoubleMult) {
                double multiplicator = ((DoubleMult)function).multiplicator;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] * multiplicator;
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            } else {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = function.apply(this.elements[i]);
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(final DoubleProcedure cond, final DoubleFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                double elem = DenseColumnDoubleMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnDoubleMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    double elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(final DoubleProcedure cond, final double value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                double elem = DenseColumnDoubleMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnDoubleMatrix2D.this.elements[i] = value;
                                }
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    double elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(final double value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnDoubleMatrix2D.this.elements[i] = value;
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = value;
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(final double[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                            int idxOther = DenseColumnDoubleMatrix2D.this.rows - 1 + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.rows;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnDoubleMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnDoubleMatrix2D.this.elements[i] = values[idxOther--];
                                    i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = values.length - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = values[idxOther--];
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(final double[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "columns()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (firstRow - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (DenseColumnDoubleMatrix2D.this.columns - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int r = firstRow;
                        while (--r >= lastRow) {
                            double[] currentRow = values[r];
                            if (currentRow.length != DenseColumnDoubleMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + DenseColumnDoubleMatrix2D.this.columns());
                            }
                            int i = idx;
                            int c = DenseColumnDoubleMatrix2D.this.columns;
                            while (--c >= 0) {
                                DenseColumnDoubleMatrix2D.this.elements[i] = currentRow[c];
                                i -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int r = this.rows;
            while (--r >= 0) {
                double[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + this.columns());
                }
                int i = idx;
                int c = this.columns;
                while (--c >= 0) {
                    this.elements[i] = currentRow[c];
                    i -= this.columnStride;
                }
                idx -= this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (!(source instanceof DenseColumnDoubleMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseColumnDoubleMatrix2D other = (DenseColumnDoubleMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DoubleMatrix2D c = other.copy();
            if (!(c instanceof DenseColumnDoubleMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseColumnDoubleMatrix2D)c;
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final double[] otherElements = other.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnDoubleMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnDoubleMatrix2D.this.elements[i] = otherElements[j];
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                j -= rowStrideOther;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                            idxOther -= columnStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = otherElements[j];
                    i -= this.rowStride;
                    j -= rowStrideOther;
                }
                idx -= this.columnStride;
                idxOther -= columnStrideOther;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D y, final DoubleDoubleFunction function) {
        double multiplicator;
        if (function instanceof DoublePlusMultSecond && (multiplicator = ((DoublePlusMultSecond)function).multiplicator) == 0.0) {
            return this;
        }
        if (function instanceof DoublePlusMultFirst && (multiplicator = ((DoublePlusMultFirst)function).multiplicator) == 0.0) {
            return this.assign(y);
        }
        if (!(y instanceof DenseColumnDoubleMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnDoubleMatrix2D other = (DenseColumnDoubleMatrix2D)y;
        this.checkShape(y);
        final double[] otherElements = other.elements;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnDoubleMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        if (function == DoubleFunctions.mult) {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnDoubleMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnDoubleMatrix2D.this.elements[n] = DenseColumnDoubleMatrix2D.this.elements[n] * otherElements[j];
                                    i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        } else if (function == DoubleFunctions.div) {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnDoubleMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnDoubleMatrix2D.this.elements[n] = DenseColumnDoubleMatrix2D.this.elements[n] / otherElements[j];
                                    i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        } else if (function instanceof DoublePlusMultSecond) {
                            double multiplicator = ((DoublePlusMultSecond)function).multiplicator;
                            if (multiplicator == 1.0) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnDoubleMatrix2D.this.elements[n] = DenseColumnDoubleMatrix2D.this.elements[n] + otherElements[j];
                                        i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else if (multiplicator == -1.0) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnDoubleMatrix2D.this.elements[n] = DenseColumnDoubleMatrix2D.this.elements[n] - otherElements[j];
                                        i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnDoubleMatrix2D.this.elements[n] = DenseColumnDoubleMatrix2D.this.elements[n] + multiplicator * otherElements[j];
                                        i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            }
                        } else if (function instanceof DoublePlusMultFirst) {
                            double multiplicator = ((DoublePlusMultFirst)function).multiplicator;
                            if (multiplicator == 1.0) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnDoubleMatrix2D.this.elements[n] = DenseColumnDoubleMatrix2D.this.elements[n] + otherElements[j];
                                        i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else if (multiplicator == -1.0) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        DenseColumnDoubleMatrix2D.this.elements[i] = otherElements[j] - DenseColumnDoubleMatrix2D.this.elements[i];
                                        i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnDoubleMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        DenseColumnDoubleMatrix2D.this.elements[i] = multiplicator * DenseColumnDoubleMatrix2D.this.elements[i] + otherElements[j];
                                        i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            }
                        } else {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnDoubleMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnDoubleMatrix2D.this.elements[i] = function.apply(DenseColumnDoubleMatrix2D.this.elements[i], otherElements[j]);
                                    i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            if (function == DoubleFunctions.mult) {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] * otherElements[j];
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            } else if (function == DoubleFunctions.div) {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] / otherElements[j];
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            } else if (function instanceof DoublePlusMultSecond) {
                double multiplicator2 = ((DoublePlusMultSecond)function).multiplicator;
                if (multiplicator2 == 1.0) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else if (multiplicator2 == -1.0) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] - otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + multiplicator2 * otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                }
            } else if (function instanceof DoublePlusMultFirst) {
                double multiplicator3 = ((DoublePlusMultFirst)function).multiplicator;
                if (multiplicator3 == 1.0) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else if (multiplicator3 == -1.0) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            this.elements[i] = otherElements[j] - this.elements[i];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            this.elements[i] = multiplicator3 * this.elements[i] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                }
            } else {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = function.apply(this.elements[i], otherElements[j]);
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D y, final DoubleDoubleFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        if (!(y instanceof DenseColumnDoubleMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnDoubleMatrix2D other = (DenseColumnDoubleMatrix2D)y;
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final double[] otherElements = other.elements();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (--i >= lastIdx) {
                            int idx = zero + rowElements[i] * DenseColumnDoubleMatrix2D.this.rowStride + columnElements[i] * DenseColumnDoubleMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseColumnDoubleMatrix2D.this.elements[idx] = function.apply(DenseColumnDoubleMatrix2D.this.elements[idx], otherElements[idxOther]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = size;
            while (--i >= 0) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], otherElements[idxOther]);
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(final float[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int idxOther = DenseColumnDoubleMatrix2D.this.rows - 1 + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.rows;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnDoubleMatrix2D.this.elements[i] = values[idxOther--];
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = values.length - 1;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = values[idxOther--];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                if (DenseColumnDoubleMatrix2D.this.elements[i] != 0.0) {
                                    ++cardinality;
                                }
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    if (this.elements[i] != 0.0) {
                        ++cardinality;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return cardinality;
    }

    public void dct2(boolean scale) {
        DoubleMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        this.dct2.forward((double[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dctColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(c)).dct(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).dct(scale);
            }
        }
    }

    public void dctRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(r)).dct(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).dct(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht2() {
        DoubleMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        this.dht2.forward((double[])transpose.elements());
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtColumns() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(c)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtRows() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(r)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst2(boolean scale) {
        DoubleMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        this.dst2.forward((double[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dstColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(c)).dst(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).dst(scale);
            }
        }
    }

    public void dstRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(r)).dst(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).dst(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public double[] elements() {
        return this.elements;
    }

    public void fft2() {
        DoubleMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realForward((double[])transpose.elements());
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                double value = DenseColumnDoubleMatrix2D.this.elements[i];
                                if (value != 0.0) {
                                    DenseColumnDoubleMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    double value = this.elements[i];
                    if (value != 0.0) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public DenseDoubleMatrix2D getRowMajor() {
        DenseDoubleMatrix2D R = new DenseDoubleMatrix2D(this.rows, this.columns);
        final int zeroR = (int)R.index(0, 0);
        final int rowStrideR = R.rowStride();
        final int columnStrideR = R.columnStride();
        final double[] elementsR = R.elements();
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int idxR = zeroR + (DenseColumnDoubleMatrix2D.this.rows - 1) * rowStrideR + (firstColumn - 1) * columnStrideR;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxR;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsR[j] = DenseColumnDoubleMatrix2D.this.elements[i];
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                j -= rowStrideR;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                            idxR -= columnStrideR;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxR = zeroR + (this.rows - 1) * rowStrideR + (this.columns - 1) * columnStrideR;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxR;
                int r = this.rows;
                while (--r >= 0) {
                    elementsR[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideR;
                }
                idx -= this.columnStride;
                idxR -= columnStrideR;
            }
        }
        return R;
    }

    public DenseDComplexMatrix2D getFft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        final double[] elementsC = C.elements();
        final int zero = (int)this.index(0, 0);
        final int zeroC = (int)C.index(0, 0);
        final int rowStrideC = C.rowStride() / 2;
        boolean columnStrideC = true;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int idxOther = zeroC + (DenseColumnDoubleMatrix2D.this.rows - 1) * rowStrideC + (firstColumn - 1) * 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsC[j] = DenseColumnDoubleMatrix2D.this.elements[i];
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                j -= rowStrideC;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                            --idxOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroC + (this.rows - 1) * rowStrideC + (this.columns - 1) * 1;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    elementsC[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideC;
                }
                idx -= this.columnStride;
                --idxOther;
            }
        }
        this.fft2.realForwardFull(elementsC);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix2D getFftColumns() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            C.viewColumn(c).assign(((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(c)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                C.viewColumn(c).assign(((DenseDoubleMatrix1D)this.viewColumn(c)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix2D getFftRows() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            C.viewRow(r).assign(((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(r)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = this.rows;
            while (--r >= 0) {
                C.viewRow(r).assign(((DenseDoubleMatrix1D)this.viewRow(r)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DComplexMatrix2D getIfft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        final double[] elementsC = C.elements();
        final int zero = (int)this.index(0, 0);
        final int zeroC = (int)C.index(0, 0);
        final int rowStrideC = C.rowStride() / 2;
        boolean columnStrideC = true;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int idxOther = zeroC + (DenseColumnDoubleMatrix2D.this.rows - 1) * rowStrideC + (firstColumn - 1) * 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsC[j] = DenseColumnDoubleMatrix2D.this.elements[i];
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                j -= rowStrideC;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                            --idxOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroC + (this.rows - 1) * rowStrideC + (this.columns - 1) * 1;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    elementsC[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideC;
                }
                idx -= this.columnStride;
                --idxOther;
            }
        }
        this.fft2.realInverseFull(elementsC, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DComplexMatrix2D getIfftColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            C.viewColumn(c).assign(((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(c)).getIfft(scale));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                C.viewColumn(c).assign(((DenseDoubleMatrix1D)this.viewColumn(c)).getIfft(scale));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DComplexMatrix2D getIfftRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            C.viewRow(r).assign(((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(r)).getIfft(scale));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = this.rows;
            while (--r >= 0) {
                C.viewRow(r).assign(((DenseDoubleMatrix1D)this.viewRow(r)).getIfft(scale));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    @Override
    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int c = 0; c < this.columns; ++c) {
            int i = idx;
            for (int r = 0; r < this.rows; ++r) {
                double value = this.elements[i];
                if (value < 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
            }
            idx += this.columnStride;
        }
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int c = 0; c < this.columns; ++c) {
            int i = idx;
            for (int r = 0; r < this.rows; ++r) {
                double value = this.elements[i];
                if (value != 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
            }
            idx += this.columnStride;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int c = 0; c < this.columns; ++c) {
            int i = idx;
            for (int r = 0; r < this.rows; ++r) {
                double value = this.elements[i];
                if (value > 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
            }
            idx += this.columnStride;
        }
    }

    @Override
    public double getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    public void idct2(boolean scale) {
        DoubleMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        this.dct2.inverse((double[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idctColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(c)).idct(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).idct(scale);
            }
        }
    }

    public void idctRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(r)).idct(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).idct(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht2(boolean scale) {
        DoubleMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        this.dht2.inverse((double[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(c)).idht(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).idht(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(r)).idht(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).idht(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst2(boolean scale) {
        DoubleMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        this.dst2.inverse((double[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idstColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewColumn(c)).idst(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).idst(scale);
            }
        }
    }

    public void idstRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseDoubleMatrix1D)DenseColumnDoubleMatrix2D.this.viewRow(r)).idst(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).idst(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft2(boolean scale) {
        DoubleMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverse((double[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new DenseColumnDoubleMatrix2D(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return new DenseDoubleMatrix1D(size);
    }

    @Override
    public double[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][3];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double maxValue = DenseColumnDoubleMatrix2D.this.elements[zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride];
                        int rowLocation = DenseColumnDoubleMatrix2D.this.rows - 1;
                        int columnLocation = firstColumn - 1;
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnDoubleMatrix2D.this.columnStride;
                            int r = DenseColumnDoubleMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                double elem = DenseColumnDoubleMatrix2D.this.elements[r * DenseColumnDoubleMatrix2D.this.rowStride + cidx];
                                if (!(maxValue < elem)) continue;
                                maxValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new double[]{maxValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (!(maxValue < results[j][0])) continue;
                    maxValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            rowLocation = this.rows - 1;
            columnLocation = this.columns - 1;
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    double elem = this.elements[r * this.rowStride + cidx];
                    if (!(maxValue < elem)) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new double[]{maxValue, rowLocation, columnLocation};
    }

    @Override
    public double[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][3];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double minValue = DenseColumnDoubleMatrix2D.this.elements[zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride];
                        int rowLocation = DenseColumnDoubleMatrix2D.this.rows - 1;
                        int columnLocation = firstColumn - 1;
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnDoubleMatrix2D.this.columnStride;
                            int r = DenseColumnDoubleMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                double elem = DenseColumnDoubleMatrix2D.this.elements[r * DenseColumnDoubleMatrix2D.this.rowStride + cidx];
                                if (!(minValue > elem)) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new double[]{minValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (!(minValue > results[j][0])) continue;
                    minValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            rowLocation = this.rows - 1;
            columnLocation = this.columns - 1;
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    double elem = this.elements[r * this.rowStride + cidx];
                    if (!(minValue > elem)) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new double[]{minValue, rowLocation, columnLocation};
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public double[][] toArray() {
        final double[][] values = new double[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                values[r][c] = DenseColumnDoubleMatrix2D.this.elements[i];
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    values[r][c] = this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return values;
    }

    @Override
    public DoubleMatrix1D vectorize() {
        int size = (int)this.size();
        DenseDoubleMatrix1D v = new DenseDoubleMatrix1D(size);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((DoubleMatrix1D)v).elements(), 0, size);
        } else {
            final int zero = (int)this.index(0, 0);
            final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
            final int strideOther = v.stride();
            final double[] elementsOther = (double[])((DoubleMatrix1D)v).elements();
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    final int firstIdxOther = size - j * k * this.rows;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                            int idxOther = zeroOther + (firstIdxOther - 1) * strideOther;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnDoubleMatrix2D.this.rows;
                                while (--r >= 0) {
                                    elementsOther[idxOther] = DenseColumnDoubleMatrix2D.this.elements[i];
                                    i -= DenseColumnDoubleMatrix2D.this.rowStride;
                                    idxOther -= strideOther;
                                }
                                idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = zeroOther + size - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        elementsOther[idxOther] = this.elements[i];
                        i -= this.rowStride;
                        --idxOther;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return v;
    }

    @Override
    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA) {
        if (z == null) {
            z = new DenseDoubleMatrix1D(transposeA ? this.columns : this.rows);
        }
        if ((long)(transposeA ? this.rows : this.columns) != y.size() || (long)(transposeA ? this.columns : this.rows) > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!(y instanceof DenseDoubleMatrix1D) || !(z instanceof DenseDoubleMatrix1D) || this.isView() || y.isView() || z.isView()) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        double[] yElements = (double[])y.elements();
        double[] zElements = (double[])z.elements();
        Transpose transA = transposeA ? Transpose.Transpose : Transpose.NoTranspose;
        BLAS.getInstance().dgemv(transA.netlib(), this.rows, this.columns, alpha, this.elements, Math.max(this.rows, 1), yElements, 1, beta, zElements, 1);
        return z;
    }

    @Override
    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        int rowsB = transposeB ? B.columns() : B.rows();
        int columnsB = transposeB ? B.rows() : B.columns();
        int rowsC = rowsA;
        int columnsC = columnsB;
        if (columnsA != rowsB) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C == null) {
            C = new DenseColumnDoubleMatrix2D(rowsC, columnsC);
        } else if (rowsA != C.rows() || columnsB != C.columns()) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(B instanceof DenseColumnDoubleMatrix2D) || !(C instanceof DenseColumnDoubleMatrix2D) || this.isView() || B.isView() || C.isView()) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        Transpose transA = transposeA ? Transpose.Transpose : Transpose.NoTranspose;
        Transpose transB = transposeB ? Transpose.Transpose : Transpose.NoTranspose;
        double[] elementsA = this.elements;
        double[] elementsB = (double[])B.elements();
        double[] elementsC = (double[])C.elements();
        int lda = transposeA ? Math.max(1, columnsA) : Math.max(1, rowsA);
        int ldb = transposeB ? Math.max(1, columnsB) : Math.max(1, rowsB);
        int ldc = Math.max(1, rowsA);
        BLAS.getInstance().dgemm(transA.netlib(), transB.netlib(), rowsA, columnsB, columnsA, alpha, elementsA, lda, elementsB, ldb, beta, elementsC, ldc);
        return C;
    }

    @Override
    public double zSum() {
        double sum = 0.0;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sum = 0.0;
                        int idx = zero + (DenseColumnDoubleMatrix2D.this.rows - 1) * DenseColumnDoubleMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnDoubleMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnDoubleMatrix2D.this.rows;
                            while (--r >= 0) {
                                sum += DenseColumnDoubleMatrix2D.this.elements[i];
                                i -= DenseColumnDoubleMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnDoubleMatrix2D.this.columnStride;
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    sum += ((Double)futures[j].get()).doubleValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    sum += this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix2D other) {
        if (other instanceof SelectedDenseColumnDoubleMatrix2D) {
            SelectedDenseColumnDoubleMatrix2D otherMatrix = (SelectedDenseColumnDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnDoubleMatrix2D) {
            DenseColumnDoubleMatrix2D otherMatrix = (DenseColumnDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected DoubleMatrix1D like1D(int size, int zero, int stride) {
        return new DenseDoubleMatrix1D(size, this.elements, zero, stride, true);
    }

    @Override
    protected DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnDoubleMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

