/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.Norm;
import cern.colt.matrix.tbit.QuickBitVector;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.SmpDoubleBlas;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleEigenvalueDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleQRDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleSingularValueDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tint.IntFunctions;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseDoubleAlgebra
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DenseDoubleAlgebra DEFAULT = new DenseDoubleAlgebra();
    public static final DenseDoubleAlgebra ZERO;
    protected DoubleProperty property;

    public DenseDoubleAlgebra() {
        this(DoubleProperty.DEFAULT.tolerance());
    }

    public DenseDoubleAlgebra(double tolerance) {
        this.setProperty(new DoubleProperty(tolerance));
    }

    public DenseDoubleCholeskyDecomposition chol(DoubleMatrix2D matrix) {
        return new DenseDoubleCholeskyDecomposition(matrix);
    }

    @Override
    public Object clone() {
        return new DenseDoubleAlgebra(this.property.tolerance());
    }

    public double cond(DoubleMatrix2D A) {
        return this.svd(A).cond();
    }

    public double det(DoubleMatrix2D A) {
        return this.lu(A).det();
    }

    public DenseDoubleEigenvalueDecomposition eig(DoubleMatrix2D matrix) {
        return new DenseDoubleEigenvalueDecomposition(matrix);
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static DoubleDoubleFunction hypotFunction() {
        return new DoubleDoubleFunction(){

            @Override
            public final double apply(double a, double b) {
                return DenseDoubleAlgebra.hypot(a, b);
            }
        };
    }

    public DoubleMatrix2D inverse(DoubleMatrix2D A) {
        if (this.property.isSquare(A) && this.property.isDiagonal(A)) {
            DoubleMatrix2D inv = A.copy();
            boolean isNonSingular = true;
            int i = inv.rows();
            while (--i >= 0) {
                double v = inv.getQuick(i, i);
                isNonSingular &= v != 0.0;
                inv.setQuick(i, i, 1.0 / v);
            }
            if (!isNonSingular) {
                throw new IllegalArgumentException("A is singular.");
            }
            return inv;
        }
        return this.solve(A, DoubleFactory2D.dense.identity(A.rows()));
    }

    public DenseDoubleLUDecomposition lu(DoubleMatrix2D matrix) {
        return new DenseDoubleLUDecomposition(matrix);
    }

    public DoubleMatrix1D kron(final DoubleMatrix1D x, final DoubleMatrix1D y) {
        int size_x = (int)x.size();
        final int size_y = (int)y.size();
        final DenseDoubleMatrix1D C = new DenseDoubleMatrix1D(size_x * size_y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size_x >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, size_x);
            Future[] futures = new Future[nthreads];
            int k = size_x / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size_x : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            C.viewPart(i * size_y, size_y).assign(y, DoubleFunctions.multSecond(x.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            for (int i = 0; i < size_x; ++i) {
                C.viewPart(i * size_y, size_y).assign(y, DoubleFunctions.multSecond(x.getQuick(i)));
            }
        }
        return C;
    }

    public DoubleMatrix2D kron(final DoubleMatrix2D X, final DoubleMatrix2D Y) {
        int rows_x = X.rows();
        final int columns_x = X.columns();
        final int rows_y = Y.rows();
        final int columns_y = Y.columns();
        if (X.getClass().getName().indexOf("Dense", 0) != -1 && Y.getClass().getName().indexOf("Dense", 0) != -1) {
            final DenseDoubleMatrix2D C = new DenseDoubleMatrix2D(rows_x * rows_y, columns_x * columns_y);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && X.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
                nthreads = Math.min(nthreads, rows_x);
                Future[] futures = new Future[nthreads];
                int k = rows_x / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? rows_x : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < columns_x; ++c) {
                                    C.viewPart(r * rows_y, c * columns_y, rows_y, columns_y).assign(Y, DoubleFunctions.multSecond(X.getQuick(r, c)));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                ConcurrencyUtils.resetThreadsBeginN();
            } else {
                for (int r = 0; r < rows_x; ++r) {
                    for (int c = 0; c < columns_x; ++c) {
                        C.viewPart(r * rows_y, c * columns_y, rows_y, columns_y).assign(Y, DoubleFunctions.multSecond(X.getQuick(r, c)));
                    }
                }
            }
            return C;
        }
        IntArrayList iaList = new IntArrayList();
        IntArrayList jaList = new IntArrayList();
        DoubleArrayList saList = new DoubleArrayList();
        IntArrayList ibList = new IntArrayList();
        IntArrayList jbList = new IntArrayList();
        DoubleArrayList sbList = new DoubleArrayList();
        X.getNonZeros(iaList, jaList, saList);
        Y.getNonZeros(ibList, jbList, sbList);
        iaList.trimToSize();
        jaList.trimToSize();
        saList.trimToSize();
        ibList.trimToSize();
        jbList.trimToSize();
        sbList.trimToSize();
        DenseIntMatrix1D ia = new DenseIntMatrix1D(iaList.elements());
        DenseIntMatrix1D ja = new DenseIntMatrix1D(jaList.elements());
        DenseDoubleMatrix1D sa = new DenseDoubleMatrix1D(saList.elements());
        DenseIntMatrix1D ib = new DenseIntMatrix1D(ibList.elements());
        DenseIntMatrix1D jb = new DenseIntMatrix1D(jbList.elements());
        DenseDoubleMatrix1D sb = new DenseDoubleMatrix1D(sbList.elements());
        ((IntMatrix1D)ia).assign(IntFunctions.mult(rows_y));
        DenseIntMatrix2D ik = new DenseIntMatrix2D(sbList.size(), (int)ia.size());
        for (int i = 0; i < sbList.size(); ++i) {
            ik.viewRow(i).assign(ia).assign(IntFunctions.plus(((IntMatrix1D)ib).getQuick(i)));
        }
        ((IntMatrix1D)ja).assign(IntFunctions.mult(columns_y));
        DenseIntMatrix2D jk = new DenseIntMatrix2D(sbList.size(), (int)ja.size());
        for (int i = 0; i < sbList.size(); ++i) {
            jk.viewRow(i).assign(ja).assign(IntFunctions.plus(((IntMatrix1D)jb).getQuick(i)));
        }
        DoubleMatrix2D sk = this.multOuter(sa, sb, null);
        if (X instanceof SparseCCDoubleMatrix2D || Y instanceof SparseCCDoubleMatrix2D) {
            return new SparseCCDoubleMatrix2D(rows_x * rows_y, columns_x * columns_y, (int[])((IntMatrix2D)ik).vectorize().elements(), (int[])((IntMatrix2D)jk).vectorize().elements(), (double[])sk.viewDice().vectorize().elements(), false, false, false);
        }
        return new SparseRCDoubleMatrix2D(rows_x * rows_y, columns_x * columns_y, (int[])((IntMatrix2D)ik).vectorize().elements(), (int[])((IntMatrix2D)jk).vectorize().elements(), (double[])sk.viewDice().vectorize().elements(), false, false, false);
    }

    public double mult(DoubleMatrix1D x, DoubleMatrix1D y) {
        return x.zDotProduct(y);
    }

    public DoubleMatrix1D mult(DoubleMatrix2D A, DoubleMatrix1D y) {
        return A.zMult(y, null);
    }

    public DoubleMatrix2D mult(DoubleMatrix2D A, DoubleMatrix2D B) {
        return A.zMult(B, null);
    }

    public DoubleMatrix2D multOuter(final DoubleMatrix1D x, final DoubleMatrix1D y, DoubleMatrix2D A) {
        int j;
        int k;
        Future[] futures;
        int rows = (int)x.size();
        int columns = (int)y.size();
        final DoubleMatrix2D AA = A == null ? x.like2D(rows, columns) : A;
        if (AA.rows() != rows || AA.columns() != columns) {
            throw new IllegalArgumentException();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && rows >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, rows);
            futures = new Future[nthreads];
            k = rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            AA.viewRow(r).assign(y);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            int r = rows;
            while (--r >= 0) {
                AA.viewRow(r).assign(y);
            }
        }
        if (nthreads > 1 && columns >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, columns);
            futures = new Future[nthreads];
            k = columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            AA.viewColumn(c).assign(x, DoubleFunctions.mult);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            int c = columns;
            while (--c >= 0) {
                AA.viewColumn(c).assign(x, DoubleFunctions.mult);
            }
        }
        return AA;
    }

    public double norm1(DoubleMatrix1D x) {
        if (x.size() == 0L) {
            return 0.0;
        }
        return x.aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
    }

    public double norm1(DoubleMatrix2D A) {
        double max = 0.0;
        int column = A.columns();
        while (--column >= 0) {
            max = Math.max(max, this.norm1(A.viewColumn(column)));
        }
        return max;
    }

    public double norm2(DoubleMatrix1D x) {
        return Math.sqrt(x.zDotProduct(x));
    }

    public double vectorNorm2(final DoubleMatrix2D X) {
        if (X.isView() || !(X instanceof DenseDoubleMatrix2D)) {
            int rows = X.rows();
            final int columns = X.columns();
            double sum = 0.0;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int j;
                nthreads = Math.min(nthreads, rows);
                Future[] futures = new Future[nthreads];
                int k = rows / nthreads;
                for (j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                        @Override
                        public Double call() throws Exception {
                            double sum = 0.0;
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    double elem = X.getQuick(r, c);
                                    sum += elem * elem;
                                }
                            }
                            return sum;
                        }
                    });
                }
                try {
                    for (j = 0; j < nthreads; ++j) {
                        Double result = (Double)futures[j].get();
                        sum += result.doubleValue();
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < columns; ++c) {
                        double elem = X.getQuick(r, c);
                        sum += elem * elem;
                    }
                }
            }
            return Math.sqrt(sum);
        }
        final double[] elems = ((DenseDoubleMatrix2D)X).elements();
        double sum = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && elems.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, elems.length);
            Future[] futures = new Future[nthreads];
            int k = elems.length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? elems.length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sum = 0.0;
                        for (int l = firstIdx; l < lastIdx; ++l) {
                            sum += elems[l] * elems[l];
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    Double result = (Double)futures[j].get();
                    sum += result.doubleValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int l = 0; l < elems.length; ++l) {
                sum += elems[l] * elems[l];
            }
        }
        return Math.sqrt(sum);
    }

    public double vectorNorm2(final DoubleMatrix3D X) {
        if (X.isView() || !(X instanceof DenseDoubleMatrix3D)) {
            int slices = X.slices();
            final int rows = X.rows();
            final int columns = X.columns();
            double sum = 0.0;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int j;
                nthreads = Math.min(nthreads, slices);
                Future[] futures = new Future[nthreads];
                int k = slices / nthreads;
                for (j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                        @Override
                        public Double call() throws Exception {
                            double sum = 0.0;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < rows; ++r) {
                                    for (int c = 0; c < columns; ++c) {
                                        double elem = X.getQuick(s, r, c);
                                        sum += elem * elem;
                                    }
                                }
                            }
                            return sum;
                        }
                    });
                }
                try {
                    for (j = 0; j < nthreads; ++j) {
                        Double result = (Double)futures[j].get();
                        sum += result.doubleValue();
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                for (int s = 0; s < slices; ++s) {
                    for (int r = 0; r < rows; ++r) {
                        for (int c = 0; c < columns; ++c) {
                            double elem = X.getQuick(s, r, c);
                            sum += elem * elem;
                        }
                    }
                }
            }
            return Math.sqrt(sum);
        }
        final double[] elems = ((DenseDoubleMatrix3D)X).elements();
        double sum = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && elems.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, elems.length);
            Future[] futures = new Future[nthreads];
            int k = elems.length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? elems.length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sum = 0.0;
                        for (int l = firstIdx; l < lastIdx; ++l) {
                            sum += elems[l] * elems[l];
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    Double result = (Double)futures[j].get();
                    sum += result.doubleValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int l = 0; l < elems.length; ++l) {
                sum += elems[l] * elems[l];
            }
        }
        return Math.sqrt(sum);
    }

    public double norm(DoubleMatrix2D A, Norm type) {
        switch (type) {
            case Frobenius: {
                return DEFAULT.normF(A);
            }
            case Infinity: {
                return DEFAULT.normInfinity(A);
            }
            case One: {
                return DEFAULT.norm1(A);
            }
            case Two: {
                return DEFAULT.norm2(A);
            }
        }
        return 0.0;
    }

    public double norm(DoubleMatrix1D x, Norm type) {
        switch (type) {
            case Frobenius: {
                return DEFAULT.normF(x);
            }
            case Infinity: {
                return DEFAULT.normInfinity(x);
            }
            case One: {
                return DEFAULT.norm1(x);
            }
            case Two: {
                return DEFAULT.norm2(x);
            }
        }
        return 0.0;
    }

    public double norm2(DoubleMatrix2D A) {
        return this.svd(A).norm2();
    }

    public double normF(DoubleMatrix2D A) {
        if (A.size() == 0L) {
            return 0.0;
        }
        return A.aggregate(DenseDoubleAlgebra.hypotFunction(), DoubleFunctions.identity);
    }

    public double normF(DoubleMatrix1D A) {
        if (A.size() == 0L) {
            return 0.0;
        }
        return A.aggregate(DenseDoubleAlgebra.hypotFunction(), DoubleFunctions.identity);
    }

    public double normInfinity(DoubleMatrix1D x) {
        if (x.size() == 0L) {
            return 0.0;
        }
        return x.aggregate(DoubleFunctions.max, DoubleFunctions.abs);
    }

    public double normInfinity(DoubleMatrix2D A) {
        double max = 0.0;
        int row = A.rows();
        while (--row >= 0) {
            max = Math.max(max, this.norm1(A.viewRow(row)));
        }
        return max;
    }

    public DoubleMatrix1D permute(DoubleMatrix1D A, int[] indexes, double[] work) {
        int size = (int)A.size();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (work == null || size > work.length) {
            work = A.toArray();
        } else {
            A.toArray(work);
        }
        int i = size;
        while (--i >= 0) {
            A.setQuick(i, work[indexes[i]]);
        }
        return A;
    }

    public DoubleMatrix2D permute(DoubleMatrix2D A, int[] rowIndexes, int[] columnIndexes) {
        return A.viewSelection(rowIndexes, columnIndexes);
    }

    public DoubleMatrix2D permuteColumns(DoubleMatrix2D A, int[] indexes, int[] work) {
        return this.permuteRows(A.viewDice(), indexes, work);
    }

    public DoubleMatrix2D permuteRows(final DoubleMatrix2D A, int[] indexes, int[] work) {
        int size = A.rows();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int columns = A.columns();
        if (columns < size / 10) {
            double[] doubleWork = new double[size];
            int j = A.columns();
            while (--j >= 0) {
                this.permute(A.viewColumn(j), indexes, doubleWork);
            }
            return A;
        }
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                A.viewRow(a).swap(A.viewRow(b));
            }
        };
        GenericPermuting.permute(indexes, swapper, work, null);
        return A;
    }

    public DoubleMatrix2D pow(DoubleMatrix2D A, int p) {
        int i;
        SmpDoubleBlas blas = new SmpDoubleBlas();
        DoubleProperty.DEFAULT.checkSquare(A);
        if (p < 0) {
            A = this.inverse(A);
            p = -p;
        }
        if (p == 0) {
            return DoubleFactory2D.dense.identity(A.rows());
        }
        DoubleMatrix2D T = A.like();
        if (p == 1) {
            return T.assign(A);
        }
        if (p == 2) {
            blas.dgemm(false, false, 1.0, A, A, 0.0, T);
            return T;
        }
        int k = QuickBitVector.mostSignificantBit(p);
        for (i = 0; i <= k && (p & 1 << i) == 0; ++i) {
            blas.dgemm(false, false, 1.0, A, A, 0.0, T);
            DoubleMatrix2D swap = A;
            A = T;
            T = swap;
        }
        DoubleMatrix2D B = A.copy();
        ++i;
        while (i <= k) {
            blas.dgemm(false, false, 1.0, A, A, 0.0, T);
            DoubleMatrix2D swap = A;
            A = T;
            T = swap;
            if ((p & 1 << i) != 0) {
                blas.dgemm(false, false, 1.0, B, A, 0.0, T);
                swap = B;
                B = T;
                T = swap;
            }
            ++i;
        }
        return B;
    }

    public DoubleProperty property() {
        return this.property;
    }

    public DenseDoubleQRDecomposition qr(DoubleMatrix2D matrix) {
        return new DenseDoubleQRDecomposition(matrix);
    }

    public int rank(DoubleMatrix2D A) {
        return this.svd(A).rank();
    }

    public void setProperty(DoubleProperty property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public DoubleMatrix1D backwardSolve(DoubleMatrix2D U, DoubleMatrix1D b) {
        int rows = U.rows();
        DoubleMatrix1D x = b.like();
        x.setQuick(rows - 1, b.getQuick(rows - 1) / U.getQuick(rows - 1, rows - 1));
        for (int r = rows - 2; r >= 0; --r) {
            double sum = U.viewRow(r).zDotProduct(x);
            x.setQuick(r, (b.getQuick(r) - sum) / U.getQuick(r, r));
        }
        return x;
    }

    public DoubleMatrix1D forwardSolve(DoubleMatrix2D L, DoubleMatrix1D b) {
        int rows = L.rows();
        DoubleMatrix1D x = b.like();
        x.setQuick(0, b.getQuick(0) / L.getQuick(0, 0));
        for (int r = 1; r < rows; ++r) {
            double sum = L.viewRow(r).zDotProduct(x);
            x.setQuick(r, (b.getQuick(r) - sum) / L.getQuick(r, r));
        }
        return x;
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b) {
        if (A.rows() == A.columns()) {
            return this.lu(A).solve(b);
        }
        DoubleMatrix1D x = b.copy();
        this.qr(A).solve(x);
        return x.viewPart(0, A.columns()).copy();
    }

    public DoubleMatrix2D solve(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (A.rows() == A.columns()) {
            return this.lu(A).solve(B);
        }
        DoubleMatrix2D X = B.copy();
        this.qr(A).solve(X);
        return X.viewPart(0, 0, A.columns(), B.columns()).copy();
    }

    public DoubleMatrix2D solveTranspose(DoubleMatrix2D A, DoubleMatrix2D B) {
        return this.solve(this.transpose(A), this.transpose(B));
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D A, int[] rowIndexes, int columnFrom, int columnTo) {
        int width = columnTo - columnFrom + 1;
        int rows = A.rows();
        A = A.viewPart(0, columnFrom, rows, width);
        DoubleMatrix2D sub = A.like(rowIndexes.length, width);
        int r = rowIndexes.length;
        while (--r >= 0) {
            int row = rowIndexes[r];
            if (row < 0 || row >= rows) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            sub.viewRow(r).assign(A.viewRow(row));
        }
        return sub;
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D A, int rowFrom, int rowTo, int[] columnIndexes) {
        if (rowTo - rowFrom >= A.rows()) {
            throw new IndexOutOfBoundsException("Too many rows");
        }
        int height = rowTo - rowFrom + 1;
        int columns = A.columns();
        A = A.viewPart(rowFrom, 0, height, columns);
        DoubleMatrix2D sub = A.like(height, columnIndexes.length);
        int c = columnIndexes.length;
        while (--c >= 0) {
            int column = columnIndexes[c];
            if (column < 0 || column >= columns) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            sub.viewColumn(c).assign(A.viewColumn(column));
        }
        return sub;
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D A, int fromRow, int toRow, int fromColumn, int toColumn) {
        return A.viewPart(fromRow, fromColumn, toRow - fromRow + 1, toColumn - fromColumn + 1);
    }

    public DenseDoubleSingularValueDecomposition svd(DoubleMatrix2D matrix) {
        return new DenseDoubleSingularValueDecomposition(matrix, true, true);
    }

    public String toString(DoubleMatrix2D matrix) {
        final ObjectArrayList names = new ObjectArrayList();
        final ObjectArrayList values = new ObjectArrayList();
        String unknown = "Illegal operation or error: ";
        names.add("cond");
        try {
            values.add(String.valueOf(this.cond(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("det");
        try {
            values.add(String.valueOf(this.det(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("norm1");
        try {
            values.add(String.valueOf(this.norm1(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("norm2");
        try {
            values.add(String.valueOf(this.norm2(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("normF");
        try {
            values.add(String.valueOf(this.normF(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("normInfinity");
        try {
            values.add(String.valueOf(this.normInfinity(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("rank");
        try {
            values.add(String.valueOf(this.rank(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("trace");
        try {
            values.add(String.valueOf(this.trace(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return DoubleProperty.get(names, a).compareTo(DoubleProperty.get(names, b));
            }
        };
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object tmp = names.get(a);
                names.set(a, names.get(b));
                names.set(b, tmp);
                tmp = values.get(a);
                values.set(a, values.get(b));
                values.set(b, tmp);
            }
        };
        GenericSorting.quickSort(0, names.size(), comp, swapper);
        int maxLength = 0;
        for (int i = 0; i < names.size(); ++i) {
            int length = ((String)names.get(i)).length();
            maxLength = Math.max(length, maxLength);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            buf.append(name);
            buf.append(DoubleProperty.blanks(maxLength - name.length()));
            buf.append(" : ");
            buf.append(values.get(i));
            if (i >= names.size() - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public String toVerboseString(DoubleMatrix2D matrix) {
        String constructionException = "Illegal operation or error upon construction of ";
        StringBuffer buf = new StringBuffer();
        buf.append("A = ");
        buf.append(matrix);
        buf.append("\n\n" + this.toString(matrix));
        buf.append("\n\n" + DoubleProperty.DEFAULT.toString(matrix));
        DenseDoubleLUDecomposition lu = null;
        try {
            lu = new DenseDoubleLUDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " LUDecomposition: " + exc.getMessage());
        }
        if (lu != null) {
            buf.append("\n\n" + lu.toString());
        }
        DenseDoubleQRDecomposition qr = null;
        try {
            qr = new DenseDoubleQRDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " QRDecomposition: " + exc.getMessage());
        }
        if (qr != null) {
            buf.append("\n\n" + qr.toString());
        }
        DenseDoubleCholeskyDecomposition chol = null;
        try {
            chol = new DenseDoubleCholeskyDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " CholeskyDecomposition: " + exc.getMessage());
        }
        if (chol != null) {
            buf.append("\n\n" + chol.toString());
        }
        DenseDoubleEigenvalueDecomposition eig = null;
        try {
            eig = new DenseDoubleEigenvalueDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " EigenvalueDecomposition: " + exc.getMessage());
        }
        if (eig != null) {
            buf.append("\n\n" + eig.toString());
        }
        DenseDoubleSingularValueDecomposition svd = null;
        try {
            svd = new DenseDoubleSingularValueDecomposition(matrix, true, true);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " SingularValueDecomposition: " + exc.getMessage());
        }
        if (svd != null) {
            buf.append("\n\n" + svd.toString());
        }
        return buf.toString();
    }

    public double trace(DoubleMatrix2D A) {
        double sum = 0.0;
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            sum += A.getQuick(i, i);
        }
        return sum;
    }

    public DoubleMatrix2D transpose(DoubleMatrix2D A) {
        return A.viewDice();
    }

    public DoubleMatrix2D trapezoidalLower(DoubleMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int r = rows;
        while (--r >= 0) {
            int c = columns;
            while (--c >= 0) {
                if (r >= c) continue;
                A.setQuick(r, c, 0.0);
            }
        }
        return A;
    }

    public DoubleMatrix2D xmultOuter(DoubleMatrix1D x, DoubleMatrix1D y) {
        DoubleMatrix2D A = x.like2D((int)x.size(), (int)y.size());
        this.multOuter(x, y, A);
        return A;
    }

    public DoubleMatrix2D xpowSlow(DoubleMatrix2D A, int k) {
        DoubleMatrix2D result = A.copy();
        for (int i = 0; i < k - 1; ++i) {
            result = this.mult(result, A);
        }
        return result;
    }

    static {
        DenseDoubleAlgebra.DEFAULT.property = DoubleProperty.DEFAULT;
        ZERO = new DenseDoubleAlgebra();
        DenseDoubleAlgebra.ZERO.property = DoubleProperty.ZERO;
    }
}

