/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class DoubleMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected DoubleMatrix1D() {
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix1D.this.getQuick(firstIdx));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(DoubleMatrix1D.this.getQuick(i)));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.getQuick(i)));
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix1D.this.getQuick(indexElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            double elem = DoubleMatrix1D.this.getQuick(indexElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(indexElements[0]));
            for (int i = 1; i < size; ++i) {
                double elem = this.getQuick(indexElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public double aggregate(final DoubleMatrix1D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        this.checkSize(other);
        if (this.size == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(0), other.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix1D.this.getQuick(firstIdx), other.getQuick(firstIdx));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(DoubleMatrix1D.this.getQuick(i), other.getQuick(i)));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
            }
        }
        return a;
    }

    public DoubleMatrix1D assign(final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DoubleMatrix1D.this.setQuick(i, f.apply(DoubleMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, f.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure cond, final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double elem = DoubleMatrix1D.this.getQuick(i);
                            if (!cond.apply(elem)) continue;
                            DoubleMatrix1D.this.setQuick(i, f.apply(elem));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double elem = this.getQuick(i);
                if (!cond.apply(elem)) continue;
                this.setQuick(i, f.apply(elem));
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure cond, final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double elem = DoubleMatrix1D.this.getQuick(i);
                            if (!cond.apply(elem)) continue;
                            DoubleMatrix1D.this.setQuick(i, value);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double elem = this.getQuick(i);
                if (!cond.apply(elem)) continue;
                this.setQuick(i, value);
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DoubleMatrix1D.this.setQuick(i, value);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, value);
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DoubleMatrix1D.this.setQuick(i, values[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, values[i]);
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        final DoubleMatrix1D source = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DoubleMatrix1D.this.setQuick(i, source.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, source.getQuick(i));
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleMatrix1D y, final DoubleDoubleFunction function) {
        this.checkSize(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DoubleMatrix1D.this.setQuick(i, function.apply(DoubleMatrix1D.this.getQuick(i), y.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, function.apply(this.getQuick(i), y.getQuick(i)));
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D y, DoubleDoubleFunction function, IntArrayList nonZeroIndexes) {
        this.checkSize(y);
        int[] nonZeroElements = nonZeroIndexes.elements();
        if (function == DoubleFunctions.mult) {
            int j = 0;
            int index = nonZeroIndexes.size();
            while (--index >= 0) {
                int i = nonZeroElements[index];
                while (j < i) {
                    this.setQuick(j, 0.0);
                    ++j;
                }
                this.setQuick(i, this.getQuick(i) * y.getQuick(i));
                ++j;
            }
        } else if (function instanceof DoublePlusMultSecond) {
            double multiplicator = ((DoublePlusMultSecond)function).multiplicator;
            if (multiplicator == 0.0) {
                return this;
            }
            if (multiplicator == 1.0) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + y.getQuick(i));
                }
            } else if (multiplicator == -1.0) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) - y.getQuick(i));
                }
            } else {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + multiplicator * y.getQuick(i));
                }
            }
        } else {
            return this.assign(y, function);
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (DoubleMatrix1D.this.getQuick(i) == 0.0) continue;
                            ++cardinality;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.getQuick(i) == 0.0) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public DoubleMatrix1D copy() {
        DoubleMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public abstract Object elements();

    public boolean equals(double value) {
        return DoubleProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleMatrix1D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DoubleMatrix1D)obj);
    }

    public double get(int index) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    public double[] getMaxLocation() {
        int location = 0;
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int location = firstIdx;
                        double maxValue = DoubleMatrix1D.this.getQuick(location);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            double elem = DoubleMatrix1D.this.getQuick(i);
                            if (!(maxValue < elem)) continue;
                            maxValue = elem;
                            location = i;
                        }
                        return new double[]{maxValue, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (!(maxValue < results[j][0])) continue;
                    maxValue = results[j][0];
                    location = (int)results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                double elem = this.getQuick(i);
                if (maxValue < elem) {
                    maxValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new double[]{maxValue, location};
    }

    public double[] getMinLocation() {
        int location = 0;
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int location = firstIdx;
                        double minValue = DoubleMatrix1D.this.getQuick(location);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            double elem = DoubleMatrix1D.this.getQuick(i);
                            if (!(minValue > elem)) continue;
                            minValue = elem;
                            location = i;
                        }
                        return new double[]{minValue, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (!(minValue > results[j][0])) continue;
                    minValue = results[j][0];
                    location = (int)results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                double elem = this.getQuick(i);
                if (minValue > elem) {
                    minValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new double[]{minValue, location};
    }

    public void getNegativeValues(IntArrayList indexList, DoubleArrayList valueList) {
        double value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) < 0.0) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        for (int i = rem; i < this.size; i += 2) {
            double value2 = this.getQuick(i);
            if (value2 < 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if (!((value2 = this.getQuick(i + 1)) < 0.0)) continue;
            if (fillIndexList) {
                indexList.add(i + 1);
            }
            if (!fillValueList) continue;
            valueList.add(value2);
        }
    }

    public void getNonZeros(IntArrayList indexList, DoubleArrayList valueList) {
        double value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) != 0.0) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        for (int i = rem; i < this.size; i += 2) {
            double value2 = this.getQuick(i);
            if (value2 != 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if ((value2 = this.getQuick(i + 1)) == 0.0) continue;
            if (fillIndexList) {
                indexList.add(i + 1);
            }
            if (!fillValueList) continue;
            valueList.add(value2);
        }
    }

    public void getNonZeros(IntArrayList indexList, DoubleArrayList valueList, int maxCardinality) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int s = this.size;
        int currentSize = 0;
        for (int i = 0; i < s; ++i) {
            double value = this.getQuick(i);
            if (value != 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
                ++currentSize;
            }
            if (currentSize >= maxCardinality) break;
        }
    }

    public void getPositiveValues(IntArrayList indexList, DoubleArrayList valueList) {
        double value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) > 0.0) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        for (int i = rem; i < this.size; i += 2) {
            double value2 = this.getQuick(i);
            if (value2 > 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if (!((value2 = this.getQuick(i + 1)) > 0.0)) continue;
            if (fillIndexList) {
                indexList.add(i + 1);
            }
            if (!fillValueList) continue;
            valueList.add(value2);
        }
    }

    public abstract double getQuick(int var1);

    public DoubleMatrix1D like() {
        return this.like(this.size);
    }

    public abstract DoubleMatrix1D like(int var1);

    public abstract DoubleMatrix2D like2D(int var1, int var2);

    public void normalize() {
        double min = this.getMinLocation()[0];
        if (min < 0.0) {
            this.assign(DoubleFunctions.minus(min));
        }
        if (this.getMaxLocation()[0] == 0.0) {
            this.assign(1.0 / (double)this.size());
        } else {
            double sumScaleFactor = this.zSum();
            sumScaleFactor = 1.0 / sumScaleFactor;
            this.assign(DoubleFunctions.mult(sumScaleFactor));
        }
    }

    public abstract DoubleMatrix2D reshape(int var1, int var2);

    public abstract DoubleMatrix3D reshape(int var1, int var2, int var3);

    public void set(int index, double value) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, double var2);

    public void swap(final DoubleMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double tmp = DoubleMatrix1D.this.getQuick(i);
                            DoubleMatrix1D.this.setQuick(i, other.getQuick(i));
                            other.setQuick(i, tmp);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double tmp = this.getQuick(i);
                this.setQuick(i, other.getQuick(i));
                other.setQuick(i, tmp);
            }
        }
    }

    public double[] toArray() {
        double[] values = new double[this.size];
        this.toArray(values);
        return values;
    }

    public void toArray(final double[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values[i] = DoubleMatrix1D.this.getQuick(i);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                values[i] = this.getQuick(i);
            }
        }
    }

    public String toString() {
        return new DoubleFormatter().toString(this);
    }

    public DoubleMatrix1D viewFlip() {
        return (DoubleMatrix1D)this.view().vFlip();
    }

    public DoubleMatrix1D viewPart(int index, int width) {
        return (DoubleMatrix1D)this.view().vPart(index, width);
    }

    public DoubleMatrix1D viewSelection(DoubleProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!condition.apply(this.getQuick(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    public DoubleMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            offsets[i] = (int)this.index(indexes[i]);
        }
        return this.viewSelectionLike(offsets);
    }

    public DoubleMatrix1D viewSorted() {
        return DoubleSorting.mergeSort.sort(this);
    }

    public DoubleMatrix1D viewStrides(int stride) {
        return (DoubleMatrix1D)this.view().vStrides(stride);
    }

    public double zDotProduct(DoubleMatrix1D y) {
        return this.zDotProduct(y, 0, this.size);
    }

    public double zDotProduct(final DoubleMatrix1D y, final int from, int length) {
        if (from < 0 || length <= 0) {
            return 0.0;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        length = tail - from;
        double sum = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Double[] results = new Double[nthreads];
            int k = length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sum = 0.0;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            int idx = k + from;
                            sum += DoubleMatrix1D.this.getQuick(idx) * y.getQuick(idx);
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Double)futures[j].get();
                }
                sum = results[0];
                for (j = 1; j < nthreads; ++j) {
                    sum += results[j].doubleValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = tail - 1;
            int k = length;
            while (--k >= 0) {
                sum += this.getQuick(i) * y.getQuick(i);
                --i;
            }
        }
        return sum;
    }

    public double zDotProduct(DoubleMatrix1D y, int from, int length, IntArrayList nonZeroIndexes) {
        int i;
        int index;
        if (from < 0 || length <= 0) {
            return 0.0;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        if ((length = tail - from) <= 0) {
            return 0.0;
        }
        IntArrayList indexesCopy = nonZeroIndexes.copy();
        indexesCopy.trimToSize();
        indexesCopy.quickSort();
        int[] nonZeroIndexElements = indexesCopy.elements();
        int s = indexesCopy.size();
        for (index = 0; index < s && nonZeroIndexElements[index] < from; ++index) {
        }
        double sum = 0.0;
        while (--length >= 0 && index < s && (i = nonZeroIndexElements[index]) < tail) {
            sum += this.getQuick(i) * y.getQuick(i);
            ++index;
        }
        return sum;
    }

    public double zSum() {
        if (this.size() == 0L) {
            return 0.0;
        }
        return this.aggregate(DoubleFunctions.plus, DoubleFunctions.identity);
    }

    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (this.getQuick(i) == 0.0) continue;
            ++cardinality;
        }
        return cardinality;
    }

    protected DoubleMatrix1D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DoubleMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        return false;
    }

    protected DoubleMatrix1D view() {
        return (DoubleMatrix1D)this.clone();
    }

    protected abstract DoubleMatrix1D viewSelectionLike(int[] var1);

    protected double zDotProduct(DoubleMatrix1D y, IntArrayList nonZeroIndexes) {
        return this.zDotProduct(y, 0, this.size, nonZeroIndexes);
    }
}

