/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseCCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import cern.jet.math.tdcomplex.DComplexPlusMultFirst;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;
import edu.emory.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected double[] values;

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    public SparseRCDComplexMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseRCDComplexMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseRCDComplexMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.columnIndexes = new int[nzmax];
        this.values = new double[2 * nzmax];
        this.rowPointers = new int[rows + 1];
    }

    public SparseRCDComplexMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double re, double im, boolean removeDuplicates) {
        int k;
        block7: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block7;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (re == 0.0 && im == 0.0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new double[2 * nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.rowPointers, w, rows);
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[2 * r] = re;
            this.values[2 * r + 1] = im;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
    }

    public SparseRCDComplexMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double[] values, boolean removeDuplicates, boolean removeZeroes) {
        int k;
        block8: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (2 * rowIndexes.length != values.length) {
            throw new IllegalArgumentException("2 * rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new double[2 * nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.rowPointers, w, rows);
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[2 * r] = values[2 * k];
            this.values[2 * r + 1] = values[2 * k + 1];
        }
        if (removeZeroes) {
            this.removeZeroes();
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
    }

    public SparseRCDComplexMatrix2D(int rows, int columns, int[] rowPointers, int[] columnIndexes, double[] values) {
        block4: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block4;
                throw exc;
            }
        }
        if (rowPointers.length != rows + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        if (2 * columnIndexes.length != values.length) {
            throw new IllegalArgumentException("2 * columnIndexes.length != values.length");
        }
        this.rowPointers = rowPointers;
        this.columnIndexes = columnIndexes;
        this.values = values;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexDComplexFunction function) {
        if (function instanceof DComplexMult) {
            double[] alpha = ((DComplexMult)function).multiplicator;
            if (alpha[0] == 1.0 && alpha[1] == 0.0) {
                return this;
            }
            if (alpha[0] == 0.0 && alpha[1] == 0.0) {
                return this.assign(alpha);
            }
            if (alpha[0] != alpha[0] || alpha[1] != alpha[1]) {
                return this.assign(alpha);
            }
            int nz = this.cardinality();
            double[] elem = new double[2];
            for (int j = 0; j < nz; ++j) {
                elem[0] = this.values[2 * j];
                elem[1] = this.values[2 * j + 1];
                elem = DComplex.mult(elem, alpha);
                this.values[2 * j] = elem[0];
                this.values[2 * j + 1] = elem[1];
            }
        } else {
            this.forEachNonZero(new IntIntDComplexFunction(){

                @Override
                public double[] apply(int i, int j, double[] value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(double re, double im) {
        if (re == 0.0 && im == 0.0) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0.0);
        } else {
            int nnz = this.cardinality();
            for (int i = 0; i < nnz; ++i) {
                this.values[2 * i] = re;
                this.values[2 * i + 1] = im;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseRCDComplexMatrix2D) {
            SparseRCDComplexMatrix2D other = (SparseRCDComplexMatrix2D)source;
            System.arraycopy(other.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int nzmax = other.columnIndexes.length;
            if (this.columnIndexes.length < nzmax) {
                this.columnIndexes = new int[nzmax];
                this.values = new double[2 * nzmax];
            }
            System.arraycopy(other.columnIndexes, 0, this.columnIndexes, 0, nzmax);
            System.arraycopy(other.values, 0, this.values, 0, other.values.length);
        } else if (source instanceof SparseCCDComplexMatrix2D) {
            SparseCCDComplexMatrix2D other = ((SparseCCDComplexMatrix2D)source).getConjugateTranspose();
            this.rowPointers = other.getColumnPointers();
            this.columnIndexes = other.getRowIndexes();
            this.values = other.getValues();
        } else {
            this.assign(0.0, 0.0);
            source.forEachNonZero(new IntIntDComplexFunction(){

                @Override
                public double[] apply(int i, int j, double[] value) {
                    SparseRCDComplexMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D y, DComplexDComplexDComplexFunction function) {
        double[] elem;
        double[] alpha;
        this.checkShape(y);
        if (y instanceof SparseRCDComplexMatrix2D && function == DComplexFunctions.plus) {
            SparseRCDComplexMatrix2D yy = (SparseRCDComplexMatrix2D)y;
            int[] rowPointersY = yy.rowPointers;
            int[] columnIndexesY = yy.columnIndexes;
            double[] valuesY = yy.values;
            int[] rowPointersC = new int[this.rows + 1];
            int cnz = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)rowPointersY[this.rows]));
            int[] columnIndexesC = new int[cnz];
            double[] valuesC = new double[2 * cnz];
            int nrow = this.rows;
            int ncol = this.columns;
            int nzmax = cnz;
            if (function == DComplexFunctions.plus) {
                int kc;
                rowPointersC[0] = kc = 0;
                for (int i = 0; i < nrow; ++i) {
                    int ka = this.rowPointers[i];
                    int kb = rowPointersY[i];
                    int kamax = this.rowPointers[i + 1] - 1;
                    int kbmax = rowPointersY[i + 1] - 1;
                    while (ka <= kamax || kb <= kbmax) {
                        int j2;
                        int j1 = ka <= kamax ? this.columnIndexes[ka] : ncol + 1;
                        if (j1 == (j2 = kb <= kbmax ? columnIndexesY[kb] : ncol + 1)) {
                            valuesC[2 * kc] = this.values[2 * ka] + valuesY[2 * kb];
                            valuesC[2 * kc + 1] = this.values[2 * ka + 1] + valuesY[2 * kb + 1];
                            columnIndexesC[kc] = j1;
                            ++ka;
                            ++kb;
                            ++kc;
                        } else if (j1 < j2) {
                            columnIndexesC[kc] = j1;
                            valuesC[2 * kc] = this.values[2 * ka];
                            valuesC[2 * kc + 1] = this.values[2 * ka + 1];
                            ++ka;
                            ++kc;
                        } else if (j1 > j2) {
                            columnIndexesC[kc] = j2;
                            valuesC[2 * kc] = valuesY[2 * kb];
                            valuesC[2 * kc + 1] = valuesY[2 * kb + 1];
                            ++kb;
                            ++kc;
                        }
                        if (kc < nzmax) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    rowPointersC[i + 1] = kc;
                }
                this.rowPointers = rowPointersC;
                this.columnIndexes = columnIndexesC;
                this.values = valuesC;
                return this;
            }
        }
        if (function instanceof DComplexPlusMultSecond) {
            alpha = ((DComplexPlusMultSecond)function).multiplicator;
            if (alpha[0] == 0.0 && alpha[1] == 0.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDComplexFunction(){

                @Override
                public double[] apply(int i, int j, double[] value) {
                    SparseRCDComplexMatrix2D.this.setQuick(i, j, DComplex.plus(SparseRCDComplexMatrix2D.this.getQuick(i, j), DComplex.mult(alpha, value)));
                    return value;
                }
            });
            return this;
        }
        if (function instanceof DComplexPlusMultFirst) {
            alpha = ((DComplexPlusMultFirst)function).multiplicator;
            if (alpha[0] == 0.0 && alpha[1] == 0.0) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntDComplexFunction(){

                @Override
                public double[] apply(int i, int j, double[] value) {
                    SparseRCDComplexMatrix2D.this.setQuick(i, j, DComplex.plus(DComplex.mult(alpha, SparseRCDComplexMatrix2D.this.getQuick(i, j)), value));
                    return value;
                }
            });
            return this;
        }
        if (function == DComplexFunctions.mult) {
            elem = new double[2];
            for (int i = 0; i < this.rows; ++i) {
                int high = this.rowPointers[i + 1];
                for (int k = this.rowPointers[i]; k < high; ++k) {
                    int j = this.columnIndexes[k];
                    elem[0] = this.values[2 * k];
                    elem[1] = this.values[2 * k + 1];
                    elem = DComplex.mult(elem, y.getQuick(i, j));
                    this.values[2 * k] = elem[0];
                    this.values[2 * k + 1] = elem[1];
                    if (this.values[2 * k] != 0.0 || this.values[2 * k + 1] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == DComplexFunctions.div) {
            elem = new double[2];
            for (int i = 0; i < this.rows; ++i) {
                int high = this.rowPointers[i + 1];
                for (int k = this.rowPointers[i]; k < high; ++k) {
                    int j = this.columnIndexes[k];
                    elem[0] = this.values[2 * k];
                    elem[1] = this.values[2 * k + 1];
                    elem = DComplex.div(elem, y.getQuick(i, j));
                    this.values[2 * k] = elem[0];
                    this.values[2 * k + 1] = elem[1];
                    if (this.values[2 * k] != 0.0 || this.values[2 * k + 1] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    @Override
    public DComplexMatrix2D forEachNonZero(IntIntDComplexFunction function) {
        double[] value = new double[2];
        for (int i = 0; i < this.rows; ++i) {
            int high = this.rowPointers[i + 1];
            for (int k = this.rowPointers[i]; k < high; ++k) {
                int j = this.columnIndexes[k];
                value[0] = this.values[2 * k];
                value[1] = this.values[2 * k + 1];
                double[] r = function.apply(i, j, value);
                if (r[0] == value[0] && r[1] == value[1]) continue;
                this.values[2 * k] = r[0];
                this.values[2 * k + 1] = r[1];
            }
        }
        return this;
    }

    public SparseCCDComplexMatrix2D getColumnCompressed() {
        SparseRCDComplexMatrix2D tr = this.getConjugateTranspose();
        SparseCCDComplexMatrix2D cc = new SparseCCDComplexMatrix2D(this.rows, this.columns);
        cc.rowIndexes = tr.columnIndexes;
        cc.columnPointers = tr.rowPointers;
        cc.values = tr.values;
        return cc;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseDComplexMatrix2D getDense() {
        final DenseDComplexMatrix2D dense = new DenseDComplexMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDComplexFunction(){

            @Override
            public double[] apply(int i, int j, double[] value) {
                dense.setQuick(i, j, SparseRCDComplexMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    @Override
    public synchronized double[] getQuick(int row, int column) {
        int k = SparseRCDComplexMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        double[] v = new double[2];
        if (k >= 0) {
            v[0] = this.values[2 * k];
            v[1] = this.values[2 * k + 1];
        }
        return v;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    @Override
    public SparseRCDComplexMatrix2D getConjugateTranspose() {
        int nnz = this.rowPointers[this.rows];
        int[] w = new int[this.columns];
        int[] rowPointersT = new int[this.columns + 1];
        int[] columnIndexesT = new int[nnz];
        double[] valuesT = new double[2 * nnz];
        for (int p = 0; p < nnz; ++p) {
            int n = this.columnIndexes[p];
            w[n] = w[n] + 1;
        }
        this.cumsum(rowPointersT, w, this.columns);
        for (int j = 0; j < this.rows; ++j) {
            int high = this.rowPointers[j + 1];
            for (int p = this.rowPointers[j]; p < high; ++p) {
                int n = this.columnIndexes[p];
                w[n] = w[n] + 1;
                columnIndexesT[q] = j;
                valuesT[2 * q] = this.values[2 * p];
                valuesT[2 * q + 1] = -this.values[2 * p + 1];
            }
        }
        SparseRCDComplexMatrix2D T = new SparseRCDComplexMatrix2D(this.columns, this.rows);
        T.rowPointers = rowPointersT;
        T.columnIndexes = columnIndexesT;
        T.values = valuesT;
        return T;
    }

    public double[] getValues() {
        return this.values;
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new SparseRCDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        return new SparseDComplexMatrix1D(size);
    }

    public void removeDuplicates() {
        int i;
        int nz = 0;
        int[] w = new int[this.columns];
        for (i = 0; i < this.columns; ++i) {
            w[i] = -1;
        }
        for (int j = 0; j < this.rows; ++j) {
            int q = nz;
            for (int p = this.rowPointers[j]; p < this.rowPointers[j + 1]; ++p) {
                i = this.columnIndexes[p];
                if (w[i] >= q) {
                    int n = 2 * w[i];
                    this.values[n] = this.values[n] + this.values[2 * p];
                    int n2 = 2 * w[i] + 1;
                    this.values[n2] = this.values[n2] + this.values[2 * p + 1];
                    continue;
                }
                w[i] = nz;
                this.columnIndexes[nz] = i;
                this.values[2 * nz] = this.values[2 * p];
                this.values[2 * nz + 1] = this.values[2 * p + 1];
                ++nz;
            }
            this.rowPointers[j] = q;
        }
        this.rowPointers[this.rows] = nz;
    }

    public void removeZeroes() {
        int nz = 0;
        double eps = Math.pow(2.0, -52.0);
        double[] elem = new double[2];
        for (int j = 0; j < this.rows; ++j) {
            this.rowPointers[j] = nz;
            for (int p = this.rowPointers[j]; p < this.rowPointers[j + 1]; ++p) {
                elem[0] = this.values[2 * p];
                elem[1] = this.values[2 * p + 1];
                if (!(DComplex.abs(elem) > eps)) continue;
                this.values[2 * nz] = this.values[2 * p];
                this.values[2 * nz + 1] = this.values[2 * p + 1];
                this.columnIndexes[nz++] = this.columnIndexes[p];
            }
        }
        this.rowPointers[this.rows] = nz;
    }

    @Override
    public synchronized void setQuick(int row, int column, double[] value) {
        int k = SparseRCDComplexMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        if (k >= 0) {
            if (value[0] == 0.0 && value[1] == 0.0) {
                this.remove(row, k);
            } else {
                this.values[2 * k] = value[0];
                this.values[2 * k + 1] = value[1];
            }
            return;
        }
        if (value[0] != 0.0 || value[1] != 0.0) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    @Override
    public synchronized void setQuick(int row, int column, double re, double im) {
        int k = SparseRCDComplexMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        if (k >= 0) {
            if (re == 0.0 && im == 0.0) {
                this.remove(row, k);
            } else {
                this.values[2 * k] = re;
                this.values[2 * k + 1] = im;
            }
            return;
        }
        if (re != 0.0 || im != 0.0) {
            k = -k - 1;
            this.insert(row, column, k, re, im);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int high = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < high; ++j) {
                if (this.values[2 * j + 1] > 0.0) {
                    builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('+').append(this.values[2 * j + 1]).append('i').append('\n');
                    continue;
                }
                if (this.values[2 * j + 1] == 0.0) {
                    builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('\n');
                    continue;
                }
                builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('-').append(this.values[2 * j + 1]).append('i').append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.realloc(0);
    }

    @Override
    public DComplexMatrix1D zMult(DComplexMatrix1D y, DComplexMatrix1D z, final double[] alpha, final double[] beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || !transposeA;
        if (z == null) {
            z = new DenseDComplexMatrix1D(rowsA);
        }
        if (!(y instanceof DenseDComplexMatrix1D) || !(z instanceof DenseDComplexMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseDComplexMatrix1D zz = (DenseDComplexMatrix1D)z;
        final double[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseDComplexMatrix1D yy = (DenseDComplexMatrix1D)y;
        final double[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (transposeA) {
            if (!(ignore || beta[0] == 1.0 && beta[1] == 0.0)) {
                z.assign(DComplexFunctions.mult(beta));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int j;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final double[] result = new double[2 * rowsA];
                int k = this.rows / nthreads;
                for (j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    final int threadID = j;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] yElem = new double[2];
                            double[] val = new double[2];
                            if (threadID == 0) {
                                for (int i = firstRow; i < lastRow; ++i) {
                                    int high = SparseRCDComplexMatrix2D.this.rowPointers[i + 1];
                                    yElem[0] = elementsY[zeroY + strideY * i];
                                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                                    yElem = DComplex.mult(alpha, yElem);
                                    for (int k = SparseRCDComplexMatrix2D.this.rowPointers[i]; k < high; ++k) {
                                        int j = SparseRCDComplexMatrix2D.this.columnIndexes[k];
                                        val[0] = SparseRCDComplexMatrix2D.this.values[2 * k];
                                        val[1] = -SparseRCDComplexMatrix2D.this.values[2 * k + 1];
                                        val = DComplex.mult(val, yElem);
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + val[0];
                                        int n2 = zeroZ + strideZ * j + 1;
                                        elementsZ[n2] = elementsZ[n2] + val[1];
                                    }
                                }
                            } else {
                                for (int i = firstRow; i < lastRow; ++i) {
                                    int high = SparseRCDComplexMatrix2D.this.rowPointers[i + 1];
                                    yElem[0] = elementsY[zeroY + strideY * i];
                                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                                    yElem = DComplex.mult(alpha, yElem);
                                    for (int k = SparseRCDComplexMatrix2D.this.rowPointers[i]; k < high; ++k) {
                                        int j = SparseRCDComplexMatrix2D.this.columnIndexes[k];
                                        val[0] = SparseRCDComplexMatrix2D.this.values[2 * k];
                                        val[1] = -SparseRCDComplexMatrix2D.this.values[2 * k + 1];
                                        val = DComplex.mult(val, yElem);
                                        int n = 2 * j;
                                        result[n] = result[n] + val[0];
                                        int n3 = 2 * j + 1;
                                        result[n3] = result[n3] + val[1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (j = 0; j < rowsA; ++j) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[2 * j];
                    int n2 = zeroZ + j * strideZ + 1;
                    elementsZ[n2] = elementsZ[n2] + result[2 * j + 1];
                }
            } else {
                double[] yElem = new double[2];
                double[] val = new double[2];
                for (int i = 0; i < this.rows; ++i) {
                    int high = this.rowPointers[i + 1];
                    yElem[0] = elementsY[zeroY + strideY * i];
                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                    yElem = DComplex.mult(alpha, yElem);
                    for (int k = this.rowPointers[i]; k < high; ++k) {
                        int j = this.columnIndexes[k];
                        val[0] = this.values[2 * k];
                        val[1] = -this.values[2 * k + 1];
                        val = DComplex.mult(val, yElem);
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + val[0];
                        int n3 = zeroZ + strideZ * j + 1;
                        elementsZ[n3] = elementsZ[n3] + val[1];
                    }
                }
            }
            return z;
        }
        if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int zidx = zeroZ + firstRow * strideZ;
                        double[] yElem = new double[2];
                        double[] val = new double[2];
                        if (beta[0] == 0.0 && beta[1] == 0.0) {
                            for (int i = firstRow; i < lastRow; ++i) {
                                double[] sum = new double[2];
                                int high = SparseRCDComplexMatrix2D.this.rowPointers[i + 1];
                                for (int k = SparseRCDComplexMatrix2D.this.rowPointers[i]; k < high; ++k) {
                                    yElem[0] = elementsY[zeroY + strideY * SparseRCDComplexMatrix2D.this.columnIndexes[k]];
                                    yElem[1] = elementsY[zeroY + strideY * SparseRCDComplexMatrix2D.this.columnIndexes[k] + 1];
                                    val[0] = SparseRCDComplexMatrix2D.this.values[2 * k];
                                    val[1] = SparseRCDComplexMatrix2D.this.values[2 * k + 1];
                                    sum = DComplex.plus(sum, DComplex.mult(val, yElem));
                                }
                                sum = DComplex.mult(alpha, sum);
                                elementsZ[zidx] = sum[0];
                                elementsZ[zidx + 1] = sum[1];
                                zidx += strideZ;
                            }
                        } else {
                            double[] zElem = new double[2];
                            for (int i = firstRow; i < lastRow; ++i) {
                                double[] sum = new double[2];
                                int high = SparseRCDComplexMatrix2D.this.rowPointers[i + 1];
                                for (int k = SparseRCDComplexMatrix2D.this.rowPointers[i]; k < high; ++k) {
                                    yElem[0] = elementsY[zeroY + strideY * SparseRCDComplexMatrix2D.this.columnIndexes[k]];
                                    yElem[1] = elementsY[zeroY + strideY * SparseRCDComplexMatrix2D.this.columnIndexes[k] + 1];
                                    val[0] = SparseRCDComplexMatrix2D.this.values[2 * k];
                                    val[1] = SparseRCDComplexMatrix2D.this.values[2 * k + 1];
                                    sum = DComplex.plus(sum, DComplex.mult(val, yElem));
                                }
                                sum = DComplex.mult(alpha, sum);
                                zElem[0] = elementsZ[zidx];
                                zElem[1] = elementsZ[zidx + 1];
                                zElem = DComplex.mult(beta, zElem);
                                elementsZ[zidx] = sum[0] + zElem[0];
                                elementsZ[zidx + 1] = sum[1] + zElem[1];
                                zidx += strideZ;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int zidx = zeroZ;
            double[] yElem = new double[2];
            double[] val = new double[2];
            if (beta[0] == 0.0 && beta[1] == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    double[] sum = new double[2];
                    int high = this.rowPointers[i + 1];
                    for (int k = this.rowPointers[i]; k < high; ++k) {
                        yElem[0] = elementsY[zeroY + strideY * this.columnIndexes[k]];
                        yElem[1] = elementsY[zeroY + strideY * this.columnIndexes[k] + 1];
                        val[0] = this.values[2 * k];
                        val[1] = this.values[2 * k + 1];
                        sum = DComplex.plus(sum, DComplex.mult(val, yElem));
                    }
                    sum = DComplex.mult(alpha, sum);
                    elementsZ[zidx] = sum[0];
                    elementsZ[zidx + 1] = sum[1];
                    zidx += strideZ;
                }
            } else {
                double[] zElem = new double[2];
                for (int i = 0; i < this.rows; ++i) {
                    double[] sum = new double[2];
                    int high = this.rowPointers[i + 1];
                    for (int k = this.rowPointers[i]; k < high; ++k) {
                        yElem[0] = elementsY[zeroY + strideY * this.columnIndexes[k]];
                        yElem[1] = elementsY[zeroY + strideY * this.columnIndexes[k] + 1];
                        val[0] = this.values[2 * k];
                        val[1] = this.values[2 * k + 1];
                        sum = DComplex.plus(sum, DComplex.mult(val, yElem));
                    }
                    sum = DComplex.mult(alpha, sum);
                    zElem[0] = elementsZ[zidx];
                    zElem[1] = elementsZ[zidx + 1];
                    zElem = DComplex.mult(beta, zElem);
                    elementsZ[zidx] = sum[0] + zElem[0];
                    elementsZ[zidx + 1] = sum[1] + zElem[1];
                    zidx += strideZ;
                }
            }
        }
        return z;
    }

    @Override
    public DComplexMatrix2D zMult(DComplexMatrix2D B, DComplexMatrix2D C, double[] alpha, double[] beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseRCDComplexMatrix2D ? new SparseRCDComplexMatrix2D(rowsA, p, rowsA * p) : new DenseDComplexMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(ignore || beta[0] == 1.0 && beta[1] == 0.0)) {
            C.assign(DComplexFunctions.mult(beta));
        }
        if (B instanceof DenseDComplexMatrix2D && C instanceof DenseDComplexMatrix2D) {
            SparseRCDComplexMatrix2D AA = transposeA ? this.getConjugateTranspose() : this;
            DenseDComplexMatrix2D BB = transposeB ? (DenseDComplexMatrix2D)B.getConjugateTranspose() : (DenseDComplexMatrix2D)B;
            DenseDComplexMatrix2D CC = (DenseDComplexMatrix2D)C;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            double[] valuesA = AA.values;
            double[] valA = new double[2];
            for (int ii = 0; ii < rowsA; ++ii) {
                int highA = rowPointersA[ii + 1];
                for (int ka = rowPointersA[ii]; ka < highA; ++ka) {
                    valA[0] = valuesA[2 * ka];
                    valA[1] = valuesA[2 * ka + 1];
                    double[] scal = DComplex.mult(alpha, valA);
                    int jj = columnIndexesA[ka];
                    CC.viewRow(ii).assign(BB.viewRow(jj), DComplexFunctions.plusMultSecond(scal));
                }
            }
        } else if (B instanceof SparseRCDComplexMatrix2D && C instanceof SparseRCDComplexMatrix2D) {
            SparseRCDComplexMatrix2D CC = (SparseRCDComplexMatrix2D)C;
            SparseRCDComplexMatrix2D AA = transposeA ? this.getConjugateTranspose() : this;
            SparseRCDComplexMatrix2D BB = transposeB ? ((SparseRCDComplexMatrix2D)B).getConjugateTranspose() : (SparseRCDComplexMatrix2D)B;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            double[] valuesA = AA.values;
            int[] rowPointersB = BB.rowPointers;
            int[] columnIndexesB = BB.columnIndexes;
            double[] valuesB = BB.values;
            int[] rowPointersC = CC.rowPointers;
            int[] columnIndexesC = CC.columnIndexes;
            double[] valuesC = CC.values;
            int nzmax = columnIndexesC.length;
            int[] iw = new int[columnsB + 1];
            for (int i = 0; i < iw.length; ++i) {
                iw[i] = -1;
            }
            int len = -1;
            double[] valA = new double[2];
            double[] valB = new double[2];
            double[] valC = new double[2];
            for (int ii = 0; ii < rowsA; ++ii) {
                int highA = rowPointersA[ii + 1];
                for (int ka = rowPointersA[ii]; ka < highA; ++ka) {
                    valA[0] = valuesA[2 * ka];
                    valA[1] = valuesA[2 * ka + 1];
                    double[] scal = DComplex.mult(alpha, valA);
                    int jj = columnIndexesA[ka];
                    int highB = rowPointersB[jj + 1];
                    for (int kb = rowPointersB[jj]; kb < highB; ++kb) {
                        int jcol = columnIndexesB[kb];
                        int jpos = iw[jcol];
                        if (jpos == -1) {
                            if (++len >= nzmax) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            columnIndexesC[len] = jcol;
                            iw[jcol] = len;
                            valB[0] = valuesB[2 * kb];
                            valB[1] = valuesB[2 * kb + 1];
                            valB = DComplex.mult(scal, valB);
                            valuesC[2 * len] = valB[0];
                            valuesC[2 * len + 1] = valB[1];
                            continue;
                        }
                        valB[0] = valuesB[2 * kb];
                        valB[1] = valuesB[2 * kb + 1];
                        valB = DComplex.mult(scal, valB);
                        int n = 2 * jpos;
                        valuesC[n] = valuesC[n] + valB[0];
                        int n2 = 2 * jpos + 1;
                        valuesC[n2] = valuesC[n2] + valB[1];
                    }
                }
                for (int k = rowPointersC[ii]; k < len + 1; ++k) {
                    iw[columnIndexesC[k]] = -1;
                }
                rowPointersC[ii + 1] = len + 1;
            }
        } else {
            if (transposeB) {
                B = B.getConjugateTranspose();
            }
            DComplexMatrix1D[] Brows = new DComplexMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            DComplexMatrix1D[] Crows = new DComplexMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            DComplexPlusMultSecond fun = DComplexPlusMultSecond.plusMult(new double[2]);
            int[] columnIndexesA = this.columnIndexes;
            double[] valuesA = this.values;
            double[] valA = new double[2];
            int i3 = this.rows;
            while (--i3 >= 0) {
                int low = this.rowPointers[i3];
                int k = this.rowPointers[i3 + 1];
                while (--k >= low) {
                    int j = columnIndexesA[k];
                    valA[0] = valuesA[2 * k];
                    valA[1] = valuesA[2 * k + 1];
                    fun.multiplicator = DComplex.mult(valA, alpha);
                    if (!transposeA) {
                        Crows[i3].assign(Brows[j], fun);
                        continue;
                    }
                    Crows[j].assign(Brows[i3], fun);
                }
            }
        }
        return C;
    }

    private double cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        double nz2 = 0.0;
        for (int k = 0; k < n; ++k) {
            p[k] = nz;
            nz += c[k];
            nz2 += (double)c[k];
            c[k] = p[k];
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.rowPointers[this.rows];
        }
        int[] columnIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, columnIndexesNew, 0, length);
        this.columnIndexes = columnIndexesNew;
        double[] valuesNew = new double[2 * nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    @Override
    protected DComplexMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, double[] value) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList valuesList = new DoubleArrayList(this.values);
        valuesList.setSizeRaw(2 * this.rowPointers[this.rows]);
        columnIndexesList.beforeInsert(index, column);
        valuesList.beforeInsert(2 * index, value[0]);
        valuesList.beforeInsert(2 * index + 1, value[1]);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void insert(int row, int column, int index, double re, double im) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList valuesList = new DoubleArrayList(this.values);
        valuesList.setSizeRaw(2 * this.rowPointers[this.rows]);
        columnIndexesList.beforeInsert(index, column);
        valuesList.beforeInsert(2 * index, re);
        valuesList.beforeInsert(2 * index + 1, im);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int row, int index) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList valuesList = new DoubleArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.remove(index);
        valuesList.remove(2 * index);
        valuesList.remove(2 * index + 1);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] - 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }
}

