/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    private DoubleFFT_1D fft;
    protected double[] elements;

    public DenseDComplexMatrix1D(double[] values) {
        this(values.length / 2);
        this.assign(values);
    }

    public DenseDComplexMatrix1D(DoubleMatrix1D realPart) {
        this((int)realPart.size());
        this.assignReal(realPart);
    }

    public DenseDComplexMatrix1D(int size) {
        this.setUp(size, 0, 2);
        this.isNoView = true;
        this.elements = new double[2 * size];
    }

    public DenseDComplexMatrix1D(int size, double[] elements, int zero, int stride, boolean isNoView) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = isNoView;
    }

    @Override
    public double[] aggregate(final DComplexDComplexDComplexFunction aggr, final DComplexDComplexFunction f) {
        double[] b = new double[2];
        if (this.size == 0) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        double[] a = f.apply(new double[]{DenseDComplexMatrix1D.this.elements[idx], DenseDComplexMatrix1D.this.elements[idx + 1]});
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(new double[]{DenseDComplexMatrix1D.this.elements[idx += DenseDComplexMatrix1D.this.stride], DenseDComplexMatrix1D.this.elements[idx + 1]}));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new double[]{this.elements[this.zero], this.elements[this.zero + 1]});
            int idx = this.zero;
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(new double[]{this.elements[idx += this.stride], this.elements[idx + 1]}));
            }
        }
        return a;
    }

    @Override
    public double[] aggregate(DComplexMatrix1D other, final DComplexDComplexDComplexFunction aggr, final DComplexDComplexDComplexFunction f) {
        if (!(other instanceof DenseDComplexMatrix1D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkSize(other);
        if (this.size == 0) {
            double[] b = new double[]{Double.NaN, Double.NaN};
            return b;
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final double[] elemsOther = (double[])other.elements();
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        double[] a = f.apply(new double[]{DenseDComplexMatrix1D.this.elements[idx], DenseDComplexMatrix1D.this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]});
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(new double[]{DenseDComplexMatrix1D.this.elements[idx += DenseDComplexMatrix1D.this.stride], DenseDComplexMatrix1D.this.elements[idx + 1]}, new double[]{elemsOther[idxOther += strideOther], elemsOther[idxOther + 1]}));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            a = f.apply(new double[]{this.elements[this.zero], this.elements[this.zero + 1]}, new double[]{elemsOther[zeroOther], elemsOther[zeroOther + 1]});
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(new double[]{this.elements[idx += this.stride], this.elements[idx + 1]}, new double[]{elemsOther[idxOther += strideOther], elemsOther[idxOther + 1]}));
            }
        }
        return a;
    }

    @Override
    public DComplexMatrix1D assign(final DComplexDComplexFunction function) {
        double[] multiplicator;
        if (this.elements == null) {
            throw new InternalError();
        }
        if (function instanceof DComplexMult && (multiplicator = ((DComplexMult)function).multiplicator)[0] == 1.0 && multiplicator[1] == 0.0) {
            return this;
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] tmp = new double[2];
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        if (function instanceof DComplexMult) {
                            double[] multiplicator = ((DComplexMult)function).multiplicator;
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                DenseDComplexMatrix1D.this.elements[idx] = DenseDComplexMatrix1D.this.elements[idx] * multiplicator[0] - DenseDComplexMatrix1D.this.elements[idx + 1] * multiplicator[1];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = DenseDComplexMatrix1D.this.elements[idx + 1] * multiplicator[0] + DenseDComplexMatrix1D.this.elements[idx] * multiplicator[1];
                                idx += DenseDComplexMatrix1D.this.stride;
                            }
                        } else {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                tmp[0] = DenseDComplexMatrix1D.this.elements[idx];
                                tmp[1] = DenseDComplexMatrix1D.this.elements[idx + 1];
                                tmp = function.apply(tmp);
                                DenseDComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseDComplexMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] tmp = new double[2];
            int idx = this.zero;
            if (function instanceof DComplexMult) {
                double[] multiplicator2 = ((DComplexMult)function).multiplicator;
                for (int k = 0; k < this.size; ++k) {
                    this.elements[idx] = this.elements[idx] * multiplicator2[0] - this.elements[idx + 1] * multiplicator2[1];
                    this.elements[idx + 1] = this.elements[idx + 1] * multiplicator2[0] + this.elements[idx] * multiplicator2[1];
                    idx += this.stride;
                }
            } else {
                for (int k = 0; k < this.size; ++k) {
                    tmp[0] = this.elements[idx];
                    tmp[1] = this.elements[idx + 1];
                    tmp = function.apply(tmp);
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(final DComplexProcedure cond, final DComplexDComplexFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] elem = new double[2];
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            elem[0] = DenseDComplexMatrix1D.this.elements[idx];
                            elem[1] = DenseDComplexMatrix1D.this.elements[idx + 1];
                            if (cond.apply(elem)) {
                                elem = function.apply(elem);
                                DenseDComplexMatrix1D.this.elements[idx] = elem[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = elem[1];
                            }
                            idx += DenseDComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                elem[0] = this.elements[idx];
                elem[1] = this.elements[idx + 1];
                if (cond.apply(elem)) {
                    elem = function.apply(elem);
                    this.elements[idx] = elem[0];
                    this.elements[idx + 1] = elem[1];
                }
                idx += this.stride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(final DComplexProcedure cond, final double[] value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] elem = new double[2];
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            elem[0] = DenseDComplexMatrix1D.this.elements[idx];
                            elem[1] = DenseDComplexMatrix1D.this.elements[idx + 1];
                            if (cond.apply(elem)) {
                                DenseDComplexMatrix1D.this.elements[idx] = value[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = value[1];
                            }
                            idx += DenseDComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                elem[0] = this.elements[idx];
                elem[1] = this.elements[idx + 1];
                if (cond.apply(elem)) {
                    this.elements[idx] = value[0];
                    this.elements[idx + 1] = value[1];
                }
                idx += this.stride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(final DComplexRealFunction function) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        if (function == DComplexFunctions.abs) {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                double d;
                                double absX = Math.abs(DenseDComplexMatrix1D.this.elements[idx]);
                                double absY = Math.abs(DenseDComplexMatrix1D.this.elements[idx + 1]);
                                if (absX == 0.0 && absY == 0.0) {
                                    DenseDComplexMatrix1D.this.elements[idx] = 0.0;
                                } else if (absX >= absY) {
                                    d = DenseDComplexMatrix1D.this.elements[idx + 1] / DenseDComplexMatrix1D.this.elements[idx];
                                    DenseDComplexMatrix1D.this.elements[idx] = absX * Math.sqrt(1.0 + d * d);
                                } else {
                                    d = DenseDComplexMatrix1D.this.elements[idx] / DenseDComplexMatrix1D.this.elements[idx + 1];
                                    DenseDComplexMatrix1D.this.elements[idx] = absY * Math.sqrt(1.0 + d * d);
                                }
                                DenseDComplexMatrix1D.this.elements[idx + 1] = 0.0;
                                idx += DenseDComplexMatrix1D.this.stride;
                            }
                        } else {
                            double[] tmp = new double[2];
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                tmp[0] = DenseDComplexMatrix1D.this.elements[idx];
                                tmp[1] = DenseDComplexMatrix1D.this.elements[idx + 1];
                                tmp[0] = function.apply(tmp);
                                DenseDComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = 0.0;
                                idx += DenseDComplexMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            if (function == DComplexFunctions.abs) {
                for (int k = 0; k < this.size; ++k) {
                    double d;
                    double absX = Math.abs(this.elements[idx]);
                    double absY = Math.abs(this.elements[idx + 1]);
                    if (absX == 0.0 && absY == 0.0) {
                        this.elements[idx] = 0.0;
                    } else if (absX >= absY) {
                        d = this.elements[idx + 1] / this.elements[idx];
                        this.elements[idx] = absX * Math.sqrt(1.0 + d * d);
                    } else {
                        d = this.elements[idx] / this.elements[idx + 1];
                        this.elements[idx] = absY * Math.sqrt(1.0 + d * d);
                    }
                    this.elements[idx + 1] = 0.0;
                    idx += this.stride;
                }
            } else {
                double[] tmp = new double[2];
                for (int k = 0; k < this.size; ++k) {
                    tmp[0] = this.elements[idx];
                    tmp[1] = this.elements[idx + 1];
                    tmp[0] = function.apply(tmp);
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = 0.0;
                    idx += this.stride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(DComplexMatrix1D source) {
        if (!(source instanceof DenseDComplexMatrix1D)) {
            return super.assign(source);
        }
        DenseDComplexMatrix1D other = (DenseDComplexMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DComplexMatrix1D c = other.copy();
            if (!(c instanceof DenseDComplexMatrix1D)) {
                return super.assign(source);
            }
            other = (DenseDComplexMatrix1D)c;
        }
        final double[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int strideOther = other.stride;
        final int zeroOther = (int)other.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            DenseDComplexMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            DenseDComplexMatrix1D.this.elements[idx + 1] = elemsOther[idxOther + 1];
                            idx += DenseDComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int k = 0; k < this.size; ++k) {
                this.elements[idx] = elemsOther[idxOther];
                this.elements[idx + 1] = elemsOther[idxOther + 1];
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(DComplexMatrix1D y, final DComplexDComplexDComplexFunction function) {
        if (!(y instanceof DenseDComplexMatrix1D)) {
            return super.assign(y, function);
        }
        this.checkSize(y);
        final double[] elemsOther = (double[])y.elements();
        final int zeroOther = (int)y.index(0);
        final int strideOther = y.stride();
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        if (function == DComplexFunctions.plus) {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                int n = idx;
                                DenseDComplexMatrix1D.this.elements[n] = DenseDComplexMatrix1D.this.elements[n] + elemsOther[idxOther];
                                int n2 = idx + 1;
                                DenseDComplexMatrix1D.this.elements[n2] = DenseDComplexMatrix1D.this.elements[n2] + elemsOther[idxOther + 1];
                                idx += DenseDComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        } else if (function == DComplexFunctions.minus) {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                int n = idx;
                                DenseDComplexMatrix1D.this.elements[n] = DenseDComplexMatrix1D.this.elements[n] - elemsOther[idxOther];
                                int n3 = idx + 1;
                                DenseDComplexMatrix1D.this.elements[n3] = DenseDComplexMatrix1D.this.elements[n3] - elemsOther[idxOther + 1];
                                idx += DenseDComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        } else if (function == DComplexFunctions.div) {
                            double[] tmp = new double[2];
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                double scalar;
                                double re = elemsOther[idxOther];
                                double im = elemsOther[idxOther + 1];
                                if (Math.abs(re) >= Math.abs(im)) {
                                    scalar = 1.0 / (re + im * (im / re));
                                    tmp[0] = scalar * (DenseDComplexMatrix1D.this.elements[idx] + DenseDComplexMatrix1D.this.elements[idx + 1] * (im / re));
                                    tmp[1] = scalar * (DenseDComplexMatrix1D.this.elements[idx + 1] - DenseDComplexMatrix1D.this.elements[idx] * (im / re));
                                } else {
                                    scalar = 1.0 / (re * (re / im) + im);
                                    tmp[0] = scalar * (DenseDComplexMatrix1D.this.elements[idx] * (re / im) + DenseDComplexMatrix1D.this.elements[idx + 1]);
                                    tmp[1] = scalar * (DenseDComplexMatrix1D.this.elements[idx + 1] * (re / im) - DenseDComplexMatrix1D.this.elements[idx]);
                                }
                                DenseDComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseDComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        } else if (function == DComplexFunctions.mult) {
                            double[] tmp = new double[2];
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                tmp[0] = DenseDComplexMatrix1D.this.elements[idx] * elemsOther[idxOther] - DenseDComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther + 1];
                                tmp[1] = DenseDComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther] + DenseDComplexMatrix1D.this.elements[idx] * elemsOther[idxOther + 1];
                                DenseDComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseDComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        } else if (function == DComplexFunctions.multConjFirst) {
                            double[] tmp = new double[2];
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                tmp[0] = DenseDComplexMatrix1D.this.elements[idx] * elemsOther[idxOther] + DenseDComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther + 1];
                                tmp[1] = -DenseDComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther] + DenseDComplexMatrix1D.this.elements[idx] * elemsOther[idxOther + 1];
                                DenseDComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseDComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        } else if (function == DComplexFunctions.multConjSecond) {
                            double[] tmp = new double[2];
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                tmp[0] = DenseDComplexMatrix1D.this.elements[idx] * elemsOther[idxOther] + DenseDComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther + 1];
                                tmp[1] = DenseDComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther] - DenseDComplexMatrix1D.this.elements[idx] * elemsOther[idxOther + 1];
                                DenseDComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseDComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        } else {
                            double[] tmp1 = new double[2];
                            double[] tmp2 = new double[2];
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                tmp1[0] = DenseDComplexMatrix1D.this.elements[idx];
                                tmp1[1] = DenseDComplexMatrix1D.this.elements[idx + 1];
                                tmp2[0] = elemsOther[idxOther];
                                tmp2[1] = elemsOther[idxOther + 1];
                                tmp1 = function.apply(tmp1, tmp2);
                                DenseDComplexMatrix1D.this.elements[idx] = tmp1[0];
                                DenseDComplexMatrix1D.this.elements[idx + 1] = tmp1[1];
                                idx += DenseDComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            if (function == DComplexFunctions.plus) {
                for (int k = 0; k < this.size; ++k) {
                    int n = idx;
                    this.elements[n] = this.elements[n] + elemsOther[idxOther];
                    int n2 = idx + 1;
                    this.elements[n2] = this.elements[n2] + elemsOther[idxOther + 1];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            } else if (function == DComplexFunctions.minus) {
                for (int k = 0; k < this.size; ++k) {
                    int n = idx;
                    this.elements[n] = this.elements[n] - elemsOther[idxOther];
                    int n3 = idx + 1;
                    this.elements[n3] = this.elements[n3] - elemsOther[idxOther + 1];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            } else if (function == DComplexFunctions.div) {
                double[] tmp = new double[2];
                for (int k = 0; k < this.size; ++k) {
                    double scalar;
                    double re = elemsOther[idxOther];
                    double im = elemsOther[idxOther + 1];
                    if (Math.abs(re) >= Math.abs(im)) {
                        scalar = 1.0 / (re + im * (im / re));
                        tmp[0] = scalar * (this.elements[idx] + this.elements[idx + 1] * (im / re));
                        tmp[1] = scalar * (this.elements[idx + 1] - this.elements[idx] * (im / re));
                    } else {
                        scalar = 1.0 / (re * (re / im) + im);
                        tmp[0] = scalar * (this.elements[idx] * (re / im) + this.elements[idx + 1]);
                        tmp[1] = scalar * (this.elements[idx + 1] * (re / im) - this.elements[idx]);
                    }
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            } else if (function == DComplexFunctions.mult) {
                double[] tmp = new double[2];
                for (int k = 0; k < this.size; ++k) {
                    tmp[0] = this.elements[idx] * elemsOther[idxOther] - this.elements[idx + 1] * elemsOther[idxOther + 1];
                    tmp[1] = this.elements[idx + 1] * elemsOther[idxOther] + this.elements[idx] * elemsOther[idxOther + 1];
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            } else if (function == DComplexFunctions.multConjFirst) {
                double[] tmp = new double[2];
                for (int k = 0; k < this.size; ++k) {
                    tmp[0] = this.elements[idx] * elemsOther[idxOther] + this.elements[idx + 1] * elemsOther[idxOther + 1];
                    tmp[1] = -this.elements[idx + 1] * elemsOther[idxOther] + this.elements[idx] * elemsOther[idxOther + 1];
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            } else if (function == DComplexFunctions.multConjSecond) {
                double[] tmp = new double[2];
                for (int k = 0; k < this.size; ++k) {
                    tmp[0] = this.elements[idx] * elemsOther[idxOther] + this.elements[idx + 1] * elemsOther[idxOther + 1];
                    tmp[1] = this.elements[idx + 1] * elemsOther[idxOther] - this.elements[idx] * elemsOther[idxOther + 1];
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            } else {
                double[] tmp1 = new double[2];
                double[] tmp2 = new double[2];
                for (int k = 0; k < this.size; ++k) {
                    tmp1[0] = this.elements[idx];
                    tmp1[1] = this.elements[idx + 1];
                    tmp2[0] = elemsOther[idxOther];
                    tmp2[1] = elemsOther[idxOther + 1];
                    tmp1 = function.apply(tmp1, tmp2);
                    this.elements[idx] = tmp1[0];
                    this.elements[idx + 1] = tmp1[1];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(final double re, final double im) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            DenseDComplexMatrix1D.this.elements[idx] = re;
                            DenseDComplexMatrix1D.this.elements[idx + 1] = im;
                            idx += DenseDComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[idx] = re;
                this.elements[idx + 1] = im;
                idx += this.stride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(double[] values) {
        if (this.isNoView) {
            if (values.length != 2 * this.size) {
                throw new IllegalArgumentException("The length of values[] must be equal to 2*size()=" + 2L * this.size());
            }
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            super.assign(values);
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assignImaginary(DoubleMatrix1D other) {
        if (!(other instanceof DenseDoubleMatrix1D)) {
            return super.assignImaginary(other);
        }
        this.checkSize(other);
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final double[] elemsOther = (double[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DenseDComplexMatrix1D.this.elements[idx + 1] = elemsOther[idxOther];
                            idx += DenseDComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int i = 0; i < this.size; ++i) {
                this.elements[idx + 1] = elemsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assignReal(DoubleMatrix1D other) {
        if (!(other instanceof DenseDoubleMatrix1D)) {
            return super.assignReal(other);
        }
        this.checkSize(other);
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final double[] elemsOther = (double[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DenseDComplexMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            idx += DenseDComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int i = 0; i < this.size; ++i) {
                this.elements[idx] = elemsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return this;
    }

    public void fft() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.complexForward(this.elements);
        } else {
            DComplexMatrix1D copy = this.copy();
            this.fft.complexForward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public DoubleMatrix1D getImaginaryPart() {
        DenseDoubleMatrix1D Im = new DenseDoubleMatrix1D(this.size);
        final double[] elemsOther = Im.elements();
        final int zeroOther = (int)Im.index(0);
        final int strideOther = Im.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            elemsOther[idxOther] = DenseDComplexMatrix1D.this.elements[idx + 1];
                            idx += DenseDComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int i = 0; i < this.size; ++i) {
                elemsOther[idxOther] = this.elements[idx + 1];
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return Im;
    }

    @Override
    public void getNonZeros(IntArrayList indexList, ArrayList<double[]> valueList) {
        indexList.clear();
        valueList.clear();
        int s = (int)this.size();
        int idx = this.zero;
        for (int k = 0; k < s; ++k) {
            double[] value = new double[]{this.elements[idx], this.elements[idx + 1]};
            if (value[0] != 0.0 || value[1] != 0.0) {
                indexList.add(k);
                valueList.add(value);
            }
            idx += this.stride;
        }
    }

    @Override
    public double[] getQuick(int index) {
        int idx = this.zero + index * this.stride;
        return new double[]{this.elements[idx], this.elements[idx + 1]};
    }

    @Override
    public DoubleMatrix1D getRealPart() {
        DenseDoubleMatrix1D R = new DenseDoubleMatrix1D(this.size);
        final double[] elemsOther = R.elements();
        final int zeroOther = (int)R.index(0);
        final int strideOther = R.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            elemsOther[idxOther] = DenseDComplexMatrix1D.this.elements[idx];
                            idx += DenseDComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int i = 0; i < this.size; ++i) {
                elemsOther[idxOther] = this.elements[idx];
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return R;
    }

    public void ifft(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.complexInverse(this.elements, scale);
        } else {
            DComplexMatrix1D copy = this.copy();
            this.fft.complexInverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public DComplexMatrix1D like(int size) {
        return new DenseDComplexMatrix1D(size);
    }

    @Override
    public DComplexMatrix2D like2D(int rows, int columns) {
        return new DenseDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseDComplexMatrix2D M = new DenseDComplexMatrix2D(rows, columns);
        final double[] elemsOther = (double[])((DComplexMatrix2D)M).elements();
        final int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        final int rowStrideOther = M.rowStride();
        final int columnStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idxOther = zeroOther + c * columnStrideOther;
                            int idx = DenseDComplexMatrix1D.this.zero + c * rows * DenseDComplexMatrix1D.this.stride;
                            for (int r = 0; r < rows; ++r) {
                                elemsOther[idxOther] = DenseDComplexMatrix1D.this.elements[idx];
                                elemsOther[idxOther + 1] = DenseDComplexMatrix1D.this.elements[idx + 1];
                                idxOther += rowStrideOther;
                                idx += DenseDComplexMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int c = 0; c < columns; ++c) {
                int idxOther = zeroOther + c * columnStrideOther;
                for (int r = 0; r < rows; ++r) {
                    elemsOther[idxOther] = this.elements[idx];
                    elemsOther[idxOther + 1] = this.elements[idx + 1];
                    idxOther += rowStrideOther;
                    idx += this.stride;
                }
            }
        }
        return M;
    }

    @Override
    public DComplexMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseDComplexMatrix3D M = new DenseDComplexMatrix3D(slices, rows, columns);
        final double[] elemsOther = (double[])((DComplexMatrix3D)M).elements();
        final int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        final int sliceStrideOther = M.sliceStride();
        final int rowStrideOther = M.rowStride();
        final int columnStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < columns; ++c) {
                                int idxOther = zeroOther + s * sliceStrideOther + c * columnStrideOther;
                                int idx = DenseDComplexMatrix1D.this.zero + (s * rows * columns + c * rows) * DenseDComplexMatrix1D.this.stride;
                                for (int r = 0; r < rows; ++r) {
                                    elemsOther[idxOther] = DenseDComplexMatrix1D.this.elements[idx];
                                    elemsOther[idxOther + 1] = DenseDComplexMatrix1D.this.elements[idx + 1];
                                    idxOther += rowStrideOther;
                                    idx += DenseDComplexMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int s = 0; s < slices; ++s) {
                for (int c = 0; c < columns; ++c) {
                    int idxOther = zeroOther + s * sliceStrideOther + c * columnStrideOther;
                    for (int r = 0; r < rows; ++r) {
                        elemsOther[idxOther] = this.elements[idx];
                        elemsOther[idxOther + 1] = this.elements[idx + 1];
                        idxOther += rowStrideOther;
                        idx += this.stride;
                    }
                }
            }
        }
        return M;
    }

    @Override
    public void setQuick(int index, double re, double im) {
        int idx = this.zero + index * this.stride;
        this.elements[idx] = re;
        this.elements[idx + 1] = im;
    }

    @Override
    public void setQuick(int index, double[] value) {
        int idx = this.zero + index * this.stride;
        this.elements[idx] = value[0];
        this.elements[idx + 1] = value[1];
    }

    @Override
    public void swap(DComplexMatrix1D other) {
        DenseDComplexMatrix1D y;
        if (!(other instanceof DenseDComplexMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseDComplexMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        final double[] elemsOther = y.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int strideOther = y.stride;
        final int zeroOther = (int)y.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            double tmp = DenseDComplexMatrix1D.this.elements[idx];
                            DenseDComplexMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            elemsOther[idxOther] = tmp;
                            tmp = DenseDComplexMatrix1D.this.elements[idx + 1];
                            DenseDComplexMatrix1D.this.elements[idx + 1] = elemsOther[idxOther + 1];
                            elemsOther[idxOther + 1] = tmp;
                            idx += DenseDComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int k = 0; k < this.size; ++k) {
                double tmp = this.elements[idx];
                this.elements[idx] = elemsOther[idxOther];
                elemsOther[idxOther] = tmp;
                tmp = this.elements[idx + 1];
                this.elements[idx + 1] = elemsOther[idxOther + 1];
                elemsOther[idxOther + 1] = tmp;
                idx += this.stride;
                idxOther += strideOther;
            }
        }
    }

    @Override
    public void toArray(double[] values) {
        if (values.length < 2 * this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    @Override
    public double[] zDotProduct(DComplexMatrix1D y, int from, int length) {
        int size = (int)this.size();
        if (from < 0 || length <= 0) {
            return new double[]{0.0, 0.0};
        }
        int tail = from + length;
        if (size < tail) {
            tail = size;
        }
        if (y.size() < (long)tail) {
            tail = (int)y.size();
        }
        length = tail - from;
        final double[] elemsOther = (double[])y.elements();
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int strideOther = y.stride();
        final int zero = (int)this.index(from);
        final int zeroOther = (int)y.index(from);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        double[] sum = new double[2];
        if (nthreads > 1 && length >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] sum = new double[2];
                        int idx = zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            sum[0] = sum[0] + (DenseDComplexMatrix1D.this.elements[idx] * elemsOther[idxOther] + DenseDComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther + 1]);
                            sum[1] = sum[1] + (DenseDComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther] - DenseDComplexMatrix1D.this.elements[idx] * elemsOther[idxOther + 1]);
                            idx += DenseDComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                sum = results[0];
                for (j = 1; j < nthreads; ++j) {
                    sum = DComplex.plus(sum, results[j]);
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int k = 0; k < length; ++k) {
                sum[0] = sum[0] + (this.elements[idx] * elemsOther[idxOther] + this.elements[idx + 1] * elemsOther[idxOther + 1]);
                sum[1] = sum[1] + (this.elements[idx + 1] * elemsOther[idxOther] - this.elements[idx] * elemsOther[idxOther + 1]);
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return sum;
    }

    @Override
    public double[] zSum() {
        double[] sum = new double[2];
        if (this.elements == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] sum = new double[2];
                        int idx = DenseDComplexMatrix1D.this.zero + firstIdx * DenseDComplexMatrix1D.this.stride;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            sum[0] = sum[0] + DenseDComplexMatrix1D.this.elements[idx];
                            sum[1] = sum[1] + DenseDComplexMatrix1D.this.elements[idx + 1];
                            idx += DenseDComplexMatrix1D.this.stride;
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                sum = results[0];
                for (j = 1; j < nthreads; ++j) {
                    sum[0] = sum[0] + results[j][0];
                    sum[1] = sum[1] + results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            for (int k = 0; k < this.size; ++k) {
                sum[0] = sum[0] + this.elements[idx];
                sum[1] = sum[1] + this.elements[idx + 1];
                idx += this.stride;
            }
        }
        return sum;
    }

    @Override
    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int idx = this.zero;
        for (int i = 0; i < this.size && cardinality < maxCardinality; ++i) {
            if (this.elements[idx] != 0.0 || this.elements[idx + 1] != 0.0) {
                ++cardinality;
            }
            idx += this.stride;
        }
        return cardinality;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix1D other) {
        if (other instanceof SelectedDenseDComplexMatrix1D) {
            SelectedDenseDComplexMatrix1D otherMatrix = (SelectedDenseDComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDComplexMatrix1D) {
            DenseDComplexMatrix1D otherMatrix = (DenseDComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    protected DComplexMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseDComplexMatrix1D(this.elements, offsets);
    }
}

