/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.tree.TreeModelSupport;
import org.jdesktop.swingx.treetable.NodeChangedMediator;
import org.jdesktop.swingx.treetable.NodeModel;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class TreeTableModelAdapter
implements TreeTableModel {
    private TreeModel treeModel;
    private NodeModel nodeModel;
    private TreeModelSupport treeModelSupport;
    private Broadcaster broadcaster;
    private NodeChangedMediator mediator;

    public TreeTableModelAdapter(TreeModel treeModel, NodeModel nodeModel) {
        this(treeModel, nodeModel, null);
    }

    public TreeTableModelAdapter(TreeModel treeModel, NodeModel nodeModel, NodeChangedMediator mediator) {
        this.nodeModel = nodeModel;
        this.treeModel = treeModel;
        this.treeModelSupport = new TreeModelSupport(this);
        this.broadcaster = new Broadcaster();
        treeModel.addTreeModelListener(this.broadcaster);
        this.setNodeChangedMediator(mediator);
    }

    public void setNodeChangedMediator(NodeChangedMediator mediator) {
        this.mediator = mediator;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.nodeModel.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.nodeModel != null ? this.nodeModel.getColumnCount() : 0;
    }

    @Override
    public String getColumnName(int column) {
        return this.nodeModel.getColumnName(column);
    }

    @Override
    public int getHierarchicalColumn() {
        return this.nodeModel != null ? this.nodeModel.getHierarchicalColumn() : -1;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        return this.nodeModel.getValueAt(node, column);
    }

    protected boolean isEditable() {
        return this.mediator != null;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.isEditable() && this.nodeModel.isCellEditable(node, column);
    }

    @Override
    public void setValueAt(Object value, Object node, int column) {
        if (!this.isCellEditable(node, column)) {
            return;
        }
        this.nodeModel.setValueAt(value, node, column);
        this.mediator.nodeChanged(this.treeModel, node);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.treeModel.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.treeModel.getChildCount(parent);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.treeModel.getIndexOfChild(parent, child);
    }

    @Override
    public Object getRoot() {
        return this.treeModel != null ? this.treeModel.getRoot() : null;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.treeModel.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.treeModel.valueForPathChanged(path, newValue);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelSupport.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelSupport.removeTreeModelListener(l);
    }

    private class Broadcaster
    implements TreeModelListener {
        private Broadcaster() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreeTableModelAdapter.this.treeModelSupport.fireChildrenChanged(e.getTreePath(), e.getChildIndices(), e.getChildren());
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreeTableModelAdapter.this.treeModelSupport.fireChildrenAdded(e.getTreePath(), e.getChildIndices(), e.getChildren());
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreeTableModelAdapter.this.treeModelSupport.fireChildrenRemoved(e.getTreePath(), e.getChildIndices(), e.getChildren());
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreeTableModelAdapter.this.treeModelSupport.fireTreeStructureChanged(e.getTreePath());
        }
    }
}

