/*
 * Decompiled with CFR 0.152.
 */
package joptima;

import java.util.Iterator;
import joptima.Fitter;
import joptima.Function;

public class ChiSquaredFitter
extends Fitter {
    private double[] xpoint;
    private double[] ypoint;
    private double[] yerror = null;

    public ChiSquaredFitter() {
    }

    public ChiSquaredFitter(double[] x, double[] y) {
        this.setData(x, y);
    }

    public ChiSquaredFitter(double[] x, double[] y, double[] errors) {
        this.setData(x, y, errors);
    }

    public ChiSquaredFitter(double[] x, double[] y, Function f) {
        this(x, y);
        this.addFunction(f);
    }

    public ChiSquaredFitter(double[] x, double[] y, double[] errors, Function f) {
        this(x, y, errors);
        this.addFunction(f);
    }

    public void setData(double[] x, double[] y) {
        this.xpoint = x;
        this.ypoint = y;
        this.yerror = null;
    }

    public void setData(double[] x, double[] y, double[] errors) {
        this.xpoint = x;
        this.ypoint = y;
        this.yerror = errors;
    }

    @Override
    public double calculate() {
        double value = 0.0;
        for (int point = 0; point < this.xpoint.length; ++point) {
            Iterator it = this.m_functions.iterator();
            double fvalue = 0.0;
            while (it.hasNext()) {
                Function f = (Function)it.next();
                fvalue += f.calculate(this.xpoint[point]);
            }
            double chisq = this.ypoint[point] - fvalue;
            chisq *= chisq;
            if (null != this.yerror) {
                chisq /= this.yerror[point] * this.yerror[point];
            }
            value += chisq;
        }
        return value;
    }
}

