/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.rsl.jpop;

import edu.stanford.rsl.jpop.FunctionAssembler;

public class AdditiveFunctionAssembler
implements FunctionAssembler {
    @Override
    public double assembleEvaluationBlocks(double[] blockResults) {
        double revan = 0.0;
        for (int i = 0; i < blockResults.length; ++i) {
            revan += blockResults[i];
        }
        return revan;
    }

    @Override
    public double[] assembleGradientBlocks(double[][] blockResults) {
        double[] revan = new double[blockResults[0].length];
        for (int i = 0; i < blockResults.length; ++i) {
            for (int j = 0; j < blockResults[0].length; ++j) {
                int n = j;
                revan[n] = revan[n] + blockResults[i][j];
            }
        }
        return revan;
    }

    @Override
    public double[][] assembleHessianBlocks(double[][][] blockResults) {
        double[][] revan = new double[blockResults[0].length][blockResults[0][0].length];
        for (int i = 0; i < blockResults.length; ++i) {
            for (int j = 0; j < blockResults[0].length; ++j) {
                for (int k = 0; k < blockResults[0][0].length; ++k) {
                    double[] dArray = revan[j];
                    int n = k;
                    dArray[n] = dArray[n] + blockResults[i][j][k];
                }
            }
        }
        return revan;
    }
}

