/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.util;

import com.joptimizer.util.MyTask;
import java.util.Date;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import junit.framework.TestCase;

public class MyTaskParallelTest
extends TestCase {
    private static int NUM_OF_TASKS = 50;

    public void testDummy() {
        MyTaskParallelTest.assertTrue((boolean)true);
    }

    public void xxxtestParallel() throws Exception {
        long t0 = new Date().getTime();
        int nrOfProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService eservice = Executors.newFixedThreadPool(nrOfProcessors, new MyThreadFactory());
        ExecutorCompletionService<Integer> cservice = new ExecutorCompletionService<Integer>(eservice);
        for (int index = 1; index <= NUM_OF_TASKS; ++index) {
            cservice.submit(new MyTask(index));
        }
        int totalResult = 0;
        for (int index = 0; index < NUM_OF_TASKS; ++index) {
            try {
                int taskResult = (Integer)cservice.take().get();
                totalResult += taskResult;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Double secs = new Double((double)(new Date().getTime() - t0) * 0.001);
        System.out.println("total result:  " + totalResult);
        System.out.println("total run time " + secs + " secs");
        MyTaskParallelTest.assertEquals((Object)((double)((1 + NUM_OF_TASKS) * NUM_OF_TASKS) / 2.0), (Object)totalResult);
    }

    private class MyThreadFactory
    implements ThreadFactory {
        private ThreadFactory innerFactory = Executors.defaultThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable arg0) {
            return this.innerFactory.newThread(arg0);
        }
    }
}

