/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.functions.PDQuadraticMultivariateRealFunction;
import com.joptimizer.functions.QuadraticMultivariateRealFunction;
import com.joptimizer.functions.StrictlyConvexMultivariateRealFunction;
import com.joptimizer.optimizers.JOptimizer;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.optimizers.PrimalDualMethod;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrimalDualMethodTest
extends TestCase {
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testOptimize() throws Exception {
        this.log.debug((Object)"testOptimize");
        DoubleMatrix2D pMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = pMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.25, 0.25, 0.5});
        or.setFi(inequalities);
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setTolerance(1.0E-11);
        or.setToleranceFeas(1.0E-8);
        PrimalDualMethod opt = new PrimalDualMethod();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        PrimalDualMethodTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-8);
        PrimalDualMethodTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-8);
        PrimalDualMethodTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-8);
    }

    public void testOptimize2() throws Exception {
        this.log.debug((Object)"testOptimize2");
        DoubleMatrix2D qq = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D ll = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = qq.assign(Mult.mult(theta));
        DoubleMatrix1D q = ll.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setTolerance(1.0E-12);
        PrimalDualMethod opt = new PrimalDualMethod();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        PrimalDualMethodTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-7);
        PrimalDualMethodTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-7);
        PrimalDualMethodTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-7);
    }

    public void testOptimize3() throws Exception {
        this.log.debug((Object)"testOptimize3");
        DoubleMatrix2D qq = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D ll = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D PMatrix = qq.assign(Mult.mult(theta));
        DoubleMatrix1D Qvector = ll.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(PMatrix.toArray(), Qvector.toArray(), 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0), FunctionsUtils.createCircle(3, 5.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.2, 0.2, 0.6});
        or.setInitialLagrangian(new double[]{0.5, 0.5, 0.5, 0.5});
        or.setFi(inequalities);
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setTolerance(1.0E-10);
        PrimalDualMethod opt = new PrimalDualMethod();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol    : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value      : " + objectiveFunction.value(sol)));
        PrimalDualMethodTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-7);
        PrimalDualMethodTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-7);
        PrimalDualMethodTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-7);
    }

    public void testOptimize4() throws Exception {
        this.log.debug((Object)"testOptimize4");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{1.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 1.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setToleranceKKT(1.0E-4);
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.0, 0.0});
        or.setFi(inequalities);
        PrimalDualMethod opt = new PrimalDualMethod();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol    : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value      : " + value));
        PrimalDualMethodTest.assertEquals((double)(-Math.sqrt(2.0)), (double)value, (double)1.0E-8);
        PrimalDualMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[0], (double)1.0E-8);
        PrimalDualMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[1], (double)1.0E-8);
    }

    public void testOptimize5() throws Exception {
        this.log.debug((Object)"testOptimize5");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{2.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.9, 0.1});
        or.setFi(inequalities);
        or.setA(new double[][]{{1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setTolerance(1.0E-9);
        PrimalDualMethod opt = new PrimalDualMethod();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        PrimalDualMethodTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-8);
        PrimalDualMethodTest.assertEquals((double)1.0, (double)sol[1], (double)1.0E-8);
        PrimalDualMethodTest.assertEquals((double)1.0, (double)value, (double)1.0E-8);
    }

    public void testOptimize6() throws Exception {
        this.log.debug((Object)"testOptimize6");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{1.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 1.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialLagrangian(new double[]{10.0});
        or.setFi(inequalities);
        or.setInteriorPointMethod("PRIMAL_DUAL_METHOD");
        or.setToleranceFeas(5.0E-6);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        PrimalDualMethodTest.assertEquals((double)(-Math.sqrt(2.0)), (double)value, (double)1.0E-8);
        PrimalDualMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[0], (double)1.0E-8);
        PrimalDualMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[1], (double)1.0E-8);
    }

    public void testOptimize7() throws Exception {
        this.log.debug((Object)"testOptimize7");
        StrictlyConvexMultivariateRealFunction objectiveFunction = new StrictlyConvexMultivariateRealFunction(){

            @Override
            public double value(double[] X) {
                DoubleMatrix1D Z = PrimalDualMethodTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                return Math.exp(Z.zDotProduct(Z));
            }

            @Override
            public double[] gradient(double[] X) {
                DoubleMatrix1D Z = PrimalDualMethodTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                return Z.assign(Mult.mult(2.0 * Math.exp(Z.zDotProduct(Z)))).toArray();
            }

            @Override
            public double[][] hessian(double[] X) {
                DoubleMatrix1D Z = PrimalDualMethodTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                double d = Math.exp(Z.zDotProduct(Z));
                DoubleMatrix2D ID = PrimalDualMethodTest.this.F2.identity(2);
                DoubleMatrix2D ret = PrimalDualMethodTest.this.ALG.multOuter(Z, Z, null).assign(ID, Functions.plus).assign(Mult.mult(2.0 * d));
                return ret.toArray();
            }

            @Override
            public int getDim() {
                return 2;
            }
        };
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 3.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.2, 0.2});
        or.setFi(inequalities);
        PrimalDualMethod opt = new PrimalDualMethod();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        PrimalDualMethodTest.assertEquals((double)1.0, (double)sol[0], (double)1.0E-7);
        PrimalDualMethodTest.assertEquals((double)2.0, (double)sol[1], (double)1.0E-7);
    }

    public void testOptimize8() throws Exception {
        this.log.debug((Object)"testOptimize8");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{0.0, 0.0, 1.0}, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0, 0.0}};
        double[] equalityBVector = new double[]{4.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] PMatrix = new double[][]{{2.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        double[] qVector = new double[]{0.0, -1.0, -1.0};
        inequalities[0] = new QuadraticMultivariateRealFunction(PMatrix, qVector, 0.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{2.0, 2.0, 2000.0});
        or.setA(equalityAMatrix);
        or.setB(equalityBVector);
        or.setFi(inequalities);
        or.setToleranceFeas(1.0E-6);
        or.setTolerance(2.0E-6);
        or.setInteriorPointMethod("PRIMAL_DUAL_METHOD");
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        PrimalDualMethodTest.assertEquals((double)-0.5, (double)sol[0], (double)0.01);
        PrimalDualMethodTest.assertEquals((double)4.5, (double)sol[1], (double)0.01);
        PrimalDualMethodTest.assertEquals((double)-4.25, (double)sol[2], (double)0.01);
    }
}

