/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.functions.LogarithmicBarrier;
import com.joptimizer.functions.PDQuadraticMultivariateRealFunction;
import com.joptimizer.functions.PSDQuadraticMultivariateRealFunction;
import com.joptimizer.functions.QuadraticMultivariateRealFunction;
import com.joptimizer.functions.SDPLogarithmicBarrier;
import com.joptimizer.functions.SOCPLogarithmicBarrier;
import com.joptimizer.functions.StrictlyConvexMultivariateRealFunction;
import com.joptimizer.optimizers.BarrierMethod;
import com.joptimizer.optimizers.JOptimizer;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;

public class BarrierMethodTest
extends TestCase {
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testOptimize() throws Exception {
        this.log.debug((Object)"testOptimize");
        DoubleMatrix2D pMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = pMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setCheckProgressConditions(true);
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.6, 0.2, 0.2});
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setTolerance(1.0E-10);
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 3);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-6);
    }

    public void testOptimize2() throws Exception {
        this.log.debug((Object)"testOptimize2");
        DoubleMatrix2D pMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = pMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setNotFeasibleInitialPoint(new double[]{-0.2, 1.0, 0.2});
        or.setCheckKKTSolutionAccuracy(true);
        or.setF0(objectiveFunction);
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setTolerance(1.0E-10);
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 3);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-6);
    }

    public void testOptimize3() throws Exception {
        this.log.debug((Object)"testOptimize3");
        DoubleMatrix2D pMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = pMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setF0(objectiveFunction);
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setTolerance(1.0E-10);
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 3);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-6);
    }

    public void testOptimize4() throws Exception {
        this.log.debug((Object)"testOptimize4");
        DoubleMatrix2D pMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = pMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0), FunctionsUtils.createCircle(3, 5.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.2, 0.6, 0.2});
        or.setInitialLagrangian(new double[]{0.5, 0.5, 0.5, 0.5});
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setTolerance(1.0E-10);
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 3);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-6);
    }

    public void testOptimize1D() throws Exception {
        this.log.debug((Object)"testOptimize1D");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(1, 1.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.0});
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 1);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        BarrierMethodTest.assertEquals((double)-1.0, (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)-1.0, (double)value, (double)1.0E-6);
    }

    public void testOptimize5() throws Exception {
        this.log.debug((Object)"testOptimize5");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{1.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 1.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.0, 0.0});
        or.setTolerance(1.0E-11);
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 2);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        BarrierMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[0], (double)1.0E-9);
        BarrierMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[1], (double)1.0E-9);
        BarrierMethodTest.assertEquals((double)(-Math.sqrt(2.0)), (double)value, (double)1.0E-9);
    }

    public void testSimpleLinear() throws Exception {
        this.log.debug((Object)"testSimpleLinear");
        double[] C = new double[]{1.0, 1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(C, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{1.0, 0.0}, -3.0), new LinearMultivariateRealFunction(new double[]{-1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 1.0}, -3.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setInteriorPointMethod("BARRIER_METHOD");
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setTolerance(1.0E-12);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-12);
        BarrierMethodTest.assertEquals((double)0.0, (double)sol[1], (double)1.0E-12);
    }

    public void testOptimize6() throws Exception {
        this.log.debug((Object)"testOptimize6");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{2.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.9, 0.1});
        or.setA(new double[][]{{1.0, 1.0}});
        or.setB(new double[]{1.0});
        or.setCheckKKTSolutionAccuracy(true);
        or.setCheckProgressConditions(true);
        or.setToleranceInnerStep(9.999999999999999E-6);
        or.setTolerance(1.0E-8);
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 2);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        BarrierMethodTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-7);
        BarrierMethodTest.assertEquals((double)1.0, (double)sol[1], (double)1.0E-7);
        BarrierMethodTest.assertEquals((double)1.0, (double)value, (double)1.0E-7);
    }

    public void testOptimize7() throws Exception {
        this.log.debug((Object)"testOptimize7");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{1.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 1.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 2);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        BarrierMethodTest.assertEquals((double)(-Math.sqrt(2.0)), (double)value, (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[1], (double)1.0E-6);
    }

    public void testOptimize7b() throws Exception {
        this.log.debug((Object)"testOptimize7b");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{0.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] PMatrix = new double[][]{{2.0, 0.0}, {0.0, 0.0}};
        double[] qVector = new double[]{0.0, -1.0};
        inequalities[0] = new PSDQuadraticMultivariateRealFunction(PMatrix, qVector, 0.0, true);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setNotFeasibleInitialPoint(new double[]{-1.0, 1.0000001});
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 2);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        BarrierMethodTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.0, (double)sol[1], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.0, (double)value, (double)1.0E-6);
    }

    public void testQCQuadraticProgramming() throws Exception {
        this.log.debug((Object)"testQCQuadraticProgramming");
        double[] C0 = new double[]{0.0, 1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(C0, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] P1 = new double[][]{{2.0, 0.0}, {0.0, 0.0}};
        double[] C1 = new double[]{0.0, -1.0};
        inequalities[0] = new QuadraticMultivariateRealFunction(P1, C1, -1.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{2.0, 5.0});
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 2);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)-1.0, (double)sol[1], (double)1.0E-6);
    }

    public void testOptimize8() throws Exception {
        this.log.debug((Object)"testOptimize8");
        StrictlyConvexMultivariateRealFunction objectiveFunction = new StrictlyConvexMultivariateRealFunction(){

            @Override
            public double value(double[] X) {
                DoubleMatrix1D Z = BarrierMethodTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                return Math.exp(Z.zDotProduct(Z));
            }

            @Override
            public double[] gradient(double[] X) {
                DoubleMatrix1D Z = BarrierMethodTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                return Z.assign(Mult.mult(2.0 * Math.exp(Z.zDotProduct(Z)))).toArray();
            }

            @Override
            public double[][] hessian(double[] X) {
                DoubleMatrix1D Z = BarrierMethodTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                double d = Math.exp(Z.zDotProduct(Z));
                DoubleMatrix2D ID = BarrierMethodTest.this.F2.identity(2);
                DoubleMatrix2D ret = BarrierMethodTest.this.ALG.multOuter(Z, Z, null).assign(ID, Functions.plus).assign(Mult.mult(2.0 * d));
                return ret.toArray();
            }

            @Override
            public int getDim() {
                return 2;
            }
        };
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 3.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.2, 0.2});
        LogarithmicBarrier bf = new LogarithmicBarrier(inequalities, 2);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        BarrierMethodTest.assertEquals((double)1.0, (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)2.0, (double)sol[1], (double)1.0E-6);
    }

    public void testSimpleSDP() throws Exception {
        this.log.debug((Object)"testSimpleSDP");
        double[] f0 = new double[]{0.0, 1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(f0, 0.0);
        double[][] A = new double[][]{{1.0, 0.0}};
        double[] b = new double[]{0.0};
        double[] c = new double[]{0.0, 1.0};
        double d = 0.0;
        double[][] F0 = new double[][]{{1.0, b[0]}, {b[0], d}};
        double[][] F1 = new double[][]{{0.0, A[0][0]}, {A[0][0], c[0]}};
        double[][] F2 = new double[][]{{0.0, A[0][1]}, {A[0][1], c[1]}};
        double[][] GMatrix = new Array2DRowRealMatrix((double[][])F0).scalarMultiply(-1.0).getData();
        ArrayList<double[][]> FiMatrixList = new ArrayList<double[][]>();
        FiMatrixList.add(FiMatrixList.size(), new Array2DRowRealMatrix((double[][])F1).scalarMultiply(-1.0).getData());
        FiMatrixList.add(FiMatrixList.size(), new Array2DRowRealMatrix((double[][])F2).scalarMultiply(-1.0).getData());
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setCheckKKTSolutionAccuracy(true);
        SDPLogarithmicBarrier bf = new SDPLogarithmicBarrier(FiMatrixList, GMatrix);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-7);
        BarrierMethodTest.assertEquals((double)0.0, (double)sol[1], (double)1.0E-7);
    }

    public void testSemidefiniteProgramming() throws Exception {
        this.log.debug((Object)"testSemidefiniteProgramming");
        double[] c = new double[]{0.0, 0.0, 1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(c, 0.0);
        double[][] A0 = new double[][]{{-Math.sqrt(0.42), 0.0, 0.0}, {-Math.sqrt(2.0) / 5.0, -1.0 / Math.sqrt(2.0), 0.0}};
        double[] b0 = new double[]{0.0, 0.0, 0.0};
        double[] c0 = new double[]{0.0, 0.0, 1.0};
        double d0 = 0.0;
        double[][] A1 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        double[] b1 = new double[]{2.0, 2.0, 0.0};
        double[] c1 = new double[]{0.0, 0.0, 0.0};
        double d1 = Math.pow(1.75, 2.0);
        double[][] G = new double[][]{{1.0, 0.0, b0[0], 0.0, 0.0, 0.0}, {0.0, 1.0, b0[1], 0.0, 0.0, 0.0}, {b0[0], b0[1], d0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, b1[0]}, {0.0, 0.0, 0.0, 0.0, 1.0, b1[1]}, {0.0, 0.0, 0.0, b1[0], b1[1], d1}};
        double[][] F1 = new double[][]{{0.0, 0.0, A0[0][0], 0.0, 0.0, 0.0}, {0.0, 0.0, A0[1][0], 0.0, 0.0, 0.0}, {A0[0][0], A0[1][0], c0[0], 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, A1[0][0]}, {0.0, 0.0, 0.0, 0.0, 0.0, A1[1][0]}, {0.0, 0.0, 0.0, A1[0][0], A1[1][0], c1[0]}};
        double[][] F2 = new double[][]{{0.0, 0.0, A0[0][1], 0.0, 0.0, 0.0}, {0.0, 0.0, A0[1][1], 0.0, 0.0, 0.0}, {A0[0][1], A0[1][1], c0[1], 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, A1[0][1]}, {0.0, 0.0, 0.0, 0.0, 0.0, A1[1][1]}, {0.0, 0.0, 0.0, A1[0][1], A1[1][1], c1[1]}};
        double[][] F3 = new double[][]{{0.0, 0.0, A0[0][2], 0.0, 0.0, 0.0}, {0.0, 0.0, A0[1][2], 0.0, 0.0, 0.0}, {A0[0][2], A0[1][2], c0[2], 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, A1[0][2]}, {0.0, 0.0, 0.0, 0.0, 0.0, A1[1][2]}, {0.0, 0.0, 0.0, A1[0][2], A1[1][2], c1[2]}};
        double[][] GMatrix = new Array2DRowRealMatrix((double[][])G).scalarMultiply(-1.0).getData();
        ArrayList<double[][]> FiMatrixList = new ArrayList<double[][]>();
        FiMatrixList.add(FiMatrixList.size(), new Array2DRowRealMatrix((double[][])F1).scalarMultiply(-1.0).getData());
        FiMatrixList.add(FiMatrixList.size(), new Array2DRowRealMatrix((double[][])F2).scalarMultiply(-1.0).getData());
        FiMatrixList.add(FiMatrixList.size(), new Array2DRowRealMatrix((double[][])F3).scalarMultiply(-1.0).getData());
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        SDPLogarithmicBarrier bf = new SDPLogarithmicBarrier(FiMatrixList, GMatrix);
        BarrierMethod opt = new BarrierMethod(bf);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)(-2.0 + 1.75 / Math.sqrt(2.0)), (double)sol[0], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)(-2.0 + 1.75 / Math.sqrt(2.0)), (double)sol[1], (double)1.0E-6);
        BarrierMethodTest.assertEquals((double)0.814103544571, (double)sol[2], (double)1.0E-6);
    }

    public void testSOCPLorentz() throws Exception {
        this.log.debug((Object)"testSOCPLorentz");
        double[] c = new double[]{1.0, 1.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(c, 0.0);
        double[][] A = new double[][]{{0.0, 0.0, 1.0}};
        double[] b = new double[]{1.0};
        ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters> socpConstraintParametersList = new ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters>();
        SOCPLogarithmicBarrier barrierFunction = new SOCPLogarithmicBarrier(socpConstraintParametersList, 3);
        double[][] A1 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        double[] b1 = new double[]{0.0, 0.0};
        double[] c1 = new double[]{0.0, 0.0, 1.0};
        double d1 = 0.0;
        SOCPLogarithmicBarrier sOCPLogarithmicBarrier = barrierFunction;
        sOCPLogarithmicBarrier.getClass();
        SOCPLogarithmicBarrier.SOCPConstraintParameters constraintParams1 = sOCPLogarithmicBarrier.new SOCPLogarithmicBarrier.SOCPConstraintParameters(A1, b1, c1, d1);
        socpConstraintParametersList.add(socpConstraintParametersList.size(), constraintParams1);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setA(A);
        or.setB(b);
        or.setCheckProgressConditions(true);
        BarrierMethod opt = new BarrierMethod(barrierFunction);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[0], (double)1.0E-5);
        BarrierMethodTest.assertEquals((double)(-Math.sqrt(2.0) / 2.0), (double)sol[1], (double)1.0E-5);
        BarrierMethodTest.assertEquals((double)1.0, (double)sol[2], (double)1.0E-5);
    }

    public void testSOCPLorentzIneq() throws Exception {
        this.log.debug((Object)"testSOCPLorentzIneq");
        double[] minimizeF = new double[]{-1.0, -1.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters> socpConstraintParametersList = new ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters>();
        SOCPLogarithmicBarrier barrierFunction = new SOCPLogarithmicBarrier(socpConstraintParametersList, 3);
        double[][] A1 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        double[] b1 = new double[]{0.0, 0.0};
        double[] c1 = new double[]{0.0, 0.0, 1.0};
        double d1 = 0.0;
        SOCPLogarithmicBarrier sOCPLogarithmicBarrier = barrierFunction;
        sOCPLogarithmicBarrier.getClass();
        SOCPLogarithmicBarrier.SOCPConstraintParameters constraintParams1 = sOCPLogarithmicBarrier.new SOCPLogarithmicBarrier.SOCPConstraintParameters(A1, b1, c1, d1);
        socpConstraintParametersList.add(socpConstraintParametersList.size(), constraintParams1);
        double[][] A2 = new double[][]{{0.0, 0.0, 1.0}};
        double[] b2 = new double[]{0.0};
        double[] c2 = new double[]{0.0, 0.0, 0.0};
        double d2 = Math.sqrt(18.0);
        SOCPLogarithmicBarrier sOCPLogarithmicBarrier2 = barrierFunction;
        sOCPLogarithmicBarrier2.getClass();
        SOCPLogarithmicBarrier.SOCPConstraintParameters constraintParams2 = sOCPLogarithmicBarrier2.new SOCPLogarithmicBarrier.SOCPConstraintParameters(A2, b2, c2, d2);
        socpConstraintParametersList.add(socpConstraintParametersList.size(), constraintParams2);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        BarrierMethod opt = new BarrierMethod(barrierFunction);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)3.0, (double)sol[0], (double)1.0E-5);
        BarrierMethodTest.assertEquals((double)3.0, (double)sol[1], (double)1.0E-5);
        BarrierMethodTest.assertEquals((double)Math.sqrt(18.0), (double)sol[2], (double)1.0E-5);
    }

    public void testSOConeProgramming2D() throws Exception {
        this.log.debug((Object)"testSOConeProgramming2D");
        double[] c = new double[]{-1.0, -1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(c, 6.0);
        double[][] A = new double[][]{{0.25, -1.0}};
        double[] b = new double[]{0.0};
        ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters> socpConstraintParametersList = new ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters>();
        SOCPLogarithmicBarrier barrierFunction = new SOCPLogarithmicBarrier(socpConstraintParametersList, 2);
        double[][] A1 = new double[][]{{0.0, 1.0}};
        double[] b1 = new double[]{0.0};
        double[] c1 = new double[]{0.3333333333333333, 0.0};
        double d1 = 0.3333333333333333;
        SOCPLogarithmicBarrier sOCPLogarithmicBarrier = barrierFunction;
        sOCPLogarithmicBarrier.getClass();
        SOCPLogarithmicBarrier.SOCPConstraintParameters constraintParams1 = sOCPLogarithmicBarrier.new SOCPLogarithmicBarrier.SOCPConstraintParameters(A1, b1, c1, d1);
        socpConstraintParametersList.add(socpConstraintParametersList.size(), constraintParams1);
        double[][] A2 = new double[][]{{0.0, 1.0}};
        double[] b2 = new double[]{0.0};
        double[] c2 = new double[]{-0.5, 0.0};
        double d2 = 1.0;
        SOCPLogarithmicBarrier sOCPLogarithmicBarrier2 = barrierFunction;
        sOCPLogarithmicBarrier2.getClass();
        SOCPLogarithmicBarrier.SOCPConstraintParameters constraintParams2 = sOCPLogarithmicBarrier2.new SOCPLogarithmicBarrier.SOCPConstraintParameters(A2, b2, c2, d2);
        socpConstraintParametersList.add(socpConstraintParametersList.size(), constraintParams2);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.0, 0.0});
        or.setA(A);
        or.setB(b);
        or.setCheckProgressConditions(true);
        BarrierMethod opt = new BarrierMethod(barrierFunction);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            BarrierMethodTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        BarrierMethodTest.assertEquals((double)1.3333333333333333, (double)sol[0], (double)1.0E-7);
        BarrierMethodTest.assertEquals((double)0.3333333333333333, (double)sol[1], (double)1.0E-7);
    }
}

