/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.FloatIHistogram3D;
import hep.aida.tfloat.ref.FloatAbstractHistogram3D;
import hep.aida.tfloat.ref.FloatFixedAxis;
import hep.aida.tfloat.ref.FloatHistogram2D;
import hep.aida.tfloat.ref.FloatVariableAxis;

public class FloatHistogram3D
extends FloatAbstractHistogram3D
implements FloatIHistogram3D {
    private static final long serialVersionUID = 1L;
    private float[][][] heights;
    private float[][][] errors;
    private int[][][] entries;
    private int nEntry;
    private float sumWeight;
    private float sumWeightSquared;
    private float meanX;
    private float rmsX;
    private float meanY;
    private float rmsY;
    private float meanZ;
    private float rmsZ;

    public FloatHistogram3D(String title, float[] xEdges, float[] yEdges, float[] zEdges) {
        this(title, new FloatVariableAxis(xEdges), new FloatVariableAxis(yEdges), new FloatVariableAxis(zEdges));
    }

    public FloatHistogram3D(String title, int xBins, float xMin, float xMax, int yBins, float yMin, float yMax, int zBins, float zMin, float zMax) {
        this(title, new FloatFixedAxis(xBins, xMin, xMax), new FloatFixedAxis(yBins, yMin, yMax), new FloatFixedAxis(zBins, zMin, zMax));
    }

    public FloatHistogram3D(String title, FloatIAxis xAxis, FloatIAxis yAxis, FloatIAxis zAxis) {
        super(title);
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        int xBins = xAxis.bins();
        int yBins = yAxis.bins();
        int zBins = zAxis.bins();
        this.entries = new int[xBins + 2][yBins + 2][zBins + 2];
        this.heights = new float[xBins + 2][yBins + 2][zBins + 2];
        this.errors = new float[xBins + 2][yBins + 2][zBins + 2];
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int indexX, int indexY, int indexZ) {
        return this.entries[this.mapX(indexX)][this.mapY(indexY)][this.mapZ(indexZ)];
    }

    @Override
    public float binError(int indexX, int indexY, int indexZ) {
        return (float)Math.sqrt(this.errors[this.mapX(indexX)][this.mapY(indexY)][this.mapZ(indexZ)]);
    }

    @Override
    public float binHeight(int indexX, int indexY, int indexZ) {
        return this.heights[this.mapX(indexX)][this.mapY(indexY)][this.mapZ(indexZ)];
    }

    @Override
    public float equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(float x, float y, float z) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int zBin = this.mapZ(this.zAxis.coordToIndex(z));
        int[] nArray = this.entries[xBin][yBin];
        int n = zBin;
        nArray[n] = nArray[n] + 1;
        float[] fArray = this.heights[xBin][yBin];
        int n2 = zBin;
        fArray[n2] = fArray[n2] + 1.0f;
        float[] fArray2 = this.errors[xBin][yBin];
        int n3 = zBin;
        fArray2[n3] = fArray2[n3] + 1.0f;
        ++this.nEntry;
        this.sumWeight += 1.0f;
        this.sumWeightSquared += 1.0f;
        this.meanX += x;
        this.rmsX += x;
        this.meanY += y;
        this.rmsY += y;
        this.meanZ += z;
        this.rmsZ += z;
    }

    @Override
    public void fill(float x, float y, float z, float weight) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int zBin = this.mapZ(this.zAxis.coordToIndex(z));
        int[] nArray = this.entries[xBin][yBin];
        int n = zBin;
        nArray[n] = nArray[n] + 1;
        float[] fArray = this.heights[xBin][yBin];
        int n2 = zBin;
        fArray[n2] = fArray[n2] + weight;
        float[] fArray2 = this.errors[xBin][yBin];
        int n3 = zBin;
        fArray2[n3] = fArray2[n3] + weight * weight;
        ++this.nEntry;
        this.sumWeight += weight;
        this.sumWeightSquared += weight * weight;
        this.meanX += x * weight;
        this.rmsX += x * weight * weight;
        this.meanY += y * weight;
        this.rmsY += y * weight * weight;
        this.meanZ += z * weight;
        this.rmsZ += z * weight * weight;
    }

    @Override
    protected FloatIHistogram2D internalSliceXY(String title, int indexZ1, int indexZ2) {
        if (indexZ2 < indexZ1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int xBins = this.xAxis.bins() + 2;
        int yBins = this.yAxis.bins() + 2;
        int[][] sliceEntries = new int[xBins][yBins];
        float[][] sliceHeights = new float[xBins][yBins];
        float[][] sliceErrors = new float[xBins][yBins];
        for (int i = 0; i < xBins; ++i) {
            for (int j = 0; j < yBins; ++j) {
                for (int k = indexZ1; k <= indexZ2; ++k) {
                    int[] nArray = sliceEntries[i];
                    int n = j;
                    nArray[n] = nArray[n] + this.entries[i][j][k];
                    float[] fArray = sliceHeights[i];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + this.heights[i][j][k];
                    float[] fArray2 = sliceErrors[i];
                    int n3 = j;
                    fArray2[n3] = fArray2[n3] + this.errors[i][j][k];
                }
            }
        }
        FloatHistogram2D result = new FloatHistogram2D(title, this.xAxis, this.yAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    @Override
    protected FloatIHistogram2D internalSliceXZ(String title, int indexY1, int indexY2) {
        if (indexY2 < indexY1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int xBins = this.xAxis.bins() + 2;
        int zBins = this.zAxis.bins() + 2;
        int[][] sliceEntries = new int[xBins][zBins];
        float[][] sliceHeights = new float[xBins][zBins];
        float[][] sliceErrors = new float[xBins][zBins];
        for (int i = 0; i < xBins; ++i) {
            for (int j = indexY1; j <= indexY2; ++j) {
                int k = 0;
                while (i < zBins) {
                    int[] nArray = sliceEntries[i];
                    int n = k;
                    nArray[n] = nArray[n] + this.entries[i][j][k];
                    float[] fArray = sliceHeights[i];
                    int n2 = k;
                    fArray[n2] = fArray[n2] + this.heights[i][j][k];
                    float[] fArray2 = sliceErrors[i];
                    int n3 = k;
                    fArray2[n3] = fArray2[n3] + this.errors[i][j][k];
                    ++k;
                }
            }
        }
        FloatHistogram2D result = new FloatHistogram2D(title, this.xAxis, this.zAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    @Override
    protected FloatIHistogram2D internalSliceYZ(String title, int indexX1, int indexX2) {
        if (indexX2 < indexX1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int yBins = this.yAxis.bins() + 2;
        int zBins = this.zAxis.bins() + 2;
        int[][] sliceEntries = new int[yBins][zBins];
        float[][] sliceHeights = new float[yBins][zBins];
        float[][] sliceErrors = new float[yBins][zBins];
        for (int i = indexX1; i <= indexX2; ++i) {
            for (int j = 0; j < yBins; ++j) {
                for (int k = 0; k < zBins; ++k) {
                    int[] nArray = sliceEntries[j];
                    int n = k;
                    nArray[n] = nArray[n] + this.entries[i][j][k];
                    float[] fArray = sliceHeights[j];
                    int n2 = k;
                    fArray[n2] = fArray[n2] + this.heights[i][j][k];
                    float[] fArray2 = sliceErrors[j];
                    int n3 = k;
                    fArray2[n3] = fArray2[n3] + this.errors[i][j][k];
                }
            }
        }
        FloatHistogram2D result = new FloatHistogram2D(title, this.yAxis, this.zAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    @Override
    public float meanX() {
        return this.meanX / this.sumWeight;
    }

    @Override
    public float meanY() {
        return this.meanY / this.sumWeight;
    }

    @Override
    public float meanZ() {
        return this.meanZ / this.sumWeight;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                int k = 0;
                while (j < this.entries[0][0].length) {
                    this.entries[i][j][k] = 0;
                    this.heights[i][j][k] = 0.0f;
                    this.errors[i][j][k] = 0.0f;
                    ++k;
                }
            }
        }
        this.nEntry = 0;
        this.sumWeight = 0.0f;
        this.sumWeightSquared = 0.0f;
        this.meanX = 0.0f;
        this.rmsX = 0.0f;
        this.meanY = 0.0f;
        this.rmsY = 0.0f;
        this.meanZ = 0.0f;
        this.rmsZ = 0.0f;
    }

    @Override
    public float rmsX() {
        return (float)Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    @Override
    public float rmsY() {
        return (float)Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    @Override
    public float rmsZ() {
        return (float)Math.sqrt(this.rmsZ / this.sumWeight - this.meanZ * this.meanZ / this.sumWeight / this.sumWeight);
    }

    @Override
    public float sumAllBinHeights() {
        return this.sumWeight;
    }
}

