/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.stat.Buffer;
import cern.jet.stat.tdouble.DoubleDescriptive;

public class DoubleBuffer
extends Buffer {
    private static final long serialVersionUID = 1L;
    protected DoubleArrayList values = new DoubleArrayList(0);
    protected boolean isSorted = false;

    public DoubleBuffer(int k) {
        super(k);
    }

    public void add(double value) {
        if (!this.isAllocated) {
            this.allocate();
        }
        this.values.add(value);
        this.isSorted = false;
    }

    public void addAllOfFromTo(DoubleArrayList elements, int from, int to) {
        if (!this.isAllocated) {
            this.allocate();
        }
        this.values.addAllOfFromTo(elements, from, to);
        this.isSorted = false;
    }

    protected void allocate() {
        this.isAllocated = true;
        this.values.ensureCapacity(this.k);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Object clone() {
        DoubleBuffer copy = (DoubleBuffer)super.clone();
        if (this.values != null) {
            copy.values = copy.values.copy();
        }
        return copy;
    }

    public boolean contains(double element) {
        this.sort();
        return this.values.contains(element);
    }

    @Override
    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    @Override
    public boolean isFull() {
        return this.values.size() == this.k;
    }

    public int memory() {
        return this.values.elements().length;
    }

    public double rank(double element) {
        this.sort();
        return DoubleDescriptive.rankInterpolated(this.values, element);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void sort() {
        if (!this.isSorted) {
            this.values.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        return "k=" + this.k + ", w=" + Long.toString(this.weight()) + ", l=" + Integer.toString(this.level()) + ", size=" + this.values.size();
    }
}

