/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat;

import cern.jet.random.tfloat.AbstractContinousFloatDistribution;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.engine.FloatRandomEngine;

public class FloatUniform
extends AbstractContinousFloatDistribution {
    private static final long serialVersionUID = 1L;
    protected float min;
    protected float max;
    protected static FloatUniform shared = new FloatUniform(FloatUniform.makeDefaultGenerator());

    public FloatUniform(float min, float max, int seed) {
        this(min, max, new FloatMersenneTwister(seed));
    }

    public FloatUniform(float min, float max, FloatRandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(min, max);
    }

    public FloatUniform(FloatRandomEngine randomGenerator) {
        this(0.0f, 1.0f, randomGenerator);
    }

    public float cdf(float x) {
        if (x <= this.min) {
            return 0.0f;
        }
        if (x >= this.max) {
            return 1.0f;
        }
        return (x - this.min) / (this.max - this.min);
    }

    public boolean nextBoolean() {
        return (double)this.randomGenerator.raw() > 0.5;
    }

    @Override
    public float nextFloat() {
        return this.min + (this.max - this.min) * this.randomGenerator.raw();
    }

    public float nextFloatFromTo(float from, float to) {
        return from + (to - from) * this.randomGenerator.raw();
    }

    @Override
    public int nextInt() {
        return this.nextIntFromTo(Math.round(this.min), Math.round(this.max));
    }

    public int nextIntFromTo(int from, int to) {
        return (int)((long)from + (long)((float)(1L + (long)to - (long)from) * this.randomGenerator.raw()));
    }

    public long nextLongFromTo(long from, long to) {
        long random;
        if (from >= 0L && to < Long.MAX_VALUE) {
            return from + (long)this.nextFloatFromTo(0.0f, to - from + 1L);
        }
        float diff = (float)to - (float)from + 1.0f;
        if (diff <= 9.223372E18f) {
            return from + (long)this.nextFloatFromTo(0.0f, diff);
        }
        if (from == Long.MIN_VALUE) {
            if (to == Long.MAX_VALUE) {
                int i1 = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                int i2 = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                return ((long)i1 & 0xFFFFFFFFL) << 32 | (long)i2 & 0xFFFFFFFFL;
            }
            random = Math.round(this.nextFloatFromTo(from, to + 1L));
            if (random > to) {
                random = from;
            }
        } else {
            random = Math.round(this.nextFloatFromTo(from - 1L, to));
            if (random < from) {
                random = to;
            }
        }
        return random;
    }

    public float pdf(float x) {
        if (x <= this.min || x >= this.max) {
            return 0.0f;
        }
        return (float)(1.0 / (double)(this.max - this.min));
    }

    public void setState(float min, float max) {
        if (max < min) {
            this.setState(max, min);
            return;
        }
        this.min = min;
        this.max = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean staticNextBoolean() {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float staticNextFloat() {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextFloat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float staticNextFloatFromTo(float from, float to) {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextFloatFromTo(from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextIntFromTo(int from, int to) {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextIntFromTo(from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long staticNextLongFromTo(long from, long to) {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextLongFromTo(from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticSetRandomEngine(FloatRandomEngine randomGenerator) {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            shared.setRandomGenerator(randomGenerator);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.min + "," + this.max + ")";
    }
}

