/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat;

import cern.colt.PersistentObject;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tint.IntFunction;
import cern.jet.random.tfloat.engine.FloatRandomEngine;

public abstract class AbstractFloatDistribution
extends PersistentObject
implements FloatFunction,
IntFunction {
    private static final long serialVersionUID = 1L;
    protected FloatRandomEngine randomGenerator;

    protected AbstractFloatDistribution() {
    }

    @Override
    public float apply(float dummy) {
        return this.nextFloat();
    }

    @Override
    public int apply(int dummy) {
        return this.nextInt();
    }

    @Override
    public Object clone() {
        AbstractFloatDistribution copy = (AbstractFloatDistribution)super.clone();
        if (this.randomGenerator != null) {
            copy.randomGenerator = (FloatRandomEngine)this.randomGenerator.clone();
        }
        return copy;
    }

    protected FloatRandomEngine getRandomGenerator() {
        return this.randomGenerator;
    }

    public static FloatRandomEngine makeDefaultGenerator() {
        return FloatRandomEngine.makeDefault();
    }

    public abstract float nextFloat();

    public int nextInt() {
        return Math.round(this.nextFloat());
    }

    protected void setRandomGenerator(FloatRandomEngine randomGenerator) {
        this.randomGenerator = randomGenerator;
    }
}

