/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tlong;

import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongLongProcedure;
import cern.colt.function.tlong.LongProcedure;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import java.util.Date;

public class LongFunctions {
    public static final LongFunctions longFunctions = new LongFunctions();
    public static final LongFunction abs = new LongFunction(){

        @Override
        public final long apply(long a) {
            return a < 0L ? -a : a;
        }
    };
    public static final LongFunction dec = new LongFunction(){

        @Override
        public final long apply(long a) {
            return a--;
        }
    };
    public static final LongFunction factorial = new LongFunction(){

        @Override
        public final long apply(long a) {
            return (long)DoubleArithmetic.factorial(a);
        }
    };
    public static final LongFunction identity = new LongFunction(){

        @Override
        public final long apply(long a) {
            return a;
        }
    };
    public static final LongFunction inc = new LongFunction(){

        @Override
        public final long apply(long a) {
            return a++;
        }
    };
    public static final LongFunction neg = new LongFunction(){

        @Override
        public final long apply(long a) {
            return -a;
        }
    };
    public static final LongFunction not = new LongFunction(){

        @Override
        public final long apply(long a) {
            return a ^ 0xFFFFFFFFFFFFFFFFL;
        }
    };
    public static final LongFunction sign = new LongFunction(){

        @Override
        public final long apply(long a) {
            return a < 0L ? -1L : (a > 0L ? 1L : 0L);
        }
    };
    public static final LongFunction square = new LongFunction(){

        @Override
        public final long apply(long a) {
            return a * a;
        }
    };
    public static final LongLongFunction and = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a & b;
        }
    };
    public static final LongLongFunction compare = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a < b ? -1L : (a > b ? 1L : 0L);
        }
    };
    public static final LongLongFunction div = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a / b;
        }
    };
    public static final LongLongFunction divNeg = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return -(a / b);
        }
    };
    public static final LongLongFunction equals = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a == b ? 1L : 0L;
        }
    };
    public static final LongLongProcedure isEqual = new LongLongProcedure(){

        @Override
        public final boolean apply(long a, long b) {
            return a == b;
        }
    };
    public static final LongLongProcedure isLess = new LongLongProcedure(){

        @Override
        public final boolean apply(long a, long b) {
            return a < b;
        }
    };
    public static final LongLongProcedure isGreater = new LongLongProcedure(){

        @Override
        public final boolean apply(long a, long b) {
            return a > b;
        }
    };
    public static final LongLongFunction max = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a >= b ? a : b;
        }
    };
    public static final LongLongFunction min = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a <= b ? a : b;
        }
    };
    public static final LongLongFunction minus = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a - b;
        }
    };
    public static final LongLongFunction mod = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a % b;
        }
    };
    public static final LongLongFunction mult = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a * b;
        }
    };
    public static final LongLongFunction multNeg = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return -(a * b);
        }
    };
    public static final LongLongFunction multSquare = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a * b * b;
        }
    };
    public static final LongLongFunction or = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a | b;
        }
    };
    public static final LongLongFunction plus = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a + b;
        }
    };
    public static final LongLongFunction plusAbs = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return Math.abs(a) + Math.abs(b);
        }
    };
    public static final LongLongFunction pow = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return (long)Math.pow(a, b);
        }
    };
    public static final LongLongFunction shiftLeft = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a << (int)b;
        }
    };
    public static final LongLongFunction shiftRightSigned = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a >> (int)b;
        }
    };
    public static final LongLongFunction shiftRightUnsigned = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a >>> (int)b;
        }
    };
    public static final LongLongFunction xor = new LongLongFunction(){

        @Override
        public final long apply(long a, long b) {
            return a ^ b;
        }
    };

    protected LongFunctions() {
    }

    public static LongFunction and(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a & b;
            }
        };
    }

    public static LongFunction between(final long from, final long to) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return from <= a && a <= to ? 1L : 0L;
            }
        };
    }

    public static LongFunction bindArg1(final LongLongFunction function, final long c) {
        return new LongFunction(){

            @Override
            public final long apply(long var) {
                return function.apply(c, var);
            }
        };
    }

    public static LongFunction bindArg2(final LongLongFunction function, final long c) {
        return new LongFunction(){

            @Override
            public final long apply(long var) {
                return function.apply(var, c);
            }
        };
    }

    public static LongFunction chain(final LongFunction g, final LongFunction h) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return g.apply(h.apply(a));
            }
        };
    }

    public static LongLongFunction chain(final LongFunction g, final LongLongFunction h) {
        return new LongLongFunction(){

            @Override
            public final long apply(long a, long b) {
                return g.apply(h.apply(a, b));
            }
        };
    }

    public static LongLongFunction chain(final LongLongFunction f, final LongFunction g, final LongFunction h) {
        return new LongLongFunction(){

            @Override
            public final long apply(long a, long b) {
                return f.apply(g.apply(a), h.apply(b));
            }
        };
    }

    public static LongFunction compare(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a < b ? -1L : (a > b ? 1L : 0L);
            }
        };
    }

    public static LongFunction constant(final long c) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return c;
            }
        };
    }

    public static LongFunction div(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a / b;
            }
        };
    }

    public static LongFunction equals(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a == b ? 1L : 0L;
            }
        };
    }

    public static LongProcedure isBetween(final long from, final long to) {
        return new LongProcedure(){

            @Override
            public final boolean apply(long a) {
                return from <= a && a <= to;
            }
        };
    }

    public static LongProcedure isEqual(final long b) {
        return new LongProcedure(){

            @Override
            public final boolean apply(long a) {
                return a == b;
            }
        };
    }

    public static LongProcedure isGreater(final long b) {
        return new LongProcedure(){

            @Override
            public final boolean apply(long a) {
                return a > b;
            }
        };
    }

    public static LongProcedure isLess(final long b) {
        return new LongProcedure(){

            @Override
            public final boolean apply(long a) {
                return a < b;
            }
        };
    }

    public static LongFunction max(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a >= b ? a : b;
            }
        };
    }

    public static LongFunction min(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a <= b ? a : b;
            }
        };
    }

    public static LongFunction minus(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a - b;
            }
        };
    }

    public static LongLongFunction minusMult(long constant) {
        return LongFunctions.plusMultSecond(-constant);
    }

    public static LongFunction mod(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a % b;
            }
        };
    }

    public static LongFunction mult(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a * b;
            }
        };
    }

    public static LongFunction or(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a | b;
            }
        };
    }

    public static LongFunction plus(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a + b;
            }
        };
    }

    public static LongLongFunction multSecond(final long constant) {
        return new LongLongFunction(){

            @Override
            public final long apply(long a, long b) {
                return b * constant;
            }
        };
    }

    public static LongFunction pow(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return (long)Math.pow(a, b);
            }
        };
    }

    public static LongLongFunction plusMultSecond(long constant) {
        return new LongPlusMultSecond(constant);
    }

    public static LongLongFunction plusMultFirst(long constant) {
        return new LongPlusMultFirst(constant);
    }

    public static LongFunction random() {
        return new DoubleMersenneTwister(new Date());
    }

    public static LongFunction shiftLeft(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a << (int)b;
            }
        };
    }

    public static LongFunction shiftRightSigned(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a >> (int)b;
            }
        };
    }

    public static LongFunction shiftRightUnsigned(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a >>> (int)b;
            }
        };
    }

    public static LongLongFunction swapArgs(final LongLongFunction function) {
        return new LongLongFunction(){

            @Override
            public final long apply(long a, long b) {
                return function.apply(b, a);
            }
        };
    }

    public static LongFunction xor(final long b) {
        return new LongFunction(){

            @Override
            public final long apply(long a) {
                return a ^ b;
            }
        };
    }
}

