/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix1DProcedure;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.algo.ObjectSorting;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class ObjectMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected ObjectMatrix2D() {
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f) {
        if (this.size() == 0L) {
            return null;
        }
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < ObjectMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(ObjectMatrix2D.this.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, final ObjectProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object elem = ObjectMatrix2D.this.getQuick(firstRow, 0);
                        Object a = 0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < ObjectMatrix2D.this.columns; ++c) {
                                elem = ObjectMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            Object elem = this.getQuick(0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix2D.this.getQuick(rowElements[firstIdx], columnElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            Object elem = ObjectMatrix2D.this.getQuick(rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(rowElements[0], columnElements[0]));
            for (int i = 1; i < size; ++i) {
                Object elem = this.getQuick(rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public Object aggregate(final ObjectMatrix2D other, final ObjectObjectFunction aggr, final ObjectObjectFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            return null;
        }
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < ObjectMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(ObjectMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public ObjectMatrix2D assign(final Object[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            Object[] currentRow = values[r];
                            if (currentRow.length != ObjectMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + ObjectMatrix2D.this.columns());
                            }
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                ObjectMatrix2D.this.setQuick(r, c, currentRow[c]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                Object[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, currentRow[c]);
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                ObjectMatrix2D.this.setQuick(r, c, function.apply(ObjectMatrix2D.this.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure cond, final ObjectFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                Object elem = ObjectMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                ObjectMatrix2D.this.setQuick(r, c, f.apply(elem));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    Object elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, f.apply(elem));
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure cond, final Object value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                Object elem = ObjectMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                ObjectMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    Object elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * ObjectMatrix2D.this.columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                ObjectMatrix2D.this.setQuick(r, c, values[idx++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, values[idx++]);
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final ObjectMatrix2D other_loc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                ObjectMatrix2D.this.setQuick(r, c, other_loc.getQuick(r, c));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, other_loc.getQuick(r, c));
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectMatrix2D y, final ObjectObjectFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                ObjectMatrix2D.this.setQuick(r, c, function.apply(ObjectMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c), y.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectMatrix2D y, final ObjectObjectFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            ObjectMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(ObjectMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                ObjectMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                if (ObjectMatrix2D.this.getQuick(r, c) == null) continue;
                                ++cardinality;
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    if (this.getQuick(r, c) == null) continue;
                    ++cardinality;
                }
            }
        }
        return cardinality;
    }

    public ObjectMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(Object otherObj) {
        return this.equals(otherObj, true);
    }

    public boolean equals(Object otherObj, boolean testForEquality) {
        if (!(otherObj instanceof ObjectMatrix2D)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ObjectMatrix2D other = (ObjectMatrix2D)otherObj;
        if (this.rows != other.rows()) {
            return false;
        }
        if (this.columns != other.columns()) {
            return false;
        }
        if (!testForEquality) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (this.getQuick(row, column) == other.getQuick(row, column)) continue;
                    return false;
                }
            }
        } else {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (this.getQuick(row, column) != null ? this.getQuick(row, column).equals(other.getQuick(row, column)) : other.getQuick(row, column) == null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public ObjectMatrix2D forEachNonZero(final IntIntObjectFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                Object a;
                                Object value = ObjectMatrix2D.this.getQuick(r, c);
                                if (value == null || (a = function.apply(r, c, value)) == value) continue;
                                ObjectMatrix2D.this.setQuick(r, c, a);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    Object a;
                    Object value = this.getQuick(r, c);
                    if (value == null || (a = function.apply(r, c, value)) == value) continue;
                    this.setQuick(r, c, a);
                }
            }
        }
        return this;
    }

    public Object get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ObjectArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = this.rows;
        int c = this.columns;
        for (int row = 0; row < r; ++row) {
            for (int column = 0; column < c; ++column) {
                Object value = this.getQuick(row, column);
                if (value == null) continue;
                rowList.add(row);
                columnList.add(column);
                valueList.add(value);
            }
        }
    }

    public abstract Object getQuick(int var1, int var2);

    protected boolean haveSharedCells(ObjectMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        return false;
    }

    public ObjectMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract ObjectMatrix2D like(int var1, int var2);

    public abstract ObjectMatrix1D like1D(int var1);

    protected abstract ObjectMatrix1D like1D(int var1, int var2, int var3);

    public void set(int row, int column, Object value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, Object var3);

    public Object[][] toArray() {
        final Object[][] values = new Object[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            Object[] currentRow = values[r];
                            for (int c = 0; c < ObjectMatrix2D.this.columns; ++c) {
                                currentRow[c] = ObjectMatrix2D.this.getQuick(r, c);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                Object[] currentRow = values[r];
                for (int c = 0; c < this.columns; ++c) {
                    currentRow[c] = this.getQuick(r, c);
                }
            }
        }
        return values;
    }

    public String toString() {
        return new ObjectFormatter().toString(this);
    }

    public abstract ObjectMatrix1D vectorize();

    protected ObjectMatrix2D view() {
        return (ObjectMatrix2D)this.clone();
    }

    public ObjectMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public ObjectMatrix2D viewColumnFlip() {
        return (ObjectMatrix2D)this.view().vColumnFlip();
    }

    public ObjectMatrix2D viewDice() {
        return (ObjectMatrix2D)this.view().vDice();
    }

    public ObjectMatrix2D viewPart(int row, int column, int height, int width) {
        return (ObjectMatrix2D)this.view().vPart(row, column, height, width);
    }

    public ObjectMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public ObjectMatrix2D viewRowFlip() {
        return (ObjectMatrix2D)this.view().vRowFlip();
    }

    public ObjectMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = rowIndexes.length;
        while (--i2 >= 0) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
        }
        i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public ObjectMatrix2D viewSelection(ObjectMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!condition.apply(this.viewRow(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    protected abstract ObjectMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public ObjectMatrix2D viewSorted(int column) {
        return ObjectSorting.mergeSort.sort(this, column);
    }

    public ObjectMatrix2D viewStrides(int rowStride, int columnStride) {
        return (ObjectMatrix2D)this.view().vStrides(rowStride, columnStride);
    }
}

