/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.algo.ObjectSorting;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public abstract class ObjectMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected ObjectMatrix1D() {
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f) {
        if (this.size == 0) {
            return null;
        }
        Object a = f.apply(this.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix1D.this.getQuick(firstIdx));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(ObjectMatrix1D.this.getQuick(i)));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.getQuick(i)));
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix1D.this.getQuick(indexElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            Object elem = ObjectMatrix1D.this.getQuick(indexElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(indexElements[0]));
            for (int i = 1; i < size; ++i) {
                Object elem = this.getQuick(indexElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public Object aggregate(final ObjectMatrix1D other, final ObjectObjectFunction aggr, final ObjectObjectFunction f) {
        this.checkSize(other);
        if (this.size == 0) {
            return null;
        }
        Object a = f.apply(this.getQuick(0), other.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix1D.this.getQuick(firstIdx), other.getQuick(firstIdx));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(ObjectMatrix1D.this.getQuick(i), other.getQuick(i)));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
            }
        }
        return a;
    }

    public ObjectMatrix1D assign(final Object[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + ", size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            ObjectMatrix1D.this.setQuick(i, values[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, values[i]);
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(final ObjectFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            ObjectMatrix1D.this.setQuick(i, function.apply(ObjectMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, function.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        final ObjectMatrix1D other_loc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            ObjectMatrix1D.this.setQuick(i, other_loc.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, other_loc.getQuick(i));
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(final ObjectMatrix1D y, final ObjectObjectFunction function) {
        this.checkSize(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            ObjectMatrix1D.this.setQuick(i, function.apply(ObjectMatrix1D.this.getQuick(i), y.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, function.apply(this.getQuick(i), y.getQuick(i)));
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(final Object value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            ObjectMatrix1D.this.setQuick(i, value);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, value);
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0) {
            if (this.getQuick(i) == null) continue;
            ++cardinality;
        }
        return cardinality;
    }

    public ObjectMatrix1D copy() {
        ObjectMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public abstract Object elements();

    public boolean equals(Object otherObj) {
        return this.equals(otherObj, true);
    }

    public boolean equals(Object otherObj, boolean testForEquality) {
        if (!(otherObj instanceof ObjectMatrix1D)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ObjectMatrix1D other = (ObjectMatrix1D)otherObj;
        if ((long)this.size != other.size()) {
            return false;
        }
        if (!testForEquality) {
            int i = this.size;
            while (--i >= 0) {
                if (this.getQuick(i) == other.getQuick(i)) continue;
                return false;
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (this.getQuick(i) != null ? this.getQuick(i).equals(other.getQuick(i)) : other.getQuick(i) == null) continue;
                return false;
            }
        }
        return true;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    protected ObjectMatrix1D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList indexList, ObjectArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int s = this.size;
        for (int i = 0; i < s; ++i) {
            Object value = this.getQuick(i);
            if (value == null) continue;
            if (fillIndexList) {
                indexList.add(i);
            }
            if (!fillValueList) continue;
            valueList.add(value);
        }
    }

    public abstract Object getQuick(int var1);

    protected boolean haveSharedCells(ObjectMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D other) {
        return false;
    }

    public ObjectMatrix1D like() {
        return this.like(this.size);
    }

    public abstract ObjectMatrix1D like(int var1);

    public abstract ObjectMatrix2D like2D(int var1, int var2);

    public abstract ObjectMatrix2D reshape(int var1, int var2);

    public abstract ObjectMatrix3D reshape(int var1, int var2, int var3);

    public void set(int index, Object value) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public abstract void setQuick(int var1, Object var2);

    public void swap(final ObjectMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            Object tmp = ObjectMatrix1D.this.getQuick(i);
                            ObjectMatrix1D.this.setQuick(i, other.getQuick(i));
                            other.setQuick(i, tmp);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                Object tmp = this.getQuick(i);
                this.setQuick(i, other.getQuick(i));
                other.setQuick(i, tmp);
            }
        }
    }

    public Object[] toArray() {
        Object[] values = new Object[this.size];
        this.toArray(values);
        return values;
    }

    public void toArray(final Object[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values[i] = ObjectMatrix1D.this.getQuick(i);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                values[i] = this.getQuick(i);
            }
        }
    }

    public String toString() {
        return new ObjectFormatter().toString(this);
    }

    protected ObjectMatrix1D view() {
        return (ObjectMatrix1D)this.clone();
    }

    public ObjectMatrix1D viewFlip() {
        return (ObjectMatrix1D)this.view().vFlip();
    }

    public ObjectMatrix1D viewPart(int index, int width) {
        return (ObjectMatrix1D)this.view().vPart(index, width);
    }

    public ObjectMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        int i = indexes.length;
        while (--i >= 0) {
            offsets[i] = (int)this.index(indexes[i]);
        }
        return this.viewSelectionLike(offsets);
    }

    public ObjectMatrix1D viewSelection(ObjectProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!condition.apply(this.getQuick(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    protected abstract ObjectMatrix1D viewSelectionLike(int[] var1);

    public ObjectMatrix1D viewSorted() {
        return ObjectSorting.mergeSort.sort(this);
    }

    public ObjectMatrix1D viewStrides(int stride) {
        return (ObjectMatrix1D)this.view().vStrides(stride);
    }
}

