/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.LongLongFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DelegateLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DiagonalLongMatrix2D;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected LongMatrix2D content;

    public WrapperLongMatrix2D(LongMatrix2D newContent) {
        block3: {
            if (newContent != null) {
                try {
                    this.setUp(newContent.rows(), newContent.columns());
                }
                catch (IllegalArgumentException exc) {
                    if ("matrix too large".equals(exc.getMessage())) break block3;
                    throw exc;
                }
            }
        }
        this.content = newContent;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D y, LongLongFunction function) {
        this.checkShape(y);
        if (y instanceof WrapperLongMatrix2D) {
            IntArrayList rowList = new IntArrayList();
            IntArrayList columnList = new IntArrayList();
            LongArrayList valueList = new LongArrayList();
            y.getNonZeros(rowList, columnList, valueList);
            this.assign(y, function, rowList, columnList);
        } else {
            super.assign(y, function);
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(final int[] values) {
        if (this.content instanceof DiagonalLongMatrix2D) {
            int dlength = ((DiagonalLongMatrix2D)this.content).dlength;
            final long[] elems = ((DiagonalLongMatrix2D)this.content).elements;
            if (values.length != dlength) {
                throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + dlength);
            }
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, dlength);
                Future[] futures = new Future[nthreads];
                int k = dlength / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                elems[i] = values[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < dlength; ++i) {
                    elems[i] = values[i];
                }
            }
            return this;
        }
        return super.assign(values);
    }

    @Override
    public LongMatrix2D assign(final long[] values) {
        if (this.content instanceof DiagonalLongMatrix2D) {
            int dlength = ((DiagonalLongMatrix2D)this.content).dlength;
            final long[] elems = ((DiagonalLongMatrix2D)this.content).elements;
            if (values.length != dlength) {
                throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + dlength);
            }
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, dlength);
                Future[] futures = new Future[nthreads];
                int k = dlength / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                elems[i] = values[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < dlength; ++i) {
                    elems[i] = values[i];
                }
            }
            return this;
        }
        return super.assign(values);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public synchronized long getQuick(int row, int column) {
        return this.content.getQuick(row, column);
    }

    @Override
    public boolean equals(long value) {
        if (this.content instanceof DiagonalLongMatrix2D) {
            long[] elements = (long[])this.content.elements();
            for (int r = 0; r < elements.length; ++r) {
                long x = elements[r];
                long diff = value - x;
                if (diff == 0L) continue;
                return false;
            }
            return true;
        }
        return super.equals(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.content instanceof DiagonalLongMatrix2D && obj instanceof DiagonalLongMatrix2D) {
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            DiagonalLongMatrix2D A = (DiagonalLongMatrix2D)this.content;
            DiagonalLongMatrix2D B = (DiagonalLongMatrix2D)obj;
            if (A.columns() != B.columns() || A.rows() != B.rows() || A.diagonalIndex() != B.diagonalIndex() || A.diagonalLength() != B.diagonalLength()) {
                return false;
            }
            long[] AElements = A.elements();
            long[] BElements = B.elements();
            for (int r = 0; r < AElements.length; ++r) {
                long value = BElements[r];
                long x = AElements[r];
                long diff = value - x;
                if (diff == 0L) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public LongMatrix1D like1D(int size) {
        return this.content.like1D(size);
    }

    @Override
    public synchronized void setQuick(int row, int column, long value) {
        this.content.setQuick(row, column, value);
    }

    @Override
    public LongMatrix1D vectorize() {
        final DenseLongMatrix1D v = new DenseLongMatrix1D((int)this.size());
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                final int firstidx = j * k * this.rows;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstidx;
                        for (int c = firstCol; c < lastCol; ++c) {
                            for (int r = 0; r < WrapperLongMatrix2D.this.rows; ++r) {
                                v.setQuick(idx++, WrapperLongMatrix2D.this.getQuick(r, c));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int c = 0; c < this.columns; ++c) {
                for (int r = 0; r < this.rows; ++r) {
                    v.setQuick(idx++, this.getQuick(r, c));
                }
            }
        }
        return v;
    }

    @Override
    public LongMatrix1D viewColumn(int column) {
        return this.viewDice().viewRow(column);
    }

    @Override
    public LongMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperLongMatrix2D view = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int row, int column) {
                return this.content.getQuick(row, this.columns - 1 - column);
            }

            @Override
            public synchronized void setQuick(int row, int column, long value) {
                this.content.setQuick(row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized long get(int row, int column) {
                return this.content.get(row, this.columns - 1 - column);
            }

            @Override
            public synchronized void set(int row, int column, long value) {
                this.content.set(row, this.columns - 1 - column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public LongMatrix2D viewDice() {
        WrapperLongMatrix2D view = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int row, int column) {
                return this.content.getQuick(column, row);
            }

            @Override
            public synchronized void setQuick(int row, int column, long value) {
                this.content.setQuick(column, row, value);
            }

            @Override
            public synchronized long get(int row, int column) {
                return this.content.get(column, row);
            }

            @Override
            public synchronized void set(int row, int column, long value) {
                this.content.set(column, row, value);
            }
        };
        view.rows = this.columns;
        view.columns = this.rows;
        view.isNoView = false;
        return view;
    }

    @Override
    public LongMatrix2D viewPart(final int row, final int column, int height, int width) {
        this.checkBox(row, column, height, width);
        WrapperLongMatrix2D view = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int i, int j) {
                return this.content.getQuick(row + i, column + j);
            }

            @Override
            public synchronized void setQuick(int i, int j, long value) {
                this.content.setQuick(row + i, column + j, value);
            }

            @Override
            public synchronized long get(int i, int j) {
                return this.content.get(row + i, column + j);
            }

            @Override
            public synchronized void set(int i, int j, long value) {
                this.content.set(row + i, column + j, value);
            }
        };
        view.rows = height;
        view.columns = width;
        view.isNoView = false;
        return view;
    }

    @Override
    public LongMatrix1D viewRow(int row) {
        this.checkRow(row);
        return new DelegateLongMatrix1D(this, row);
    }

    @Override
    public LongMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperLongMatrix2D view = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int row, int column) {
                return this.content.getQuick(this.rows - 1 - row, column);
            }

            @Override
            public synchronized void setQuick(int row, int column, long value) {
                this.content.setQuick(this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized long get(int row, int column) {
                return this.content.get(this.rows - 1 - row, column);
            }

            @Override
            public synchronized void set(int row, int column, long value) {
                this.content.set(this.rows - 1 - row, column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public LongMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperLongMatrix2D view = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int i, int j) {
                return this.content.getQuick(rix[i], cix[j]);
            }

            @Override
            public synchronized void setQuick(int i, int j, long value) {
                this.content.setQuick(rix[i], cix[j], value);
            }

            @Override
            public synchronized long get(int i, int j) {
                return this.content.get(rix[i], cix[j]);
            }

            @Override
            public synchronized void set(int i, int j, long value) {
                this.content.set(rix[i], cix[j], value);
            }
        };
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        view.isNoView = false;
        return view;
    }

    @Override
    public LongMatrix2D viewStrides(final int _rowStride, final int _columnStride) {
        if (_rowStride <= 0 || _columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperLongMatrix2D view = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int row, int column) {
                return this.content.getQuick(_rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void setQuick(int row, int column, long value) {
                this.content.setQuick(_rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized long get(int row, int column) {
                return this.content.get(_rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void set(int row, int column, long value) {
                this.content.set(_rowStride * row, _columnStride * column, value);
            }
        };
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / _rowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / _columnStride + 1;
        }
        view.isNoView = false;
        return view;
    }

    @Override
    protected LongMatrix2D getContent() {
        return this.content;
    }

    @Override
    protected LongMatrix1D like1D(int size, int offset, int stride) {
        throw new InternalError();
    }

    @Override
    protected LongMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }
}

