/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;

public class SparseCCMLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseLongMatrix1D[] elements;

    public SparseCCMLongMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseLongMatrix1D[columns];
        for (int i = 0; i < columns; ++i) {
            this.elements[i] = new SparseLongMatrix1D(rows);
        }
    }

    public SparseLongMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public long getQuick(int row, int column) {
        return this.elements[column].getQuick(row);
    }

    @Override
    public void setQuick(int row, int column, long value) {
        this.elements[column].setQuick(row, value);
    }

    @Override
    public void trimToSize() {
        for (int c = 0; c < this.columns; ++c) {
            this.elements[c].trimToSize();
        }
    }

    @Override
    public SparseLongMatrix1D viewColumn(int column) {
        return this.elements[column];
    }

    @Override
    protected LongMatrix2D getContent() {
        return this;
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new SparseCCMLongMatrix2D(rows, columns);
    }
}

