/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedSparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;

class SelectedSparseLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseLongMatrix2D(AbstractLongLongMap elements, int[] rowOffsets, int[] columnOffsets, int offset) {
        this(rowOffsets.length, columnOffsets.length, elements, 0, 0, 1, 1, rowOffsets, columnOffsets, offset);
    }

    protected SelectedSparseLongMatrix2D(int rows, int columns, AbstractLongLongMap elements, int rowZero, int columnZero, int rowStride, int columnStride, int[] rowOffsets, int[] columnOffsets, int offset) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    public AbstractLongLongMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public long getQuick(int row, int column) {
        return this.elements.get((long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride]);
    }

    @Override
    public long index(int row, int column) {
        return (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new SparseLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix1D like1D(int size) {
        return new SparseLongMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, long value) {
        long index = (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
        if (value == 0L) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public LongMatrix1D vectorize() {
        SparseLongMatrix1D v = new SparseLongMatrix1D((int)this.size());
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.setQuick(idx++, this.getQuick(c, r));
            }
        }
        return v;
    }

    @Override
    public LongMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.rowZero;
        int viewStride = this.rowStride;
        int[] viewOffsets = this.rowOffsets;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        return new SelectedSparseLongMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    public LongMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.columnZero;
        int viewStride = this.columnStride;
        int[] viewOffsets = this.columnOffsets;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        return new SelectedSparseLongMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    @Override
    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    @Override
    protected boolean haveSharedCellsRaw(LongMatrix2D other) {
        if (other instanceof SelectedSparseLongMatrix2D) {
            SelectedSparseLongMatrix2D otherMatrix = (SelectedSparseLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseLongMatrix2D) {
            SparseLongMatrix2D otherMatrix = (SparseLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected LongMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    @Override
    protected void setUp(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] tmp = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = tmp;
        this.isNoView = false;
        return this;
    }

    @Override
    protected LongMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseLongMatrix2D(this.elements, rowOffsets, columnOffsets, this.offset);
    }
}

