/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseLongMatrix2D
extends LongMatrix2D {
    static final long serialVersionUID = 1L;
    protected long[] elements;

    public DenseLongMatrix2D(long[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseLongMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new long[rows * columns];
    }

    public DenseLongMatrix2D(int rows, int columns, long[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseLongMatrix2D.this.elements[zero + firstRow * DenseLongMatrix2D.this.rowStride]);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseLongMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DenseLongMatrix2D.this.elements[zero + r * DenseLongMatrix2D.this.rowStride + c * DenseLongMatrix2D.this.columnStride]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.elements[zero + r * this.rowStride + c * this.columnStride]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f, final LongProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long elem = DenseLongMatrix2D.this.elements[zero + firstRow * DenseLongMatrix2D.this.rowStride];
                        long a = 0L;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseLongMatrix2D.this.columns; ++c) {
                                elem = DenseLongMatrix2D.this.elements[zero + r * DenseLongMatrix2D.this.rowStride + c * DenseLongMatrix2D.this.columnStride];
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            long elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = f.apply(this.elements[zero]);
            }
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseLongMatrix2D.this.elements[zero + rowElements[firstIdx] * DenseLongMatrix2D.this.rowStride + columnElements[firstIdx] * DenseLongMatrix2D.this.columnStride]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            long elem = DenseLongMatrix2D.this.elements[zero + rowElements[i] * DenseLongMatrix2D.this.rowStride + columnElements[i] * DenseLongMatrix2D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            for (int i = 1; i < size; ++i) {
                long elem = this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    @Override
    public long aggregate(LongMatrix2D other, final LongLongFunction aggr, final LongLongFunction f) {
        if (!(other instanceof DenseLongMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final long[] elemsOther = (long[])other.elements();
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseLongMatrix2D.this.elements[zero + firstRow * DenseLongMatrix2D.this.rowStride], elemsOther[zeroOther + firstRow * rowStrideOther]);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseLongMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DenseLongMatrix2D.this.elements[zero + r * DenseLongMatrix2D.this.rowStride + c * DenseLongMatrix2D.this.columnStride], elemsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero], elemsOther[zeroOther]);
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.elements[zero + r * this.rowStride + c * this.columnStride], elemsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public LongMatrix2D assign(final LongFunction function) {
        final long[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (function instanceof LongMult) {
                long multiplicator = ((LongMult)function).multiplicator;
                if (multiplicator == 1L) {
                    return this;
                }
                if (multiplicator == 0L) {
                    return this.assign(0L);
                }
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        if (function instanceof LongMult) {
                            long multiplicator = ((LongMult)function).multiplicator;
                            if (multiplicator == 1L) {
                                return;
                            }
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                    int n = i;
                                    elems[n] = elems[n] * multiplicator;
                                    i += DenseLongMatrix2D.this.columnStride;
                                }
                                idx += DenseLongMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                    elems[i] = function.apply(elems[i]);
                                    i += DenseLongMatrix2D.this.columnStride;
                                }
                                idx += DenseLongMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            if (function instanceof LongMult) {
                long multiplicator = ((LongMult)function).multiplicator;
                if (multiplicator == 1L) {
                    return this;
                }
                if (multiplicator == 0L) {
                    return this.assign(0L);
                }
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        int n = i;
                        elems[n] = elems[n] * multiplicator;
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        elems[i] = function.apply(elems[i]);
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(final LongProcedure cond, final LongFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                long elem = DenseLongMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseLongMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i += DenseLongMatrix2D.this.columnStride;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    long elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(final LongProcedure cond, final long value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                long elem = DenseLongMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseLongMatrix2D.this.elements[i] = value;
                                }
                                i += DenseLongMatrix2D.this.columnStride;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    long elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(final long value) {
        final long[] elems = this.elements;
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                elems[i] = value;
                                i += DenseLongMatrix2D.this.columnStride;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    elems[i] = value;
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(final long[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstRow * DenseLongMatrix2D.this.columns;
                            int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                    DenseLongMatrix2D.this.elements[i] = values[idxOther++];
                                    i += DenseLongMatrix2D.this.columnStride;
                                }
                                idx += DenseLongMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[i] = values[idxOther++];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(final int[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxOther = firstRow * DenseLongMatrix2D.this.columns;
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                DenseLongMatrix2D.this.elements[i] = values[idxOther++];
                                i += DenseLongMatrix2D.this.columnStride;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = 0;
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = values[idxOther++];
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(final long[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstRow * DenseLongMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                long[] currentRow = values[r];
                                if (currentRow.length != DenseLongMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseLongMatrix2D.this.columns());
                                }
                                System.arraycopy(currentRow, 0, DenseLongMatrix2D.this.elements, i, DenseLongMatrix2D.this.columns);
                                i += DenseLongMatrix2D.this.columns;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                for (int r = 0; r < this.rows; ++r) {
                    long[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                    i += this.columns;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                long[] currentRow = values[r];
                                if (currentRow.length != DenseLongMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseLongMatrix2D.this.columns());
                                }
                                int i = idx;
                                for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                    DenseLongMatrix2D.this.elements[i] = currentRow[c];
                                    i += DenseLongMatrix2D.this.columnStride;
                                }
                                idx += DenseLongMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero;
                for (int r = 0; r < this.rows; ++r) {
                    long[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[i] = currentRow[c];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D source) {
        if (!(source instanceof DenseLongMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseLongMatrix2D other_final = (DenseLongMatrix2D)source;
        if (other_final == this) {
            return this;
        }
        this.checkShape(other_final);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other_final.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        DenseLongMatrix2D other = (DenseLongMatrix2D)source;
        if (this.haveSharedCells(other)) {
            LongMatrix2D c = other.copy();
            if (!(c instanceof DenseLongMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseLongMatrix2D)c;
        }
        final long[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                DenseLongMatrix2D.this.elements[i] = elemsOther[j];
                                i += DenseLongMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D y, final LongLongFunction function) {
        if (!(y instanceof DenseLongMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseLongMatrix2D other = (DenseLongMatrix2D)y;
        this.checkShape(y);
        final long[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            long multiplicator;
            if (function instanceof LongPlusMultSecond && (multiplicator = ((LongPlusMultSecond)function).multiplicator) == 0L) {
                return this;
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (function == LongFunctions.mult) {
                            int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                    int n = i;
                                    DenseLongMatrix2D.this.elements[n] = DenseLongMatrix2D.this.elements[n] * elemsOther[j];
                                    i += DenseLongMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseLongMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        } else if (function == LongFunctions.div) {
                            int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                    int n = i;
                                    DenseLongMatrix2D.this.elements[n] = DenseLongMatrix2D.this.elements[n] / elemsOther[j];
                                    i += DenseLongMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseLongMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        } else if (function instanceof LongPlusMultSecond) {
                            long multiplicator = ((LongPlusMultSecond)function).multiplicator;
                            if (multiplicator == 1L) {
                                int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                for (int r = firstRow; r < lastRow; ++r) {
                                    int i = idx;
                                    int j = idxOther;
                                    for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                        int n = i;
                                        DenseLongMatrix2D.this.elements[n] = DenseLongMatrix2D.this.elements[n] + elemsOther[j];
                                        i += DenseLongMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                    }
                                    idx += DenseLongMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                }
                            } else if (multiplicator == -1L) {
                                int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                for (int r = firstRow; r < lastRow; ++r) {
                                    int i = idx;
                                    int j = idxOther;
                                    for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                        int n = i;
                                        DenseLongMatrix2D.this.elements[n] = DenseLongMatrix2D.this.elements[n] - elemsOther[j];
                                        i += DenseLongMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                    }
                                    idx += DenseLongMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                }
                            } else {
                                int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                for (int r = firstRow; r < lastRow; ++r) {
                                    int i = idx;
                                    int j = idxOther;
                                    for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                        int n = i;
                                        DenseLongMatrix2D.this.elements[n] = DenseLongMatrix2D.this.elements[n] + multiplicator * elemsOther[j];
                                        i += DenseLongMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                    }
                                    idx += DenseLongMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                }
                            }
                        } else {
                            int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                    DenseLongMatrix2D.this.elements[i] = function.apply(DenseLongMatrix2D.this.elements[i], elemsOther[j]);
                                    i += DenseLongMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseLongMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else if (function == LongFunctions.mult) {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    int n = i;
                    this.elements[n] = this.elements[n] * elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        } else if (function == LongFunctions.div) {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    int n = i;
                    this.elements[n] = this.elements[n] / elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        } else if (function instanceof LongPlusMultSecond) {
            long multiplicator = ((LongPlusMultSecond)function).multiplicator;
            if (multiplicator == 0L) {
                return this;
            }
            if (multiplicator == 1L) {
                int idx = zero;
                int idxOther = zeroOther;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        int n = i;
                        this.elements[n] = this.elements[n] + elemsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            } else if (multiplicator == -1L) {
                int idx = zero;
                int idxOther = zeroOther;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        int n = i;
                        this.elements[n] = this.elements[n] - elemsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            } else {
                int idx = zero;
                int idxOther = zeroOther;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        int n = i;
                        this.elements[n] = this.elements[n] + multiplicator * elemsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            }
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = function.apply(this.elements[i], elemsOther[j]);
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D y, final LongLongFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final long[] elemsOther = (long[])y.elements();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int idx = zero + rowElements[i] * DenseLongMatrix2D.this.rowStride + columnElements[i] * DenseLongMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseLongMatrix2D.this.elements[idx] = function.apply(DenseLongMatrix2D.this.elements[idx], elemsOther[idxOther]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Long[] results = new Long[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                if (DenseLongMatrix2D.this.elements[i] != 0L) {
                                    ++cardinality;
                                }
                                i += DenseLongMatrix2D.this.columnStride;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Long)futures[j].get();
                }
                cardinality = results[0].intValue();
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    if (this.elements[i] != 0L) {
                        ++cardinality;
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return cardinality;
    }

    public long[] elements() {
        return this.elements;
    }

    @Override
    public LongMatrix2D forEachNonZero(final IntIntLongFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                long value = DenseLongMatrix2D.this.elements[i];
                                if (value != 0L) {
                                    DenseLongMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i += DenseLongMatrix2D.this.columnStride;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    long value = this.elements[i];
                    if (value != 0L) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int r = 0; r < this.rows; ++r) {
            int i = idx;
            for (int c = 0; c < this.columns; ++c) {
                long value = this.elements[i];
                if (value < 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
            }
            idx += this.rowStride;
        }
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int r = 0; r < this.rows; ++r) {
            int i = idx;
            for (int c = 0; c < this.columns; ++c) {
                long value = this.elements[i];
                if (value != 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
            }
            idx += this.rowStride;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int r = 0; r < this.rows; ++r) {
            int i = idx;
            for (int c = 0; c < this.columns; ++c) {
                long value = this.elements[i];
                if (value > 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
            }
            idx += this.rowStride;
        }
    }

    @Override
    public long getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new DenseLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix1D like1D(int size) {
        return new DenseLongMatrix1D(size);
    }

    @Override
    public long[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        long maxValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        long maxValue = DenseLongMatrix2D.this.elements[zero + firstRow * DenseLongMatrix2D.this.rowStride];
                        int rowLocation = firstRow;
                        int colLocation = 0;
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseLongMatrix2D.this.columns; ++c) {
                                long elem = DenseLongMatrix2D.this.elements[zero + r * DenseLongMatrix2D.this.rowStride + c * DenseLongMatrix2D.this.columnStride];
                                if (maxValue >= elem) continue;
                                maxValue = elem;
                                rowLocation = r;
                                colLocation = c;
                            }
                            d = 0;
                        }
                        return new long[]{maxValue, rowLocation, colLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (long[])futures[j].get();
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (maxValue >= results[j][0]) continue;
                    maxValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    long elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (maxValue >= elem) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new long[]{maxValue, rowLocation, columnLocation};
    }

    @Override
    public long[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        long minValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        long minValue = DenseLongMatrix2D.this.elements[zero + firstRow * DenseLongMatrix2D.this.rowStride];
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseLongMatrix2D.this.columns; ++c) {
                                long elem = DenseLongMatrix2D.this.elements[zero + r * DenseLongMatrix2D.this.rowStride + c * DenseLongMatrix2D.this.columnStride];
                                if (minValue <= elem) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new long[]{minValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (long[])futures[j].get();
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (minValue <= results[j][0]) continue;
                    minValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    long elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (minValue <= elem) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new long[]{minValue, rowLocation, columnLocation};
    }

    @Override
    public void setQuick(int row, int column, long value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public long[][] toArray() {
        final long[][] values = new long[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            long[] currentRow = values[r];
                            int i = idx;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                currentRow[c] = DenseLongMatrix2D.this.elements[i];
                                i += DenseLongMatrix2D.this.columnStride;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                long[] currentRow = values[r];
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    currentRow[c] = this.elements[i];
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return values;
    }

    @Override
    public LongMatrix1D vectorize() {
        DenseLongMatrix1D v = new DenseLongMatrix1D((int)this.size());
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)v.index(0);
        final int strideOther = v.stride();
        final long[] elemsOther = v.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                final int startidx = j * k * this.rows;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = 0;
                        int idxOther = zeroOther + startidx * strideOther;
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            idx = zero + c * DenseLongMatrix2D.this.columnStride;
                            for (int r = 0; r < DenseLongMatrix2D.this.rows; ++r) {
                                elemsOther[idxOther] = DenseLongMatrix2D.this.elements[idx];
                                idx += DenseLongMatrix2D.this.rowStride;
                                idxOther += strideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int c = 0; c < this.columns; ++c) {
                idx = zero + c * this.columnStride;
                for (int r = 0; r < this.rows; ++r) {
                    elemsOther[idxOther] = this.elements[idx];
                    idx += this.rowStride;
                    idxOther += strideOther;
                }
            }
        }
        return v;
    }

    @Override
    public LongMatrix1D zMult(LongMatrix1D y, LongMatrix1D z, final long alpha, final long beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        if (z == null) {
            z = new DenseLongMatrix1D(this.rows);
        }
        if (!(y instanceof DenseLongMatrix1D) || !(z instanceof DenseLongMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)this.columns != y.size() || (long)this.rows > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        final long[] elemsY = (long[])y.elements();
        final long[] elemsZ = (long[])z.elements();
        if (this.elements == null || elemsY == null || elemsZ == null) {
            throw new InternalError();
        }
        final int strideY = y.stride();
        final int strideZ = z.stride();
        final int zero = (int)this.index(0, 0);
        final int zeroY = (int)y.index(0);
        final int zeroZ = (int)z.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxZero = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        int idxZeroZ = zeroZ + firstRow * strideZ;
                        for (int r = firstRow; r < lastRow; ++r) {
                            long sum = 0L;
                            int idx = idxZero;
                            int idxY = zeroY;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                sum += DenseLongMatrix2D.this.elements[idx] * elemsY[idxY];
                                idx += DenseLongMatrix2D.this.columnStride;
                                idxY += strideY;
                            }
                            elemsZ[idxZeroZ] = alpha * sum + beta * elemsZ[idxZeroZ];
                            idxZero += DenseLongMatrix2D.this.rowStride;
                            idxZeroZ += strideZ;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxZero = zero;
            int idxZeroZ = zeroZ;
            for (int r = 0; r < this.rows; ++r) {
                long sum = 0L;
                int idx = idxZero;
                int idxY = zeroY;
                for (int c = 0; c < this.columns; ++c) {
                    sum += this.elements[idx] * elemsY[idxY];
                    idx += this.columnStride;
                    idxY += strideY;
                }
                elemsZ[idxZeroZ] = alpha * sum + beta * elemsZ[idxZeroZ];
                idxZero += this.rowStride;
                idxZeroZ += strideZ;
            }
        }
        return z;
    }

    @Override
    public LongMatrix2D zMult(LongMatrix2D B, LongMatrix2D C, final long alpha, final long beta, final boolean transposeA, final boolean transposeB) {
        int columnsC;
        int rowsA = this.rows;
        int columnsA = this.columns;
        int rowsB = B.rows();
        int columnsB = B.columns();
        int rowsC = transposeA ? columnsA : rowsA;
        int n = columnsC = transposeB ? rowsB : columnsB;
        if (C == null) {
            C = new DenseLongMatrix2D(rowsC, columnsC);
        }
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseLongMatrix2D || B instanceof SparseRCLongMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        if (!(C instanceof DenseLongMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != columnsB) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)rowsA * (long)columnsA * (long)columnsB;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean splitB = columnsB >= noOfTasks;
        int width = splitB ? columnsB : rowsA;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            return this.zMultSequential(B, C, alpha, beta, transposeA, transposeB);
        }
        int span = width / noOfTasks;
        Future[] subTasks = new Future[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            LongMatrix2D CC;
            LongMatrix2D BB;
            LongMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = this;
                BB = B.viewPart(0, offset, columnsA, span);
                CC = C.viewPart(0, offset, rowsA, span);
            } else {
                AA = this.viewPart(offset, 0, span, columnsA);
                BB = B;
                CC = C.viewPart(offset, 0, span, columnsB);
            }
            subTasks[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    ((DenseLongMatrix2D)AA).zMultSequential(BB, CC, alpha, beta, transposeA, transposeB);
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(subTasks);
        return C;
    }

    @Override
    public long zSum() {
        long sum = 0L;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long sum = 0L;
                        int idx = zero + firstRow * DenseLongMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseLongMatrix2D.this.columns; ++c) {
                                sum += DenseLongMatrix2D.this.elements[i];
                                i += DenseLongMatrix2D.this.columnStride;
                            }
                            idx += DenseLongMatrix2D.this.rowStride;
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    sum += ((Long)futures[j].get()).longValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    sum += this.elements[i];
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return sum;
    }

    private LongMatrix2D zMultSequential(LongMatrix2D B, LongMatrix2D C, long alpha, long beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseLongMatrix2D || B instanceof SparseRCLongMatrix2D || B instanceof SparseCCLongMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        int rowsA = this.rows;
        int columnsA = this.columns;
        int p = B.columns();
        if (C == null) {
            C = new DenseLongMatrix2D(rowsA, p);
        }
        if (!(B instanceof DenseLongMatrix2D) || !(C instanceof DenseLongMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseLongMatrix2D BB = (DenseLongMatrix2D)B;
        DenseLongMatrix2D CC = (DenseLongMatrix2D)C;
        long[] AElems = this.elements;
        long[] BElems = BB.elements;
        long[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new InternalError();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int BLOCK_SIZE = 30000;
        int m_optimal = (30000 - columnsA) / (columnsA + 1);
        if (m_optimal <= 0) {
            m_optimal = 1;
        }
        int blocks = rowsA / m_optimal;
        int rr = 0;
        if (rowsA % m_optimal != 0) {
            ++blocks;
        }
        while (--blocks >= 0) {
            int jB = (int)BB.index(0, 0);
            int indexA = (int)this.index(rr, 0);
            int jC = (int)CC.index(rr, 0);
            rr += m_optimal;
            if (blocks == 0) {
                m_optimal += rowsA - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = m_optimal;
                while (--i >= 0) {
                    int kA = iA;
                    int kB = jB;
                    long s = 0L;
                    kA -= cA;
                    kB -= rB;
                    int k = columnsA % 4;
                    while (--k >= 0) {
                        s += AElems[kA += cA] * BElems[kB += rB];
                    }
                    k = columnsA / 4;
                    while (--k >= 0) {
                        int n = kA + cA;
                        kA = n;
                        int n2 = kB + rB;
                        kB = n2;
                        int n3 = kA + cA;
                        kA = n3;
                        int n4 = kB + rB;
                        kB = n4;
                        kA = kA + cA;
                        kB = kB + rB;
                        s += AElems[n] * BElems[n2] + AElems[n3] * BElems[n4] + AElems[kA] * BElems[kB] + AElems[kA += cA] * BElems[kB += rB];
                    }
                    CElems[iC] = alpha * s + beta * CElems[iC];
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    @Override
    protected boolean haveSharedCellsRaw(LongMatrix2D other) {
        if (other instanceof SelectedDenseLongMatrix2D) {
            SelectedDenseLongMatrix2D otherMatrix = (SelectedDenseLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseLongMatrix2D) {
            DenseLongMatrix2D otherMatrix = (DenseLongMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected LongMatrix1D like1D(int size, int zero, int stride) {
        return new DenseLongMatrix1D(size, this.elements, zero, stride, true);
    }

    @Override
    protected LongMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseLongMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

