/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.function.tfloat.LongFloatProcedure;
import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.map.tfloat.OpenLongFloatHashMap;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SelectedSparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCMFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import java.io.IOException;

public class SparseFloatMatrix2D
extends FloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongFloatMap elements;

    public SparseFloatMatrix2D(float[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseFloatMatrix2D(int rows, int columns) {
        this(rows, columns, rows * (columns / 1000), 0.2f, 0.5f);
    }

    public SparseFloatMatrix2D(int rows, int columns, int initialCapacity, float minLoadFactor, float maxLoadFactor) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongFloatHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public SparseFloatMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, float value) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongFloatHashMap(rowIndexes.length);
        this.insert(rowIndexes, columnIndexes, value);
    }

    public SparseFloatMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, float[] values) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongFloatHashMap(rowIndexes.length);
        this.insert(rowIndexes, columnIndexes, values);
    }

    public SparseFloatMatrix2D(MatrixVectorReader reader) throws IOException {
        block9: {
            float[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block8: {
                MatrixSize size;
                block7: {
                    info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                    if (info.isPattern()) {
                        throw new UnsupportedOperationException("Pattern matrices are not supported");
                    }
                    if (info.isDense()) {
                        throw new UnsupportedOperationException("Dense matrices are not supported");
                    }
                    if (info.isComplex()) {
                        throw new UnsupportedOperationException("Complex matrices are not supported");
                    }
                    size = reader.readMatrixSize(info);
                    try {
                        this.setUp(size.numRows(), size.numColumns());
                    }
                    catch (IllegalArgumentException exc) {
                        if ("matrix too large".equals(exc.getMessage())) break block7;
                        throw exc;
                    }
                }
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new float[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                this.elements = info.isSymmetric() || info.isSkewSymmetric() ? new OpenLongFloatHashMap(2 * rowIndexes.length) : new OpenLongFloatHashMap(rowIndexes.length);
                this.insert(rowIndexes, columnIndexes, values);
                if (!info.isSymmetric()) break block8;
                for (int i = 0; i < numEntries; ++i) {
                    if (rowIndexes[i] == columnIndexes[i]) continue;
                    this.set(columnIndexes[i], rowIndexes[i], values[i]);
                }
                break block9;
            }
            if (!info.isSkewSymmetric()) break block9;
            for (int i = 0; i < numEntries; ++i) {
                if (rowIndexes[i] == columnIndexes[i]) continue;
                this.set(columnIndexes[i], rowIndexes[i], -values[i]);
            }
        }
    }

    protected SparseFloatMatrix2D(int rows, int columns, AbstractLongFloatMap elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        block2: {
            try {
                this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public FloatMatrix2D assign(FloatFunction function) {
        if (this.isNoView && function instanceof FloatMult) {
            this.elements.assign(function);
        } else {
            super.assign(function);
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(float value) {
        if (this.isNoView && value == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D source) {
        if (!(source instanceof SparseFloatMatrix2D)) {
            return super.assign(source);
        }
        SparseFloatMatrix2D other = (SparseFloatMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            this.elements.assign(other.elements);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public FloatMatrix2D assign(final FloatMatrix2D y, FloatFloatFunction function) {
        if (!this.isNoView) {
            return super.assign(y, function);
        }
        this.checkShape(y);
        if (function instanceof FloatPlusMultSecond) {
            final float alpha = ((FloatPlusMultSecond)function).multiplicator;
            if (alpha == 0.0f) {
                return this;
            }
            y.forEachNonZero(new IntIntFloatFunction(){

                @Override
                public float apply(int i, int j, float value) {
                    SparseFloatMatrix2D.this.setQuick(i, j, SparseFloatMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
        } else if (function == FloatFunctions.mult) {
            this.elements.forEachPair(new LongFloatProcedure(){

                @Override
                public boolean apply(long key, float value) {
                    int j;
                    int i = (int)(key / (long)SparseFloatMatrix2D.this.columns);
                    float r = value * y.getQuick(i, j = (int)(key % (long)SparseFloatMatrix2D.this.columns));
                    if (r != value) {
                        SparseFloatMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else if (function == FloatFunctions.div) {
            this.elements.forEachPair(new LongFloatProcedure(){

                @Override
                public boolean apply(long key, float value) {
                    int j;
                    int i = (int)(key / (long)SparseFloatMatrix2D.this.columns);
                    float r = value / y.getQuick(i, j = (int)(key % (long)SparseFloatMatrix2D.this.columns));
                    if (r != value) {
                        SparseFloatMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.assign(y, function);
        }
        return this;
    }

    public SparseFloatMatrix2D assign(int[] rowIndexes, int[] columnIndexes, float value, FloatFloatFunction function) {
        int size = rowIndexes.length;
        if (function == FloatFunctions.plus) {
            for (int i = 0; i < size; ++i) {
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                float elem = this.elements.get(index);
                float sum = elem + value;
                if (sum != 0.0f) {
                    this.elements.put(index, sum);
                    continue;
                }
                this.elements.removeKey(index);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                float elem = this.elements.get(index);
                float result = function.apply(elem, value);
                if (result != 0.0f) {
                    this.elements.put(index, result);
                    continue;
                }
                this.elements.removeKey(index);
            }
        }
        return this;
    }

    public SparseFloatMatrix2D assign(int[] rowIndexes, int[] columnIndexes, float[] values, FloatFloatFunction function) {
        int size = rowIndexes.length;
        if (function == FloatFunctions.plus) {
            for (int i = 0; i < size; ++i) {
                float value = values[i];
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                float elem = this.elements.get(index);
                if ((value += elem) != 0.0f) {
                    this.elements.put(index, value);
                    continue;
                }
                this.elements.removeKey(index);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                float value = values[i];
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                float elem = this.elements.get(index);
                value = function.apply(elem, value);
                if (value != 0.0f) {
                    this.elements.put(index, value);
                    continue;
                }
                this.elements.removeKey(index);
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public SparseCCFloatMatrix2D getColumnCompressed(boolean sortRowIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        float[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        for (int k = 0; k < nnz; ++k) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
        }
        return new SparseCCFloatMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, false, sortRowIndexes);
    }

    public SparseCCMFloatMatrix2D getColumnCompressedModified() {
        SparseCCMFloatMatrix2D A = new SparseCCMFloatMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        float[] values = this.elements.values().elements();
        for (int i = 0; i < nnz; ++i) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
        }
        return A;
    }

    public SparseRCFloatMatrix2D getRowCompressed(boolean sortColumnIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        float[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        for (int k = 0; k < nnz; ++k) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
        }
        return new SparseRCFloatMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, false, sortColumnIndexes);
    }

    public SparseRCMFloatMatrix2D getRowCompressedModified() {
        SparseRCMFloatMatrix2D A = new SparseRCMFloatMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        float[] values = this.elements.values().elements();
        for (int i = 0; i < nnz; ++i) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
        }
        return A;
    }

    @Override
    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction function) {
        if (this.isNoView) {
            this.elements.forEachPair(new LongFloatProcedure(){

                @Override
                public boolean apply(long key, float value) {
                    int j;
                    int i = (int)(key / (long)SparseFloatMatrix2D.this.columns);
                    float r = function.apply(i, j = (int)(key % (long)SparseFloatMatrix2D.this.columns), value);
                    if (r != value) {
                        SparseFloatMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(function);
        }
        return this;
    }

    @Override
    public synchronized float getQuick(int row, int column) {
        return this.elements.get((long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    @Override
    public long index(int row, int column) {
        return (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public FloatMatrix2D like(int rows, int columns) {
        return new SparseFloatMatrix2D(rows, columns);
    }

    @Override
    public FloatMatrix1D like1D(int size) {
        return new SparseFloatMatrix1D(size);
    }

    @Override
    public synchronized void setQuick(int row, int column, float value) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == 0.0f) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                float elem = this.getQuick(r, c);
                if (elem == 0.0f) continue;
                builder.append('(').append(r).append(',').append(c).append(')').append('\t').append(elem).append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public FloatMatrix1D vectorize() {
        SparseFloatMatrix1D v = new SparseFloatMatrix1D((int)this.size());
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                float elem = this.getQuick(r, c);
                v.setQuick(idx++, elem);
            }
        }
        return v;
    }

    @Override
    public FloatMatrix1D zMult(FloatMatrix1D y, FloatMatrix1D z, final float alpha, float beta, final boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseFloatMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseFloatMatrix1D && z instanceof DenseFloatMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!ignore) {
            z.assign(FloatFunctions.mult(beta));
        }
        DenseFloatMatrix1D zz = (DenseFloatMatrix1D)z;
        final float[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseFloatMatrix1D yy = (DenseFloatMatrix1D)y;
        final float[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new LongFloatProcedure(){

            @Override
            public boolean apply(long key, float value) {
                int i = (int)(key / (long)SparseFloatMatrix2D.this.columns);
                int j = (int)(key % (long)SparseFloatMatrix2D.this.columns);
                if (transposeA) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * value * elementsY[zeroY + strideY * j];
                return true;
            }
        });
        return z;
    }

    @Override
    public FloatMatrix2D zMult(FloatMatrix2D B, FloatMatrix2D C, final float alpha, float beta, final boolean transposeA, boolean transposeB) {
        boolean ignore;
        if (!this.isNoView) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (transposeB) {
            B = B.viewDice();
        }
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int p = B.columns();
        boolean bl = ignore = C == null;
        if (C == null) {
            C = new DenseFloatMatrix2D(rowsA, p);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore) {
            C.assign(FloatFunctions.mult(beta));
        }
        final FloatMatrix1D[] Brows = new FloatMatrix1D[columnsA];
        int i = columnsA;
        while (--i >= 0) {
            Brows[i] = B.viewRow(i);
        }
        final FloatMatrix1D[] Crows = new FloatMatrix1D[rowsA];
        int i2 = rowsA;
        while (--i2 >= 0) {
            Crows[i2] = C.viewRow(i2);
        }
        final FloatPlusMultSecond fun = FloatPlusMultSecond.plusMult(0.0f);
        this.elements.forEachPair(new LongFloatProcedure(){

            @Override
            public boolean apply(long key, float value) {
                int i = (int)(key / (long)SparseFloatMatrix2D.this.columns);
                int j = (int)(key % (long)SparseFloatMatrix2D.this.columns);
                fun.multiplicator = value * alpha;
                if (!transposeA) {
                    Crows[i].assign(Brows[j], fun);
                } else {
                    Crows[j].assign(Brows[i], fun);
                }
                return true;
            }
        });
        return C;
    }

    private void insert(int[] rowIndexes, int[] columnIndexes, float value) {
        int size = rowIndexes.length;
        for (int i = 0; i < size; ++i) {
            long row = rowIndexes[i];
            long column = columnIndexes[i];
            if (row >= (long)this.rows || column >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
            }
            if (value == 0.0f) continue;
            long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
            float elem = this.elements.get(index);
            if (elem == 0.0f) {
                this.elements.put(index, value);
                continue;
            }
            float sum = elem + value;
            if (sum == 0.0f) {
                this.elements.removeKey(index);
                continue;
            }
            this.elements.put(index, sum);
        }
    }

    private void insert(int[] rowIndexes, int[] columnIndexes, float[] values) {
        int size = rowIndexes.length;
        for (int i = 0; i < size; ++i) {
            float value = values[i];
            long row = rowIndexes[i];
            long column = columnIndexes[i];
            if (row >= (long)this.rows || column >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
            }
            if (value == 0.0f) continue;
            long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
            float elem = this.elements.get(index);
            if (elem == 0.0f) {
                this.elements.put(index, value);
                continue;
            }
            float sum = elem + value;
            if (sum == 0.0f) {
                this.elements.removeKey(index);
                continue;
            }
            this.elements.put(index, sum);
        }
    }

    @Override
    protected boolean haveSharedCellsRaw(FloatMatrix2D other) {
        if (other instanceof SelectedSparseFloatMatrix2D) {
            SelectedSparseFloatMatrix2D otherMatrix = (SelectedSparseFloatMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseFloatMatrix2D) {
            SparseFloatMatrix2D otherMatrix = (SparseFloatMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected FloatMatrix1D like1D(int size, int offset, int stride) {
        return new SparseFloatMatrix1D(size, this.elements, offset, stride);
    }

    @Override
    protected FloatMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseFloatMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

