/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.map.tfloat.OpenLongFloatHashMap;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SelectedSparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix3D;

public class SparseFloatMatrix1D
extends FloatMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongFloatMap elements;

    public SparseFloatMatrix1D(float[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseFloatMatrix1D(int size) {
        this(size, size / 1000, 0.2f, 0.5f);
    }

    public SparseFloatMatrix1D(int size, int initialCapacity, float minLoadFactor, float maxLoadFactor) {
        this.setUp(size);
        this.elements = new OpenLongFloatHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseFloatMatrix1D(int size, AbstractLongFloatMap elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public FloatMatrix1D assign(float value) {
        if (this.isNoView && value == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized float getQuick(int index) {
        return this.elements.get((long)this.zero + (long)index * (long)this.stride);
    }

    @Override
    public long index(int rank) {
        return (long)this.zero + (long)rank * (long)this.stride;
    }

    @Override
    public FloatMatrix1D like(int size) {
        return new SparseFloatMatrix1D(size);
    }

    @Override
    public FloatMatrix2D like2D(int rows, int columns) {
        return new SparseFloatMatrix2D(rows, columns);
    }

    @Override
    public FloatMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseFloatMatrix2D M = new SparseFloatMatrix2D(rows, columns);
        int idx = 0;
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                float elem;
                if ((elem = this.getQuick(idx++)) == 0.0f) continue;
                ((FloatMatrix2D)M).setQuick(r, c, elem);
            }
        }
        return M;
    }

    @Override
    public FloatMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseFloatMatrix3D M = new SparseFloatMatrix3D(slices, rows, columns);
        int idx = 0;
        for (int s = 0; s < slices; ++s) {
            for (int c = 0; c < columns; ++c) {
                for (int r = 0; r < rows; ++r) {
                    float elem;
                    if ((elem = this.getQuick(idx++)) == 0.0f) continue;
                    ((FloatMatrix3D)M).setQuick(s, r, c, elem);
                }
            }
        }
        return M;
    }

    @Override
    public synchronized void setQuick(int index, float value) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (value == 0.0f) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("1 x ").append(this.size).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.size; ++i) {
            float elem = this.getQuick(i);
            if (elem == 0.0f) continue;
            builder.append('(').append(i).append(')').append('\t').append(elem).append('\n');
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    protected boolean haveSharedCellsRaw(FloatMatrix1D other) {
        if (other instanceof SelectedSparseFloatMatrix1D) {
            SelectedSparseFloatMatrix1D otherMatrix = (SelectedSparseFloatMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseFloatMatrix1D) {
            SparseFloatMatrix1D otherMatrix = (SparseFloatMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected FloatMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseFloatMatrix1D(this.elements, offsets);
    }
}

