/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatLUDecompositionQuick;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCMFloatMatrix2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FloatAMG
implements FloatPreconditioner {
    private SSOR[] preM;
    private SSOR[] postM;
    private int m;
    private SparseRCFloatMatrix2D[] A;
    private DenseFloatLUDecompositionQuick lu;
    private DenseFloatMatrix1D[] u;
    private DenseFloatMatrix1D[] f;
    private DenseFloatMatrix1D[] r;
    private SparseCCFloatMatrix2D[] I;
    private final int min;
    private final int nu1;
    private final int nu2;
    private final int gamma;
    private final float omegaPreF;
    private final float omegaPreR;
    private final float omegaPostF;
    private final float omegaPostR;
    private final boolean reverse;
    private final float omega;
    private boolean transpose;

    public FloatAMG(float omegaPreF, float omegaPreR, float omegaPostF, float omegaPostR, int nu1, int nu2, int gamma, int min, float omega) {
        this.omegaPreF = omegaPreF;
        this.omegaPreR = omegaPreR;
        this.omegaPostF = omegaPostF;
        this.omegaPostR = omegaPostR;
        this.reverse = true;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min;
        this.omega = omega;
    }

    public FloatAMG(float omegaPre, float omegaPost, int nu1, int nu2, int gamma, int min, float omega) {
        this.omegaPreF = omegaPre;
        this.omegaPreR = omegaPre;
        this.omegaPostF = omegaPost;
        this.omegaPostR = omegaPost;
        this.reverse = false;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min;
        this.omega = omega;
    }

    public FloatAMG() {
        this(1.0f, 1.85f, 1.85f, 1.0f, 1, 1, 1, 40, 0.6666667f);
    }

    @Override
    public FloatMatrix1D apply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.u[0].assign(x);
        this.f[0].assign(b);
        this.transpose = false;
        this.cycle(0);
        return x.assign(this.u[0]);
    }

    @Override
    public FloatMatrix1D transApply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.u[0].assign(x);
        this.f[0].assign(b);
        this.transpose = true;
        this.cycle(0);
        return x.assign(this.u[0]);
    }

    @Override
    public void setMatrix(FloatMatrix2D A) {
        int k;
        float eps;
        SparseRCFloatMatrix2D Af;
        Aggregator aggregator;
        LinkedList<SparseRCFloatMatrix2D> Al = new LinkedList<SparseRCFloatMatrix2D>();
        LinkedList<SparseCCFloatMatrix2D> Il = new LinkedList<SparseCCFloatMatrix2D>();
        SparseRCFloatMatrix2D Arc = new SparseRCFloatMatrix2D(A.rows(), A.columns());
        Arc.assign(A);
        if (!Arc.hasColumnIndexesSorted()) {
            Arc.sortColumnIndexes();
        }
        Al.add(Arc);
        int k2 = 0;
        while (((SparseRCFloatMatrix2D)Al.get(k2)).rows() > this.min && (aggregator = new Aggregator(Af = (SparseRCFloatMatrix2D)Al.get(k2), eps = (float)(0.08 * Math.pow(0.5, k2)))).getAggregates().size() != 0) {
            Interpolator sa = new Interpolator(aggregator, Af, this.omega);
            Al.add(sa.getGalerkinOperator());
            Il.add(sa.getInterpolationOperator());
            ++k2;
        }
        this.m = Al.size();
        if (this.m == 0) {
            throw new RuntimeException("Matrix too small for AMG");
        }
        this.I = new SparseCCFloatMatrix2D[this.m - 1];
        this.A = new SparseRCFloatMatrix2D[this.m - 1];
        Il.toArray(this.I);
        for (int i = 0; i < Al.size() - 1; ++i) {
            this.A[i] = (SparseRCFloatMatrix2D)Al.get(i);
        }
        DenseFloatMatrix2D Ac = new DenseFloatMatrix2D(((SparseRCFloatMatrix2D)Al.get(Al.size() - 1)).toArray());
        this.lu = new DenseFloatLUDecompositionQuick();
        this.lu.decompose(Ac);
        this.u = new DenseFloatMatrix1D[this.m];
        this.f = new DenseFloatMatrix1D[this.m];
        this.r = new DenseFloatMatrix1D[this.m];
        for (k = 0; k < this.m; ++k) {
            int n = ((SparseRCFloatMatrix2D)Al.get(k)).rows();
            this.u[k] = new DenseFloatMatrix1D(n);
            this.f[k] = new DenseFloatMatrix1D(n);
            this.r[k] = new DenseFloatMatrix1D(n);
        }
        this.preM = new SSOR[this.m - 1];
        this.postM = new SSOR[this.m - 1];
        for (k = 0; k < this.m - 1; ++k) {
            SparseRCFloatMatrix2D Ak = this.A[k];
            this.preM[k] = new SSOR(Ak, this.reverse, this.omegaPreF, this.omegaPreR);
            this.postM[k] = new SSOR(Ak, this.reverse, this.omegaPostF, this.omegaPostR);
            this.preM[k].setMatrix(Ak);
            this.postM[k].setMatrix(Ak);
        }
    }

    private void cycle(int k) {
        if (k == this.m - 1) {
            this.directSolve();
        } else {
            this.preRelax(k);
            this.u[k + 1].assign(0.0f);
            this.A[k].zMult(this.u[k], this.r[k].assign(this.f[k]), -1.0f, 1.0f, false);
            this.I[k].zMult(this.r[k], this.f[k + 1], 1.0f, 0.0f, true);
            for (int i = 0; i < this.gamma; ++i) {
                this.cycle(k + 1);
            }
            this.I[k].zMult(this.u[k + 1], this.u[k], 1.0f, 1.0f, false);
            this.postRelax(k);
        }
    }

    private void directSolve() {
        int k = this.m - 1;
        this.u[k].assign(this.f[k]);
        if (this.transpose) {
            this.lu.setLU(this.lu.getLU().viewDice());
            this.lu.solve(this.u[k]);
            this.lu.setLU(this.lu.getLU().viewDice());
        } else {
            this.lu.solve(this.u[k]);
        }
    }

    private void preRelax(int k) {
        for (int i = 0; i < this.nu1; ++i) {
            if (this.transpose) {
                this.preM[k].transApply(this.f[k], this.u[k]);
                continue;
            }
            this.preM[k].apply(this.f[k], this.u[k]);
        }
    }

    private void postRelax(int k) {
        for (int i = 0; i < this.nu2; ++i) {
            if (this.transpose) {
                this.postM[k].transApply(this.f[k], this.u[k]);
                continue;
            }
            this.postM[k].apply(this.f[k], this.u[k]);
        }
    }

    private class SSOR
    implements FloatPreconditioner {
        private float omegaF;
        private float omegaR;
        private final SparseRCFloatMatrix2D F;
        private final int[] diagind;
        private final float[] xx;
        private final boolean reverse;

        public SSOR(SparseRCFloatMatrix2D F, boolean reverse, float omegaF, float omegaR) {
            if (F.rows() != F.columns()) {
                throw new IllegalArgumentException("SSOR only applies to square matrices");
            }
            this.F = F;
            this.reverse = reverse;
            this.setOmega(omegaF, omegaR);
            int n = F.rows();
            this.diagind = new int[n];
            this.xx = new float[n];
        }

        public SSOR(SparseRCFloatMatrix2D F) {
            this(F, true, 1.0f, 1.0f);
        }

        public void setOmega(float omegaF, float omegaR) {
            if (omegaF < 0.0f || omegaF > 2.0f) {
                throw new IllegalArgumentException("omegaF must be between 0 and 2");
            }
            if (omegaR < 0.0f || omegaR > 2.0f) {
                throw new IllegalArgumentException("omegaR must be between 0 and 2");
            }
            this.omegaF = omegaF;
            this.omegaR = omegaR;
        }

        @Override
        public void setMatrix(FloatMatrix2D A) {
            this.F.assign(A);
            int n = this.F.rows();
            int[] rowptr = this.F.getRowPointers();
            int[] colind = this.F.getColumnIndexes();
            for (int k = 0; k < n; ++k) {
                this.diagind[k] = Sorting.binarySearchFromTo(colind, k, rowptr[k], rowptr[k + 1] - 1);
                if (this.diagind[k] >= 0) continue;
                throw new RuntimeException("Missing diagonal on row " + (k + 1));
            }
        }

        @Override
        public FloatMatrix1D apply(FloatMatrix1D b, FloatMatrix1D x) {
            int j;
            float sigma;
            int i;
            if (!(b instanceof DenseFloatMatrix1D) || !(x instanceof DenseFloatMatrix1D)) {
                throw new IllegalArgumentException("b and x must be a DenseFloatMatrix1D");
            }
            int[] rowptr = this.F.getRowPointers();
            int[] colind = this.F.getColumnIndexes();
            float[] data = this.F.getValues();
            float[] bd = ((DenseFloatMatrix1D)b).elements();
            float[] xd = ((DenseFloatMatrix1D)x).elements();
            int n = this.F.rows();
            System.arraycopy(xd, 0, this.xx, 0, n);
            for (i = 0; i < n; ++i) {
                sigma = 0.0f;
                for (j = rowptr[i]; j < this.diagind[i]; ++j) {
                    sigma += data[j] * this.xx[colind[j]];
                }
                for (j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                    sigma += data[j] * xd[colind[j]];
                }
                sigma = (bd[i] - sigma) / data[this.diagind[i]];
                this.xx[i] = xd[i] + this.omegaF * (sigma - xd[i]);
            }
            if (!this.reverse) {
                System.arraycopy(this.xx, 0, xd, 0, n);
                return x;
            }
            for (i = n - 1; i >= 0; --i) {
                sigma = 0.0f;
                for (j = rowptr[i]; j < this.diagind[i]; ++j) {
                    sigma += data[j] * this.xx[colind[j]];
                }
                for (j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                    sigma += data[j] * xd[colind[j]];
                }
                sigma = (bd[i] - sigma) / data[this.diagind[i]];
                xd[i] = this.xx[i] + this.omegaR * (sigma - this.xx[i]);
            }
            x.assign(xd);
            return x;
        }

        @Override
        public FloatMatrix1D transApply(FloatMatrix1D b, FloatMatrix1D x) {
            return this.apply(b, x);
        }
    }

    private static class Interpolator {
        private SparseRCFloatMatrix2D Ac;
        private SparseCCFloatMatrix2D I;

        public Interpolator(Aggregator aggregator, SparseRCFloatMatrix2D A, float omega) {
            List<Set<Integer>> C = aggregator.getAggregates();
            List<Set<Integer>> N = aggregator.getNodeNeighborhoods();
            int[] diagind = aggregator.getDiagonalindexes();
            int[] pt = this.createTentativeProlongation(C, A.rows());
            if (omega != 0.0f) {
                List<Map<Integer, Float>> P = this.createSmoothedProlongation(C, N, A, diagind, omega, pt);
                this.I = this.createInterpolationMatrix(P, A.rows());
                this.Ac = this.createGalerkinSlow(this.I, A);
            } else {
                this.Ac = this.createGalerkinFast(A, pt, C.size());
                this.I = this.createInterpolationMatrix(pt, C.size());
            }
        }

        private int[] createTentativeProlongation(List<Set<Integer>> C, int n) {
            int[] pt = new int[n];
            Arrays.fill(pt, -1);
            for (int i = 0; i < C.size(); ++i) {
                for (int j : C.get(i)) {
                    pt[j] = i;
                }
            }
            return pt;
        }

        private SparseRCFloatMatrix2D createGalerkinFast(SparseRCFloatMatrix2D A, int[] pt, int c) {
            int n = pt.length;
            SparseRCMFloatMatrix2D Ac = new SparseRCMFloatMatrix2D(c, c);
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            float[] data = A.getValues();
            for (int i = 0; i < n; ++i) {
                if (pt[i] == -1) continue;
                for (int j = rowptr[i]; j < rowptr[i + 1]; ++j) {
                    if (pt[colind[j]] == -1) continue;
                    Ac.setQuick(pt[i], pt[colind[j]], data[j]);
                }
            }
            return (SparseRCFloatMatrix2D)new SparseRCFloatMatrix2D(Ac.rows(), Ac.columns()).assign(Ac);
        }

        private SparseCCFloatMatrix2D createInterpolationMatrix(List<Map<Integer, Float>> P, int n) {
            int c = P.size();
            this.I = new SparseCCFloatMatrix2D(n, c);
            for (int j = 0; j < c; ++j) {
                Map<Integer, Float> Pj = P.get(j);
                for (Map.Entry<Integer, Float> e : Pj.entrySet()) {
                    this.I.setQuick(e.getKey(), j, e.getValue().floatValue());
                }
            }
            return this.I;
        }

        private SparseCCFloatMatrix2D createInterpolationMatrix(int[] pt, int c) {
            SparseCCMFloatMatrix2D If = new SparseCCMFloatMatrix2D(pt.length, c);
            for (int i = 0; i < pt.length; ++i) {
                if (pt[i] == -1) continue;
                If.setQuick(i, pt[i], 1.0f);
            }
            return (SparseCCFloatMatrix2D)new SparseCCFloatMatrix2D(If.rows(), If.columns()).assign(If);
        }

        public SparseCCFloatMatrix2D getInterpolationOperator() {
            return this.I;
        }

        private List<Map<Integer, Float>> createSmoothedProlongation(List<Set<Integer>> C, List<Set<Integer>> N, SparseRCFloatMatrix2D A, int[] diagind, float omega, int[] pt) {
            int n = A.rows();
            int c = C.size();
            ArrayList<Map<Integer, Float>> P = new ArrayList<Map<Integer, Float>>(c);
            for (int i = 0; i < c; ++i) {
                P.add(new HashMap());
            }
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            float[] data = A.getValues();
            float[] dot = new float[c];
            for (int i = 0; i < n; ++i) {
                if (pt[i] == -1) continue;
                Arrays.fill(dot, 0.0f);
                Set<Integer> Ni = N.get(i);
                float weakAij = 0.0f;
                for (int j = rowptr[i]; j < rowptr[i + 1]; ++j) {
                    if (pt[colind[j]] == -1) continue;
                    float aij = data[j];
                    if (aij != 0.0f && !Ni.contains(colind[j])) {
                        weakAij += aij;
                        continue;
                    }
                    int n2 = pt[colind[j]];
                    dot[n2] = dot[n2] + aij;
                }
                int n3 = pt[i];
                dot[n3] = dot[n3] - weakAij;
                float scale = -omega / data[diagind[i]];
                int j = 0;
                while (j < dot.length) {
                    int n4 = j++;
                    dot[n4] = dot[n4] * scale;
                }
                int n5 = pt[i];
                dot[n5] = dot[n5] + 1.0f;
                for (j = 0; j < dot.length; ++j) {
                    if (dot[j] == 0.0f) continue;
                    ((Map)P.get(j)).put(i, Float.valueOf(dot[j]));
                }
            }
            return P;
        }

        private SparseRCFloatMatrix2D createGalerkinSlow(SparseCCFloatMatrix2D I, SparseRCFloatMatrix2D A) {
            int n = I.rows();
            int c = I.columns();
            SparseRCMFloatMatrix2D Ac = new SparseRCMFloatMatrix2D(c, c);
            float[] aiCol = new float[n];
            float[] iCol = new float[n];
            DenseFloatMatrix1D aiV = new DenseFloatMatrix1D(n, aiCol, 0, 1, false);
            DenseFloatMatrix1D iV = new DenseFloatMatrix1D(n, iCol, 0, 1, false);
            float[] itaiCol = new float[c];
            DenseFloatMatrix1D itaiV = new DenseFloatMatrix1D(c, itaiCol, 0, 1, false);
            int[] colptr = I.getColumnPointers();
            int[] rowind = I.getRowIndexes();
            float[] Idata = I.getValues();
            for (int k = 0; k < c; ++k) {
                int i;
                iV.assign(0.0f);
                for (i = colptr[k]; i < colptr[k + 1]; ++i) {
                    iCol[rowind[i]] = Idata[i];
                }
                A.zMult(iV, aiV);
                I.zMult(aiV, itaiV, 1.0f, 0.0f, true);
                for (i = 0; i < c; ++i) {
                    if (itaiCol[i] == 0.0f) continue;
                    Ac.setQuick(i, k, itaiCol[i]);
                }
            }
            return (SparseRCFloatMatrix2D)new SparseRCFloatMatrix2D(Ac.rows(), Ac.columns()).assign(Ac);
        }

        public SparseRCFloatMatrix2D getGalerkinOperator() {
            return this.Ac;
        }
    }

    private static class Aggregator {
        private List<Set<Integer>> C;
        private int[] diagind;
        private List<Set<Integer>> N;

        public Aggregator(SparseRCFloatMatrix2D A, float eps) {
            this.diagind = this.findDiagonalindexes(A);
            this.N = this.findNodeNeighborhood(A, this.diagind, eps);
            boolean[] R = this.createInitialR(A);
            this.C = this.createInitialAggregates(this.N, R);
            this.C = this.enlargeAggregates(this.C, this.N, R);
            this.C = this.createFinalAggregates(this.C, this.N, R);
        }

        public List<Set<Integer>> getAggregates() {
            return this.C;
        }

        public int[] getDiagonalindexes() {
            return this.diagind;
        }

        public List<Set<Integer>> getNodeNeighborhoods() {
            return this.N;
        }

        private int[] findDiagonalindexes(SparseRCFloatMatrix2D A) {
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            int[] diagind = new int[A.rows()];
            for (int i = 0; i < A.rows(); ++i) {
                diagind[i] = Sorting.binarySearchFromTo(colind, i, rowptr[i], rowptr[i + 1]);
                if (diagind[i] >= 0) continue;
                throw new RuntimeException("Matrix is missing a diagonal entry on row " + (i + 1));
            }
            return diagind;
        }

        private List<Set<Integer>> findNodeNeighborhood(SparseRCFloatMatrix2D A, int[] diagind, float eps) {
            this.N = new ArrayList<Set<Integer>>(A.rows());
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            float[] data = A.getValues();
            for (int i = 0; i < A.rows(); ++i) {
                HashSet<Integer> Ni = new HashSet<Integer>();
                float aii = data[diagind[i]];
                for (int j = rowptr[i]; j < rowptr[i + 1]; ++j) {
                    float aij = data[j];
                    float ajj = data[diagind[colind[j]]];
                    if (!(Math.abs(aij) >= eps * (float)Math.sqrt(aii * ajj))) continue;
                    Ni.add(colind[j]);
                }
                this.N.add(Ni);
            }
            return this.N;
        }

        private boolean[] createInitialR(SparseRCFloatMatrix2D A) {
            boolean[] R = new boolean[A.rows()];
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            float[] data = A.getValues();
            for (int i = 0; i < A.rows(); ++i) {
                boolean hasOffDiagonal = false;
                for (int j = rowptr[i]; j < rowptr[i + 1]; ++j) {
                    if (colind[j] == i || data[j] == 0.0f) continue;
                    hasOffDiagonal = true;
                    break;
                }
                R[i] = hasOffDiagonal;
            }
            return R;
        }

        private List<Set<Integer>> createInitialAggregates(List<Set<Integer>> N, boolean[] R) {
            this.C = new ArrayList<Set<Integer>>();
            for (int i = 0; i < R.length; ++i) {
                if (!R[i]) continue;
                boolean free = true;
                for (int j : N.get(i)) {
                    free &= R[j];
                }
                if (!free) continue;
                this.C.add(new HashSet(N.get(i)));
                for (int j : N.get(i)) {
                    R[j] = false;
                }
            }
            return this.C;
        }

        private List<Set<Integer>> enlargeAggregates(List<Set<Integer>> C, List<Set<Integer>> N, boolean[] R) {
            ArrayList belong = new ArrayList(R.length);
            for (int i = 0; i < R.length; ++i) {
                belong.add(new ArrayList());
            }
            for (int k = 0; k < C.size(); ++k) {
                for (int j : C.get(k)) {
                    ((List)belong.get(j)).add(k);
                }
            }
            int[] intersect = new int[C.size()];
            for (int i = 0; i < R.length; ++i) {
                if (!R[i]) continue;
                Arrays.fill(intersect, 0);
                int largest = 0;
                int maxValue = 0;
                for (int j : N.get(i)) {
                    Iterator iterator = ((List)belong.get(j)).iterator();
                    while (iterator.hasNext()) {
                        int k;
                        int n = k = ((Integer)iterator.next()).intValue();
                        intersect[n] = intersect[n] + 1;
                        if (intersect[k] <= maxValue) continue;
                        largest = k;
                        maxValue = intersect[largest];
                    }
                }
                if (maxValue <= 0) continue;
                R[i] = false;
                C.get(largest).add(i);
            }
            return C;
        }

        private List<Set<Integer>> createFinalAggregates(List<Set<Integer>> C, List<Set<Integer>> N, boolean[] R) {
            for (int i = 0; i < R.length; ++i) {
                if (!R[i]) continue;
                HashSet<Integer> Cn = new HashSet<Integer>();
                for (int j : N.get(i)) {
                    if (!R[j]) continue;
                    R[j] = false;
                    Cn.add(j);
                }
                if (Cn.isEmpty()) continue;
                C.add(Cn);
            }
            return C;
        }
    }
}

