/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatChebyshev
extends AbstractFloatIterativeSolver {
    private float eigmin;
    private float eigmax;
    private FloatMatrix1D p;
    private FloatMatrix1D z;
    private FloatMatrix1D r;
    private FloatMatrix1D q;

    public FloatChebyshev(FloatMatrix1D template, float eigmin, float eigmax) {
        this.p = template.copy();
        this.z = template.copy();
        this.r = template.copy();
        this.q = template.copy();
        this.setEigenvalues(eigmin, eigmax);
    }

    public void setEigenvalues(float eigmin, float eigmax) {
        this.eigmin = eigmin;
        this.eigmax = eigmax;
        if (eigmin <= 0.0f) {
            throw new IllegalArgumentException("eigmin <= 0");
        }
        if (eigmax <= 0.0f) {
            throw new IllegalArgumentException("eigmax <= 0");
        }
        if (eigmin > eigmax) {
            throw new IllegalArgumentException("eigmin > eigmax");
        }
    }

    @Override
    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(A, b, x);
        float alpha = 0.0f;
        float beta = 0.0f;
        float c = 0.0f;
        float d = 0.0f;
        A.zMult(x, this.r.assign(b), -1.0f, 1.0f, false);
        c = (this.eigmax - this.eigmin) / 2.0f;
        d = (this.eigmax + this.eigmin) / 2.0f;
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
                alpha = 2.0f / d;
            } else {
                beta = alpha * c / 2.0f;
                beta *= beta;
                alpha = 1.0f / (d - beta);
                this.p.assign(this.z, FloatFunctions.plusMultFirst(beta));
            }
            A.zMult(this.p, this.q);
            x.assign(this.p, FloatFunctions.plusMultSecond(alpha));
            this.r.assign(this.q, FloatFunctions.plusMultSecond(-alpha));
            this.iter.next();
        }
        return x;
    }
}

